/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.org.OrgSortCodeInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.client.AbstractOrgSortSettingUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgSortSettingUI
extends AbstractOrgSortSettingUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgSortSettingUI.class);
    private String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
    public static final String ORG_TREE_ID = "org_tree_id";
    public static final String LONG_NUMBER = "longnumber";
    public static final String LEVEL = "level";
    public static final String IS_SEAL_UP = "isSealUp";
    boolean isUpdate = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTblSort();
        this.initBtnStatus();
    }

    private void initTblSort() throws Exception {
        String treeId = (String)this.getUIContext().get(ORG_TREE_ID);
        String longNumber = (String)this.getUIContext().get(LONG_NUMBER);
        Integer level = (Integer)this.getUIContext().get(LEVEL);
        Boolean isSealUp = (Boolean)this.getUIContext().get(IS_SEAL_UP);
        Boolean isShowVirtual = (Boolean)this.getUIContext().get("isShowVirtual");
        if (isSealUp == null) {
            isSealUp = false;
        }
        if (isShowVirtual == null) {
            isShowVirtual = false;
        }
        if (treeId != null && longNumber != null && level != null) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("sortCode"));
            view.getSelector().add(new SelectorItemInfo("longNumber"));
            view.getSelector().add(new SelectorItemInfo("unit.name"));
            view.getSelector().add(new SelectorItemInfo("parent.sortCode"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo(LEVEL, (Object)level, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("tree", (Object)treeId, CompareType.EQUALS));
            if (!Boolean.TRUE.equals(isSealUp)) {
                filter.getFilterItems().add(new FilterItemInfo("unit.partAdmin.isSealUp", (Object)isSealUp, CompareType.EQUALS));
            }
            if (!Boolean.TRUE.equals(isShowVirtual)) {
                filter.getFilterItems().add(new FilterItemInfo("unit.partAdmin.isVirtual", (Object)isShowVirtual, CompareType.EQUALS));
            }
            if (this.isViewAdminOrgShowByRange()) {
                Set unitId = this.getOrgRangeSetOrgID();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitId, CompareType.INCLUDE));
            }
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("sortCode"));
            view.getSorter().add(new SorterItemInfo("longNumber"));
            OrgStructureCollection structCol = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view);
            if (structCol.size() > 0) {
                this.tblSort.checkParsed();
                this.tblSort.getSelectManager().setSelectMode(2);
                OrgStructureInfo structInfo = null;
                IRow row = null;
                for (int i = 0; i < structCol.size(); ++i) {
                    structInfo = structCol.get(i);
                    String id = structInfo.getId().toString();
                    String sortCode = structInfo.getSortCode();
                    String longNum = structInfo.getLongNumber();
                    String name = structInfo.getUnit().getName();
                    String parentSortCode = structInfo.getParent().getSortCode();
                    row = this.tblSort.addRow();
                    row.getCell("id").setValue((Object)id);
                    row.getCell("sortCode").setValue((Object)sortCode);
                    row.getCell("longNumber").setValue((Object)longNum);
                    row.getCell("index").setValue((Object)new Integer(i));
                    row.getCell("name").setValue((Object)name);
                    row.getCell("parentSortCode").setValue((Object)parentSortCode);
                }
            }
        }
        if (this.tblSort.getRowCount() > 0) {
            this.tblSort.getSelectManager().select(0, 0);
        }
    }

    private void initBtnStatus() {
        this.handTableEvent();
    }

    @Override
    protected void tblSort_tableClicked(KDTMouseEvent e) throws Exception {
        this.handTableEvent();
    }

    @Override
    protected void tblSort_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.handTableEvent();
    }

    private void handTableEvent() {
        int rowNum = this.tblSort.getRowCount();
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (rowNum != 0 && block != null) {
            int rowIndex = block.getBeginRow();
            if (rowIndex == 0 && rowNum == 1) {
                this.btnTop.setEnabled(false);
                this.btnUp.setEnabled(false);
                this.btnDown.setEnabled(false);
                this.btnBottom.setEnabled(false);
            } else if (rowIndex == 0) {
                this.btnTop.setEnabled(false);
                this.btnUp.setEnabled(false);
                this.btnDown.setEnabled(true);
                this.btnBottom.setEnabled(true);
            } else if (rowIndex == rowNum - 1) {
                this.btnTop.setEnabled(true);
                this.btnUp.setEnabled(true);
                this.btnDown.setEnabled(false);
                this.btnBottom.setEnabled(false);
            } else {
                this.btnTop.setEnabled(true);
                this.btnUp.setEnabled(true);
                this.btnDown.setEnabled(true);
                this.btnBottom.setEnabled(true);
            }
        } else {
            this.btnTop.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnBottom.setEnabled(false);
        }
    }

    @Override
    public void actionTop_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getBeginRow();
            IRow topRow = this.tblSort.getRow(rowIndex);
            this.tblSort.removeRow(rowIndex);
            this.tblSort.addRow(0, topRow);
            this.tblSort.getSelectManager().select(0, 0);
            this.handTableEvent();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getBeginRow();
            IRow upRow = this.tblSort.getRow(rowIndex);
            this.tblSort.removeRow(rowIndex);
            this.tblSort.addRow(rowIndex - 1, upRow);
            this.tblSort.getSelectManager().select(rowIndex - 1, 0);
            this.handTableEvent();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getBeginRow();
            IRow downRow = this.tblSort.getRow(rowIndex);
            this.tblSort.removeRow(rowIndex);
            this.tblSort.addRow(rowIndex + 1, downRow);
            this.tblSort.getSelectManager().select(rowIndex + 1, 0);
            this.handTableEvent();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionBottom_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getBeginRow();
            IRow bottomRow = this.tblSort.getRow(rowIndex);
            int rowCount = this.tblSort.getRowCount();
            this.tblSort.removeRow(rowIndex);
            this.tblSort.addRow(rowCount - 1, bottomRow);
            this.tblSort.getSelectManager().select(rowCount - 1, 0);
            this.handTableEvent();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblSort.getRowCount() == 0) {
            this.getUIWindow().close();
            return;
        }
        ArrayList<OrgSortCodeInfo> orgSortCodeInfoList = new ArrayList<OrgSortCodeInfo>();
        IRow row = null;
        String sortCode = null;
        for (int i = 0; i < this.tblSort.getRowCount(); ++i) {
            OrgSortCodeInfo info;
            row = this.tblSort.getRow(i);
            int index = (Integer)row.getCell("index").getValue();
            String id = row.getCell("id").getValue().toString();
            String longNumber = row.getCell("longNumber").getValue().toString();
            if (row.getCell("sortCode").getValue() != null) {
                sortCode = row.getCell("sortCode").getValue().toString();
                info = new OrgSortCodeInfo(id, sortCode, i + 1, longNumber);
            } else {
                String parentSortCode = row.getCell("parentSortCode").getValue().toString();
                String sortCodeSuffix = OrgSortCodeInfo.getSortCodeSuffix(i + 1);
                String newSortCode = parentSortCode + "!" + sortCodeSuffix;
                info = new OrgSortCodeInfo(id, index, longNumber, newSortCode);
            }
            orgSortCodeInfoList.add(info);
        }
        if (orgSortCodeInfoList.size() > 0) {
            OrgStructureFactory.getRemoteInstance().updateSortCode(orgSortCodeInfoList);
            this.isUpdate = true;
        }
        this.getUIWindow().close();
    }

    protected Set getOrgRangeSetOrgID() throws BOSException, EASBizException {
        HashSet<String> orgIds = new HashSet<String>();
        IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        OrgRangeCollection orgRangeCol = iOrgRange.findFullOrgCol((IObjectPK)userPk, OrgRangeType.ADMIN_ORG_TYPE);
        for (int i = 0; i < orgRangeCol.size(); ++i) {
            OrgRangeInfo orgRangeInfo = orgRangeCol.get(i);
            orgIds.add(orgRangeInfo.getOrg().getId().toString());
        }
        return orgIds;
    }

    private boolean isViewAdminOrgShowByRange() {
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        try {
            if (Administrator.isCUAdmin(null, (IObjectPK)userPk)) {
                return false;
            }
            ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            String paramValue = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"ViewAdminOrgShowByRange");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"ViewAdminOrgShowByRange", (Throwable)e);
            return false;
        }
    }
}

