/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationCollection;
import com.kingdee.eas.basedata.org.OrgTypeRelationFactory;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.client.AbstractOrgTypeRelationMaintainUI;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class OrgTypeRelationMaintainUI
extends AbstractOrgTypeRelationMaintainUI {
    public OrgTypeRelationMaintainUI() throws Exception {
        this.initTable();
        this.initListeners();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadAllOrgTypeRelation();
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        KDComboBox delegatingOrgTypeBox = new KDComboBox();
        DefaultComboBoxModel<OrgType> delegatingOrgTypeModel = new DefaultComboBoxModel<OrgType>();
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        Iterator iter = orgTypeCol.iterator();
        while (iter.hasNext()) {
            OrgTypeInfo orgTypeInfo = (OrgTypeInfo)iter.next();
            OrgType orgType = orgTypeInfo.getOrgType();
            if (orgType.getValue() == -1 || !orgTypeInfo.isBasicOrgType() || orgType.getValue() == 10) continue;
            delegatingOrgTypeModel.addElement(orgType);
        }
        delegatingOrgTypeBox.setModel(delegatingOrgTypeModel);
        KDTDefaultCellEditor delegatingOrgTypeEditor = new KDTDefaultCellEditor((JComboBox)delegatingOrgTypeBox);
        this.tblMain.getColumn(0).setEditor((ICellEditor)delegatingOrgTypeEditor);
        KDComboBox delegatedOrgTypeBox = new KDComboBox();
        DefaultComboBoxModel delegatedOrgTypeModel = new DefaultComboBoxModel();
        Iterator iter1 = orgTypeCol.iterator();
        while (iter1.hasNext()) {
            OrgTypeInfo orgTypeInfo = (OrgTypeInfo)iter.next();
            OrgType orgType = orgTypeInfo.getOrgType();
            if (orgType.getValue() == -1 || !orgTypeInfo.isBasicOrgType() || orgType.getValue() == 10) continue;
            delegatingOrgTypeModel.addElement(orgType);
        }
        delegatedOrgTypeBox.setModel(delegatedOrgTypeModel);
        KDTDefaultCellEditor delegatedOrgTypeEditor = new KDTDefaultCellEditor((JComboBox)delegatedOrgTypeBox);
        this.tblMain.getColumn(1).setEditor((ICellEditor)delegatedOrgTypeEditor);
    }

    private void initListeners() {
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow row = OrgTypeRelationMaintainUI.this.tblMain.addRow();
                row.getCell(2).setValue((Object)new Boolean(false));
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OrgTypeRelationMaintainUI.this.tblMain.getSelectManager().size() == 0) {
                    MsgBox.showInfo((Component)((Object)OrgTypeRelationMaintainUI.this), (String)OrgToolUtils.getResource("res_59"));
                    return;
                }
                int rowIndex = OrgTypeRelationMaintainUI.this.tblMain.getSelectManager().getActiveRowIndex();
                IRow selectedRow = OrgTypeRelationMaintainUI.this.tblMain.getRow(rowIndex);
                if (((Boolean)selectedRow.getCell(2).getValue()).booleanValue()) {
                    MsgBox.showInfo((Component)((Object)OrgTypeRelationMaintainUI.this), (String)OrgToolUtils.getResource("res_60"));
                    return;
                }
                OrgTypeRelationMaintainUI.this.tblMain.removeRow(rowIndex);
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrgTypeRelationCollection relationCol = new OrgTypeRelationCollection();
                OrgTypeRelationInfo relationInfo = null;
                for (int i = 0; i < OrgTypeRelationMaintainUI.this.tblMain.getRowCount(); ++i) {
                    IRow row = OrgTypeRelationMaintainUI.this.tblMain.getRow(i);
                    if (((Boolean)row.getCell(2).getValue()).booleanValue()) continue;
                    OrgType fromType = (OrgType)((Object)row.getCell(0).getValue());
                    OrgType toType = (OrgType)((Object)row.getCell(1).getValue());
                    if (fromType == null) {
                        MsgBox.showError((Component)((Object)OrgTypeRelationMaintainUI.this), (String)OrgToolUtils.getResource("res_61"));
                        return;
                    }
                    if (toType == null) {
                        MsgBox.showError((Component)((Object)OrgTypeRelationMaintainUI.this), (String)OrgToolUtils.getResource("res_62"));
                        return;
                    }
                    relationInfo = new OrgTypeRelationInfo();
                    relationInfo.setFromType((OrgType)((Object)row.getCell(0).getValue()));
                    relationInfo.setToType((OrgType)((Object)row.getCell(1).getValue()));
                    relationCol.add(relationInfo);
                }
                if (relationCol.size() > 0) {
                    try {
                        OrgTypeRelationFactory.getRemoteInstance().batchAddnew(relationCol);
                    }
                    catch (Exception e1) {
                        OrgTypeRelationMaintainUI.this.handUIException(e1);
                    }
                }
            }
        });
    }

    private void loadAllOrgTypeRelation() throws Exception {
        this.tblMain.removeRows();
        IRow row = null;
        OrgTypeRelationCollection typeCol = OrgTypeRelationFactory.getRemoteInstance().getOrgTypeRelationCollection();
        int n = typeCol.size();
        for (int i = 0; i < n; ++i) {
            OrgTypeRelationInfo typeInfo = typeCol.get(i);
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)typeInfo.getFromType());
            row.getCell(1).setValue((Object)typeInfo.getToType());
            row.getCell(2).setValue((Object)new Boolean(true));
            row.getCell(0).getStyleAttributes().setLocked(true);
            row.getCell(1).getStyleAttributes().setLocked(true);
        }
    }
}

