/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationCollection;
import com.kingdee.eas.basedata.org.OrgTypeRelationFactory;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.client.AbstractOrgUnitRelationDeleteUI;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientDefaultImpl;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTableHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;

public class OrgUnitRelationDeleteUI
extends AbstractOrgUnitRelationDeleteUI {
    private static final String resStr = "com.kingdee.eas.basedata.org.client.OrgResource";
    OrgUnitCollection fromUnitCol = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBizPromptOrg();
        this.initTblMain();
        this.initBtnDisplay();
        this.initCbxRelationType();
    }

    private void initBizPromptOrg() {
        this.bizPromptOrg.setDisplayFormat("$name$");
        this.bizPromptOrg.setEditFormat("$number$");
        this.bizPromptOrg.setCommitFormat("$number$");
        this.bizPromptOrg.setEditable(false);
    }

    private void initTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        OrgTableHelper.addTalbeOrgCol(this.tblMain);
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    private void initBtnDisplay() {
        this.btnDeleteOrg.setIcon(EASResource.getIcon((String)"imgTbtn_selectcompany"));
        this.setButtonDefaultStyl(this.btnSave);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void initCbxRelationType() throws Exception {
        DefaultComboBoxModel<OrgTypeRelationInfo> model = new DefaultComboBoxModel<OrgTypeRelationInfo>();
        OrgTypeRelationCollection typeColSource = OrgTypeRelationFactory.getRemoteInstance().getOrgTypeRelationCollection();
        OrgTypeRelationCollection typeCol = OrgHelper.filterOrgTypeRel(typeColSource);
        int n = typeCol.size();
        for (int i = 0; i < n; ++i) {
            OrgTypeRelationInfo typeInfo = typeCol.get(i);
            model.addElement(typeInfo);
        }
        this.cbxRelationType.setModel(model);
        this.cbxRelationType.setRenderer((ListCellRenderer)new CboTypeRelationRenderer());
        this.cbxRelationType.setSelectedIndex(0);
        this.cbxRelationType.setEditable(false);
        this.setSelectorForBizPromptOrg();
    }

    @Override
    protected void cbxRelationType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.setSelectorForBizPromptOrg();
            this.bizPromptOrg.setData(null);
            this.doStateChanged();
        }
    }

    @Override
    protected void bizPromptOrg_stateChanged(ChangeEvent e) throws Exception {
        this.doStateChanged();
    }

    private void setSelectorForBizPromptOrg() {
        NewOrgViewF7PromptDialog toF7 = null;
        OrgTypeRelationInfo selectedValue = (OrgTypeRelationInfo)this.cbxRelationType.getSelectedItem();
        OrgType toType = selectedValue.getToType();
        OrgTypeClientDefaultImpl clientHelper = (OrgTypeClientDefaultImpl)OrgTypeClientCenter.getInstance().getClientImp(toType);
        toF7 = clientHelper.createNewF7ByCondition("TREETYPE_BIZUNIT");
        if (toF7 != null) {
            toF7.setNeedAddOrgRange(false);
            this.bizPromptOrg.setSelector((KDPromptSelector)toF7);
        }
    }

    private void doStateChanged() throws Exception {
        OrgUnitInfo unitInfo = (OrgUnitInfo)this.bizPromptOrg.getData();
        if (unitInfo == null) {
            this.fromUnitCol = null;
        } else {
            String toUnitID = unitInfo.getId().toString();
            OrgTypeRelationInfo selectedValue = (OrgTypeRelationInfo)this.cbxRelationType.getSelectedItem();
            OrgType fromType = selectedValue.getFromType();
            OrgType toType = selectedValue.getToType();
            this.fromUnitCol = OrgUnitRelationFactory.getRemoteInstance().getFromUnit(toUnitID, toType.getValue(), fromType.getValue());
            this.sortOrgUnitColByLongNumber(this.fromUnitCol);
        }
        this.refreshKDTableByFromUnitCol();
    }

    private void sortOrgUnitColByLongNumber(OrgUnitCollection orgUnitCol) {
        int i;
        if (orgUnitCol == null || orgUnitCol.size() == 0) {
            return;
        }
        Object[] orgUnitInfos = orgUnitCol.toArray();
        for (i = 0; i < orgUnitCol.size() - 1; ++i) {
            int min = i;
            for (int j = i + 1; j < orgUnitCol.size(); ++j) {
                if (((OrgUnitInfo)orgUnitInfos[min]).getLongNumber().compareTo(((OrgUnitInfo)orgUnitInfos[j]).getLongNumber()) <= 0) continue;
                min = j;
            }
            if (min == i) continue;
            Object temp = orgUnitInfos[i];
            orgUnitInfos[i] = orgUnitInfos[min];
            orgUnitInfos[min] = temp;
        }
        orgUnitCol.clear();
        for (i = 0; i < orgUnitInfos.length; ++i) {
            orgUnitCol.add((OrgUnitInfo)orgUnitInfos[i]);
        }
    }

    private void refreshKDTableByFromUnitCol() {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        OrgTableHelper.addTalbeOrgCol(this.tblMain);
        if (this.fromUnitCol != null && this.fromUnitCol.size() > 0) {
            OrgUnitInfo fromUnitInfo = null;
            IRow row = null;
            int n = this.fromUnitCol.size();
            for (int i = 0; i < n; ++i) {
                fromUnitInfo = this.fromUnitCol.get(i);
                row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)fromUnitInfo.getId().toString());
                row.getCell("number").setValue((Object)fromUnitInfo.getNumber());
                row.getCell("name").setValue((Object)fromUnitInfo.getName());
                OrgTableHelper.setTableRowValue(fromUnitInfo, row);
            }
        }
    }

    @Override
    protected void btnDeleteOrg_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        int index = selectManager.getActiveRowIndex();
        if (index < 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resStr, (String)"SELECT_ROW_FIRST"));
        } else {
            int size = selectManager.size();
            for (int i = size - 1; i >= 0; --i) {
                KDTSelectBlock block = selectManager.get(i);
                if (block == null) continue;
                for (int j = block.getBottom(); j >= block.getTop(); --j) {
                    this.tblMain.removeRow(j);
                }
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.fromUnitCol == null || this.fromUnitCol.size() == this.tblMain.getRowCount()) {
            return;
        }
        OrgUnitInfo toUnitInfo = (OrgUnitInfo)this.bizPromptOrg.getData();
        if (toUnitInfo != null) {
            HashSet<String> retainedIdSet = new HashSet<String>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                String id = (String)this.tblMain.getRow(i).getCell("id").getValue();
                retainedIdSet.add(id);
            }
            HashSet<OrgUnitInfo> removeFromUnitSet = new HashSet<OrgUnitInfo>();
            for (int i = 0; i < this.fromUnitCol.size(); ++i) {
                OrgUnitInfo fromUnitInfo = this.fromUnitCol.get(i);
                if (retainedIdSet.contains(fromUnitInfo.getId().toString())) continue;
                removeFromUnitSet.add(fromUnitInfo);
            }
            if (removeFromUnitSet.size() > 0) {
                OrgTypeRelationInfo selectedType = (OrgTypeRelationInfo)this.cbxRelationType.getSelectedItem();
                OrgUnitRelationCollection relationCol = new OrgUnitRelationCollection();
                Iterator iter = removeFromUnitSet.iterator();
                while (iter.hasNext()) {
                    OrgUnitRelationInfo relationInfo = new OrgUnitRelationInfo();
                    relationInfo.setTypeRelation(selectedType);
                    relationInfo.setFromUnit((OrgUnitInfo)iter.next());
                    relationInfo.setToUnit(toUnitInfo);
                    relationCol.add(relationInfo);
                }
                if (relationCol.size() > 0) {
                    try {
                        List cannotDelFromUnit = OrgDelegateFacadeFactory.getRemoteInstance().batchDeleteDelegate(relationCol);
                        if (cannotDelFromUnit == null || cannotDelFromUnit.size() == 0) {
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resStr, (String)"SAVE_SUCCESS"));
                        } else {
                            String delError = EASResource.getString((String)resStr, (String)"MSG_DEL_RELATION_ERR");
                            MsgBox.showDetailAndOK((Component)((Object)this), (String)delError, (String)EASResource.getString((String)resStr, (String)"CANNOT_DEL_COST_DELEGATE"), (int)8188);
                            for (int i = 0; i < cannotDelFromUnit.size(); ++i) {
                                removeFromUnitSet.remove(cannotDelFromUnit.get(i));
                            }
                        }
                        Iterator iter1 = removeFromUnitSet.iterator();
                        while (iter1.hasNext()) {
                            this.fromUnitCol.remove((OrgUnitInfo)iter1.next());
                        }
                        this.refreshKDTableByFromUnitCol();
                    }
                    catch (Exception ex) {
                        this.handleException(ex);
                        this.refreshKDTableByFromUnitCol();
                    }
                }
            }
        }
    }

    private class CboTypeRelationRenderer
    extends KDLabel
    implements ListCellRenderer {
        public CboTypeRelationRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof OrgTypeRelationInfo)) {
                this.setText(EASResource.getString((String)OrgUnitRelationDeleteUI.resStr, (String)"OrgRelation_All"));
            } else {
                OrgTypeRelationInfo typeInfo = (OrgTypeRelationInfo)value;
                String fromType = typeInfo.getFromType().getAlias();
                String toType = typeInfo.getToType().getAlias();
                String msg = EASResource.getString((String)OrgUnitRelationDeleteUI.resStr, (String)"OrgRelation_Delegate_1");
                MessageFormat mf = new MessageFormat(msg);
                String result = mf.format(new String[]{fromType, toType});
                this.setText(result);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

