/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationCollection;
import com.kingdee.eas.basedata.org.OrgTypeRelationFactory;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.client.AbstractOrgUnitRelationMaintainUI;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;

public class OrgUnitRelationMaintainUI
extends AbstractOrgUnitRelationMaintainUI {
    private static final String resStr = "com.kingdee.eas.basedata.org.client.OrgResource";
    OrgUnitCollection fromUnitCol = null;
    OrgUnitCollection newFromUnitCol = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBizPromptOrg();
        this.initTblMain();
        this.initBtnDisplay();
        this.initCbxRelationType();
    }

    private void initBizPromptOrg() {
        this.bizPromptOrg.setDisplayFormat("$name$");
        this.bizPromptOrg.setEditFormat("$number$");
        this.bizPromptOrg.setCommitFormat("$number$");
        this.bizPromptOrg.setEditable(false);
    }

    private void initTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(3).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(4).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(5).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(6).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(7).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(8).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(9).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(10).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(11).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(12).getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    private void initBtnDisplay() {
        this.btnSelectOrg.setIcon(EASResource.getIcon((String)"imgTbtn_selectcompany"));
        this.setButtonDefaultStyl(this.btnSave);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void initCbxRelationType() throws Exception {
        DefaultComboBoxModel<OrgTypeRelationInfo> model = new DefaultComboBoxModel<OrgTypeRelationInfo>();
        OrgTypeRelationCollection typeCol = OrgTypeRelationFactory.getRemoteInstance().getOrgTypeRelationCollection();
        int n = typeCol.size();
        for (int i = 0; i < n; ++i) {
            OrgTypeRelationInfo typeInfo = typeCol.get(i);
            model.addElement(typeInfo);
        }
        this.cbxRelationType.setModel(model);
        this.cbxRelationType.setRenderer((ListCellRenderer)new CboTypeRelationRenderer());
        this.cbxRelationType.setSelectedIndex(0);
        this.cbxRelationType.setEditable(false);
        this.setSelectorForBizPromptOrg();
    }

    @Override
    protected void cbxRelationType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.setSelectorForBizPromptOrg();
            this.bizPromptOrg.setData(null);
            this.doStateChanged();
        }
    }

    private void setSelectorForBizPromptOrg() {
        OrgF7PromptDialog toF7 = null;
        OrgTypeRelationInfo selectedValue = (OrgTypeRelationInfo)this.cbxRelationType.getSelectedItem();
        OrgType toType = selectedValue.getToType();
        toF7 = OrgTypeClientCenter.getInstance().getClientImp(toType).createF7ByCondition("TREETYPE_BIZUNIT");
        if (toF7 != null) {
            toF7.disablePerm();
            this.bizPromptOrg.setSelector((KDPromptSelector)toF7);
        }
    }

    @Override
    protected void bizPromptOrg_stateChanged(ChangeEvent e) throws Exception {
        this.doStateChanged();
    }

    private void doStateChanged() throws Exception {
        OrgUnitInfo unitInfo = (OrgUnitInfo)this.bizPromptOrg.getData();
        if (unitInfo == null) {
            this.fromUnitCol = null;
            this.newFromUnitCol = null;
        } else {
            String toUnitID = unitInfo.getId().toString();
            OrgTypeRelationInfo selectedValue = (OrgTypeRelationInfo)this.cbxRelationType.getSelectedItem();
            OrgType fromType = selectedValue.getFromType();
            OrgType toType = selectedValue.getToType();
            this.newFromUnitCol = this.fromUnitCol = OrgUnitRelationFactory.getRemoteInstance().getFromUnit(toUnitID, toType.getValue(), fromType.getValue());
            this.sortOrgUnitColByLongNumber(this.fromUnitCol);
        }
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        if (this.fromUnitCol != null && this.fromUnitCol.size() > 0) {
            OrgUnitInfo fromUnitInfo = null;
            IRow row = null;
            int n = this.fromUnitCol.size();
            for (int i = 0; i < n; ++i) {
                fromUnitInfo = this.fromUnitCol.get(i);
                row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)fromUnitInfo.getId().toString());
                row.getCell("number").setValue((Object)fromUnitInfo.getNumber());
                row.getCell("name").setValue((Object)fromUnitInfo.getName());
                row.getCell("isAdminOrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsAdminOrgUnit()));
                row.getCell("isCompanyOrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsCompanyOrgUnit()));
                row.getCell("isPurchaseOrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsPurchaseOrgUnit()));
                row.getCell("isSaleOrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsSaleOrgUnit()));
                row.getCell("isStorageOrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsStorageOrgUnit()));
                row.getCell("isHROrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsHROrgUnit()));
                row.getCell("isCostOrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsCostOrgUnit()));
                row.getCell("isTransportOrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsTransportOrgUnit()));
                row.getCell("isQualityOrgUnit").setValue((Object)new Boolean(fromUnitInfo.isIsQualityOrgUnit()));
                row.getCell("isCU").setValue((Object)new Boolean(fromUnitInfo.isIsCU()));
            }
        }
    }

    private void sortOrgUnitColByLongNumber(OrgUnitCollection orgUnitCol) {
        int i;
        if (orgUnitCol == null || orgUnitCol.size() == 0) {
            return;
        }
        Object[] orgUnitInfos = orgUnitCol.toArray();
        for (i = 0; i < orgUnitCol.size() - 1; ++i) {
            int min = i;
            for (int j = i + 1; j < orgUnitCol.size(); ++j) {
                if (((OrgUnitInfo)orgUnitInfos[min]).getLongNumber().compareTo(((OrgUnitInfo)orgUnitInfos[j]).getLongNumber()) <= 0) continue;
                min = j;
            }
            if (min == i) continue;
            Object temp = orgUnitInfos[i];
            orgUnitInfos[i] = orgUnitInfos[min];
            orgUnitInfos[min] = temp;
        }
        orgUnitCol.clear();
        for (i = 0; i < orgUnitInfos.length; ++i) {
            orgUnitCol.add((OrgUnitInfo)orgUnitInfos[i]);
        }
    }

    @Override
    protected void btnSelectOrg_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo unitInfo = (OrgUnitInfo)this.bizPromptOrg.getData();
        if (unitInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resStr, (String)"PLEASE_SELECT_TO_UNIT"));
            return;
        }
        HashSet<String> fromUnitIdSet = new HashSet<String>();
        if (this.fromUnitCol != null && this.fromUnitCol.size() > 0) {
            for (int i = 0; i < this.fromUnitCol.size(); ++i) {
                fromUnitIdSet.add(this.fromUnitCol.get(i).getId().toString());
            }
        }
        OrgF7PromptDialog fromF7 = null;
        OrgTypeRelationInfo selectedValue = (OrgTypeRelationInfo)this.cbxRelationType.getSelectedItem();
        OrgType fromType = selectedValue.getFromType();
        fromF7 = OrgTypeClientCenter.getInstance().getClientImp(fromType).createF7ByCondition("TREETYPE_BIZUNIT");
        if (fromF7 != null) {
            OrgUnitInfo[] selectedUnitInfos;
            fromF7.disablePerm();
            fromF7.setMultiSelect(true);
            fromF7.setCheckedOrgIDs(fromUnitIdSet);
            fromF7.setUnChangeableOrgIDs(fromUnitIdSet);
            fromF7.show();
            if (!fromF7.isCanceled() && (selectedUnitInfos = (OrgUnitInfo[])fromF7.getData()) != null) {
                this.addRowToTable(selectedUnitInfos);
            }
        }
    }

    private void addRowToTable(OrgUnitInfo[] selectedUnitInfos) {
        this.newFromUnitCol = new OrgUnitCollection();
        for (int i = 0; i < selectedUnitInfos.length; ++i) {
            this.newFromUnitCol.add(selectedUnitInfos[i]);
        }
        this.sortOrgUnitColByLongNumber(this.newFromUnitCol);
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        IRow row = null;
        for (int i = 0; i < this.newFromUnitCol.size(); ++i) {
            OrgUnitInfo unitInfo = this.newFromUnitCol.get(i);
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)unitInfo.getId().toString());
            row.getCell("number").setValue((Object)unitInfo.getNumber());
            row.getCell("name").setValue((Object)unitInfo.getName());
            row.getCell("isAdminOrgUnit").setValue((Object)new Boolean(unitInfo.isIsAdminOrgUnit()));
            row.getCell("isCompanyOrgUnit").setValue((Object)new Boolean(unitInfo.isIsCompanyOrgUnit()));
            row.getCell("isPurchaseOrgUnit").setValue((Object)new Boolean(unitInfo.isIsPurchaseOrgUnit()));
            row.getCell("isSaleOrgUnit").setValue((Object)new Boolean(unitInfo.isIsSaleOrgUnit()));
            row.getCell("isStorageOrgUnit").setValue((Object)new Boolean(unitInfo.isIsStorageOrgUnit()));
            row.getCell("isHROrgUnit").setValue((Object)new Boolean(unitInfo.isIsHROrgUnit()));
            row.getCell("isCostOrgUnit").setValue((Object)new Boolean(unitInfo.isIsCostOrgUnit()));
            row.getCell("isTransportOrgUnit").setValue((Object)new Boolean(unitInfo.isIsTransportOrgUnit()));
            row.getCell("isQualityOrgUnit").setValue((Object)new Boolean(unitInfo.isIsQualityOrgUnit()));
            row.getCell("isCU").setValue((Object)new Boolean(unitInfo.isIsCU()));
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo toUnitInfo = (OrgUnitInfo)this.bizPromptOrg.getData();
        if (toUnitInfo != null && this.newFromUnitCol != null && this.newFromUnitCol.size() > 0) {
            OrgTypeRelationInfo selectedType = (OrgTypeRelationInfo)this.cbxRelationType.getSelectedItem();
            OrgUnitRelationCollection relationCol = new OrgUnitRelationCollection();
            for (int i = 0; i < this.newFromUnitCol.size(); ++i) {
                OrgUnitInfo fromUnitInfo = this.newFromUnitCol.get(i);
                if (this.fromUnitCol != null && this.fromUnitCol.containsKey(fromUnitInfo.getId())) continue;
                OrgUnitRelationInfo relationInfo = new OrgUnitRelationInfo();
                relationInfo.setTypeRelation(selectedType);
                relationInfo.setFromUnit(fromUnitInfo);
                relationInfo.setToUnit(toUnitInfo);
                relationCol.add(relationInfo);
            }
            if (relationCol.size() > 0) {
                OrgDelegateFacadeFactory.getRemoteInstance().batchAddNewDelegate(relationCol);
                this.fromUnitCol = this.newFromUnitCol;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resStr, (String)"SAVE_SUCCESS"));
            }
        }
    }

    private class CboTypeRelationRenderer
    extends KDLabel
    implements ListCellRenderer {
        public CboTypeRelationRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof OrgTypeRelationInfo)) {
                this.setText(EASResource.getString((String)OrgUnitRelationMaintainUI.resStr, (String)"OrgRelation_All"));
            } else {
                OrgTypeRelationInfo typeInfo = (OrgTypeRelationInfo)value;
                String fromType = typeInfo.getFromType().getAlias();
                String toType = typeInfo.getToType().getAlias();
                String msg = EASResource.getString((String)OrgUnitRelationMaintainUI.resStr, (String)"OrgRelation_Delegate_1");
                MessageFormat mf = new MessageFormat(msg);
                String result = mf.format(new String[]{fromType, toType});
                this.setText(result);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

