/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IOrgVersionMgrFacade;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class OrgVersionClientUtils {
    private static Color disableColor = new Color(77, 77, 77);
    private static final String ENABLE_FLAG = "ENABLE_FLAG";

    public static JTree buildTree(JTree tree, OrgUnitInfo parentVersionInfo, OrgUnitCollection versionCol) throws Exception {
        KDTreeNode rootNode = new KDTreeNode((Object)parentVersionInfo);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        OrgVersionClientUtils.buildChildren(rootNode, parentVersionInfo, versionCol);
        tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
        tree.setShowsRootHandles(true);
        return tree;
    }

    private static void buildChildren(KDTreeNode parentNode, OrgUnitInfo parentInfo, OrgUnitCollection col) {
        parentNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        if (col == null || col.size() == 0) {
            return;
        }
        String rootLongNumber = null;
        rootLongNumber = parentInfo.getLongNumber();
        OrgUnitInfo[] infos = new OrgUnitInfo[col.size()];
        KDTreeNode[] treeNodes = new KDTreeNode[col.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = col.get(i);
            treeNodes[i] = new KDTreeNode((Object)infos[i]);
            treeNodes[i].setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        }
        String longNumber = null;
        block1: for (int i = 0; i < infos.length; ++i) {
            longNumber = infos[i].getLongNumber();
            int index = longNumber.lastIndexOf("!");
            if (index <= 0) continue;
            String parentLongNumber = longNumber.substring(0, index);
            if (parentLongNumber.equals(rootLongNumber)) {
                parentNode.add((MutableTreeNode)treeNodes[i]);
                continue;
            }
            String longNum = null;
            for (int j = 0; j < infos.length; ++j) {
                longNum = infos[j].getLongNumber();
                if (!longNum.equals(parentLongNumber)) continue;
                treeNodes[j].add((MutableTreeNode)treeNodes[i]);
                continue block1;
            }
        }
    }

    public static OrgType getOrgTypeFromTreeId(String treeId) {
        return OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeId).getOrgType();
    }

    public static OrgUnitInfo getOrgUnitVersionInfo(OrgType orgType, String versionNumber, BOSUuid id) throws Exception {
        VersionPK versionPK = new VersionPK(versionNumber, id);
        return OrgVersionClientUtils.getOrgVersionFacade().getUnitVersionInfoByOrgType(versionPK, orgType);
    }

    public static OrgUnitCollection getObjectVersionCollection(OrgType orgType, String versionNumber, String longNumber) throws Exception {
        return OrgVersionClientUtils.getOrgVersionFacade().getOrgUnitVersionCollection(versionNumber, longNumber, orgType);
    }

    private static IOrgVersionMgrFacade getOrgVersionFacade() throws Exception {
        return OrgVersionMgrFacadeFactory.getRemoteInstance();
    }

    public static void disableTreeNode(DefaultKingdeeTreeNode treeNode) {
        treeNode.setTextColor(disableColor);
        treeNode.setCheckBoxEnabled(false);
        treeNode.setCheckBoxVisible(false);
    }

    public static boolean isTreeNodeDisable(DefaultKingdeeTreeNode treeNode) {
        if (treeNode.getTextColor() == null) {
            return true;
        }
        return disableColor.equals(treeNode.getTextColor());
    }

    public static OrgUnitInfo getUserObject(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof OrgUnitInfo) {
            return (OrgUnitInfo)node.getUserObject();
        }
        return null;
    }

    public static void filterTreeNode(DefaultKingdeeTreeNode root, HashMap orgUnitIDs, boolean useFilter, boolean checkValid) {
        boolean hold = false;
        boolean containSub = false;
        if (root != null) {
            OrgUnitInfo unitInfo = OrgVersionClientUtils.getUserObject(root);
            if (unitInfo != null) {
                if (useFilter) {
                    if (orgUnitIDs != null) {
                        Boolean b = (Boolean)orgUnitIDs.get(unitInfo.getId().toString());
                        boolean bl = hold = b != null;
                        if (b != null) {
                            containSub = b;
                        }
                    }
                    if (hold) {
                        boolean valid = true;
                        if (checkValid) {
                            valid = OrgVersionClientUtils.isUnitValidByDate(unitInfo);
                        }
                        OrgVersionClientUtils.setUserObjectEnable(root, valid);
                    } else {
                        OrgVersionClientUtils.setUserObjectEnable(root, false);
                    }
                } else {
                    boolean valid = true;
                    if (checkValid) {
                        valid = OrgVersionClientUtils.isUnitValidByDate(unitInfo);
                    }
                    OrgVersionClientUtils.setUserObjectEnable(root, valid);
                }
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (hold && containSub) {
                    OrgVersionClientUtils.filterTreeNode(node, orgUnitIDs, false, checkValid);
                    continue;
                }
                OrgVersionClientUtils.filterTreeNode(node, orgUnitIDs, useFilter, checkValid);
            }
        }
    }

    public static void setUserObjectEnable(DefaultKingdeeTreeNode node, boolean enable) {
        if (!enable) {
            OrgVersionClientUtils.disableTreeNode(node);
            return;
        }
        if (node.getUserObject() instanceof OrgUnitInfo) {
            OrgUnitInfo info = (OrgUnitInfo)node.getUserObject();
            info.put(ENABLE_FLAG, Boolean.TRUE);
        }
    }

    public static boolean isUserObjectEnable(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof OrgUnitInfo) {
            OrgUnitInfo versionInfo = (OrgUnitInfo)node.getUserObject();
            Boolean flag = (Boolean)versionInfo.get(ENABLE_FLAG);
            return flag != null;
        }
        return false;
    }

    private static boolean isUnitValidByDate(OrgUnitInfo unitInfo) {
        Date date = new Date(System.currentTimeMillis());
        boolean afterEffectDate = false;
        boolean beforeInvalidDate = false;
        if (unitInfo.getEffectDate() != null) {
            afterEffectDate = date.after(unitInfo.getEffectDate());
        }
        if (unitInfo.getInvalidDate() != null) {
            beforeInvalidDate = date.before(unitInfo.getInvalidDate());
        }
        return afterEffectDate && beforeInvalidDate;
    }

    public static TreeModel buildTreeModel(String versionNumber, OrgType orgType, String rootUnitID, HashMap orgUnitIDs, boolean useFilter, boolean invalidEnable, boolean isContainSealUp, boolean isShowVirtual) throws Exception {
        TreeModel treeModel = OrgVersionClientUtils.innerBuildTreeModel(versionNumber, orgType, rootUnitID, isContainSealUp, isShowVirtual);
        if (treeModel.getRoot() != null && ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() != null) {
            OrgVersionClientUtils.filterTreeNode((DefaultKingdeeTreeNode)treeModel.getRoot(), orgUnitIDs, useFilter, invalidEnable);
            OrgVersionClientUtils.clipTreeNode((DefaultKingdeeTreeNode)treeModel.getRoot());
        }
        return treeModel;
    }

    private static TreeModel innerBuildTreeModel(String versionNumber, OrgType orgType, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual) throws Exception {
        OrgUnitInfo parentVersionInfo = OrgVersionClientUtils.getOrgUnitVersionInfo(orgType, versionNumber, BOSUuid.read((String)rootUnitID));
        if (parentVersionInfo == null) {
            return new DefaultTreeModel(null);
        }
        KDTreeNode rootNode = new KDTreeNode((Object)parentVersionInfo);
        OrgUnitCollection versionCol = OrgVersionClientUtils.getObjectVersionCollection(orgType, versionNumber, parentVersionInfo.getLongNumber());
        OrgVersionClientUtils.buildChildren(rootNode, parentVersionInfo, versionCol);
        return new DefaultTreeModel((TreeNode)rootNode);
    }

    public static void clipTreeNode(DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode node = null;
        if (root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                OrgVersionClientUtils.clipTreeNode(node);
                if (node.getChildCount() != 0 || OrgVersionClientUtils.isUserObjectEnable(node)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    public static void clipTreeNodeByColor(DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode node = null;
        if (root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                OrgVersionClientUtils.clipTreeNodeByColor(node);
                if (node.getChildCount() != 0 || !OrgVersionClientUtils.isTreeNodeDisable(node)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    public static String getDisplayInvalidDate(Date date) {
        DateFormat formater = BOSLocaleUtil.getDateFormat();
        return formater.format(date);
    }
}

