/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.AbstractOrgVersionF7UI2;
import com.kingdee.eas.basedata.org.client.OrgF7SelectException;
import com.kingdee.eas.basedata.org.client.OrgVersionClientUtils;
import com.kingdee.eas.basedata.org.client.OrgVersionF7PromptDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class OrgVersionF7UI2
extends AbstractOrgVersionF7UI2 {
    private OrgVersionF7PromptDialog dialog;
    private boolean isCancel = true;
    private ArrayList returnValue = null;

    public OrgVersionF7UI2() throws Exception {
        DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
        sm.setSelectionMode(2);
        this.tOrgTree.setSelectionModel((TreeSelectionModel)sm);
        this.tOrgTree.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(OrgVersionF7UI2.this.tOrgTree.getModel().getRoot())) {
                    OrgVersionF7UI2.this.tOrgTree.expandPath(new TreePath(OrgVersionF7UI2.this.tOrgTree.getModel().getRoot()));
                }
            }
        });
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnAllSel.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllClr.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.initChkShowAll();
    }

    private void initChkShowAll() {
        this.chkShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OrgVersionF7UI2.this.btnRefresh_actionPerformed(null);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)((Object)OrgVersionF7UI2.this), (Throwable)exc);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dialog = (OrgVersionF7PromptDialog)this.getUIContext().get("OrgF7Proxy");
        this.tOrgTree.setShowCheckBox(false);
        if (this.dialog.isMultiSelect()) {
            this.tOrgTree.setShowCheckBox(true);
            this.btnAllSel.setVisible(true);
            this.btnAllClr.setVisible(true);
            if (this.dialog.isCascadingSelection()) {
                this.tOrgTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

                    public void nodeStateChange(TreeNodeStateChangeEvent event) {
                        OrgVersionF7UI2.this.doTreeNodeStateChange(event);
                    }
                });
            } else if (this.dialog.getORGF7TreeNodeCheckBoxChangeListener() != null) {
                this.tOrgTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

                    public void nodeStateChange(TreeNodeStateChangeEvent event) {
                        OrgVersionF7UI2.this.dialog.getORGF7TreeNodeCheckBoxChangeListener().onTreeNodeCheckBoxChange(OrgVersionF7UI2.this.tOrgTree, (DefaultKingdeeTreeNode)event.getNode());
                    }
                });
            } else {
                this.tOrgTree.setSyncChecked(this.dialog.isSynCheck());
            }
        }
        this.chkContainSealUp.setVisible(this.dialog.isShowContainSealUp());
        this.chkShowVirtual.setVisible(false);
        this.setChkShowVirtualStatus();
        this.buildTree();
    }

    private void doTreeNodeStateChange(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        boolean selected = node.isChecked();
        this.selectAllChildrenOfTheSelectedNode(node, selected);
        this.tOrgTree.repaint();
    }

    private void selectAllChildrenOfTheSelectedNode(DefaultKingdeeTreeNode node, boolean selected) {
        DefaultKingdeeTreeNode subNode = null;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (this.canTheNodeBeSelected(subNode)) {
                subNode.setChecked(selected);
            }
            this.selectAllChildrenOfTheSelectedNode(subNode, selected);
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    public void doLayout() {
        super.doLayout();
        this.tOrgTree.requestFocusInWindow();
        if (this.tOrgTree.getModel() != null && this.tOrgTree.getModel().getRoot() != null) {
            this.tOrgTree.setSelectionNode((DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot());
        }
    }

    private void setChkShowVirtualStatus() {
        OrgViewType orgViewType = this.dialog.getOrgViewType();
        if (orgViewType == null) {
            return;
        }
        if (0 == orgViewType.getValue()) {
            this.chkShowVirtual.setVisible(true);
        }
    }

    private void buildTree() throws Exception {
        TreeModel treeModel = this.dialog.buildTreeModel();
        this.tOrgTree.setModel(treeModel);
        if (treeModel.getRoot() == null || ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() == null) {
            this.tOrgTree.setRootVisible(false);
        } else {
            this.tOrgTree.setRootVisible(true);
        }
        this.tOrgTree.setShowsRootHandles(true);
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        if (root.isChecked()) {
            this.dialog.checkSelect(root);
            list.add(root.getUserObject());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    public void displayChkShowAll() {
        this.chkShowAll.setVisible(true);
    }

    public ArrayList getReturnValue() {
        return this.returnValue;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new ArrayList();
        } else {
            this.returnValue.clear();
        }
        try {
            if (this.dialog.isMultiSelect()) {
                DefaultKingdeeTreeNode root;
                if (this.tOrgTree.getModel() != null && (root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot()) != null) {
                    this.traceNode(root, this.returnValue);
                }
            } else {
                TreePath path = this.tOrgTree.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (OrgVersionClientUtils.isTreeNodeDisable(node)) {
                        throw OrgF7SelectException.SelectValidOrg;
                    }
                    if (node.getUserObject() != null) {
                        this.dialog.checkSelect(node);
                        this.returnValue.add(node.getUserObject());
                    }
                }
            }
            if (this.returnValue.size() == 0) {
                throw OrgF7SelectException.SelectOne;
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
        catch (OrgF7SelectException f7e) {
            MsgBox.showInfo((Component)((Object)this), (String)f7e.getMsg());
        }
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkShowAll.isVisible()) {
            this.dialog.setIsCUFilter(!this.chkShowAll.isSelected());
        }
        this.buildTree();
        this.tOrgTree.requestFocusInWindow();
    }

    @Override
    protected void chkContainSealUp_itemStateChanged(ItemEvent e) throws Exception {
        super.chkContainSealUp_itemStateChanged(e);
        if (this.chkContainSealUp.isSelected()) {
            this.dialog.setContainSealUp(true);
        } else {
            this.dialog.setContainSealUp(false);
        }
        this.buildTree();
    }

    @Override
    protected void chkShowVirtual_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowVirtual_itemStateChanged(e);
        if (this.chkShowVirtual.isSelected()) {
            this.dialog.setShowVirtual(true);
        } else {
            this.dialog.setShowVirtual(false);
        }
        this.buildTree();
    }

    @Override
    protected void btnAllSel_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(true);
    }

    @Override
    protected void btnAllClr_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(false);
    }

    private void doAllSelAndAllClr(boolean selected) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot();
        if (this.tOrgTree.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.tOrgTree.getSelectionPath().getLastPathComponent();
        }
        if (root == null) {
            return;
        }
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (!this.canTheNodeBeSelected(node)) continue;
            node.setChecked(selected);
        }
        this.tOrgTree.repaint();
    }

    @Override
    protected void tOrgTree_mouseClicked(MouseEvent e) throws Exception {
        super.tOrgTree_mouseClicked(e);
        TreePath path = this.tOrgTree.getClosestPath(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (this.dialog.isMultiSelect()) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.btnOk_actionPerformed(null);
        }
    }
}

