/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.OrgBudgetViewInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.AbstractOrgViewF7UI;
import com.kingdee.eas.basedata.org.client.OrgF7SelectException;
import com.kingdee.eas.basedata.org.client.OrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class OrgViewF7UI
extends AbstractOrgViewF7UI {
    private OrgViewF7PromptDialog dialog;
    private boolean isCancel = true;
    private ArrayList returnValue = null;
    private boolean openEvent = false;

    public OrgViewF7UI() throws Exception {
        DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
        sm.setSelectionMode(1);
        this.tOrgTree.setSelectionModel((TreeSelectionModel)sm);
        this.tOrgTree.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(OrgViewF7UI.this.tOrgTree.getModel().getRoot())) {
                    OrgViewF7UI.this.tOrgTree.expandPath(new TreePath(OrgViewF7UI.this.tOrgTree.getModel().getRoot()));
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tOrgTree_mouseClicked(MouseEvent e) throws Exception {
        super.tOrgTree_mouseClicked(e);
        TreePath path = this.tOrgTree.getClosestPath(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (this.dialog.isMultiSelect()) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.btnOK_actionPerformed(null);
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new ArrayList();
        } else {
            this.returnValue.clear();
        }
        try {
            if (this.dialog.isMultiSelect()) {
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot();
                this.traceNode(root, this.returnValue);
            } else {
                TreePath path = this.tOrgTree.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (OrgF7InnerUtils.isTreeNodeDisable(node)) {
                        throw OrgF7SelectException.SelectValidOrg;
                    }
                    this.dialog.checkSelect(node);
                    this.returnValue.add(node.getUserObject());
                }
            }
            if (this.returnValue.size() == 0) {
                throw OrgF7SelectException.SelectOne;
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
        catch (OrgF7SelectException f7e) {
            MsgBox.showInfo((Component)((Object)this), (String)f7e.getMsg());
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public ArrayList getReturnValue() {
        return this.returnValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dialog = (OrgViewF7PromptDialog)this.getUIContext().get("OrgF7Proxy");
        this.tOrgTree.setShowCheckBox(this.dialog.isMultiSelect());
        this.openEvent = false;
        this.initOrgViewTypeCombBox(this.dialog.getOrgViewTypes());
        this.openEvent = true;
        this.cbOrgViewType.setSelectedItem(null);
        this.cbOrgViewType.setSelectedIndex(0);
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        if (root.getUserObject() instanceof OrgBudgetViewInfo && root.isChecked()) {
            this.dialog.checkSelect(root);
            list.add(root.getUserObject());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    @Override
    protected void cbOrgViewType_itemStateChanged(ItemEvent e) throws Exception {
        super.cbOrgViewType_itemStateChanged(e);
        if (!this.openEvent) {
            return;
        }
        if (e.getStateChange() != 1) {
            return;
        }
        OrgViewType viewType = (OrgViewType)((Object)this.cbOrgViewType.getSelectedItem());
        OrgViewUtils.buildOrgViewTree(this.dialog.ctrlUnitPK, this.dialog.userPK, viewType, this.tOrgTree, this.dialog.uiPK, this.dialog.actionPK, this.dialog.invalidEnable);
        this.tvOrgTree.setTitle(viewType.toString());
    }

    private void initOrgViewTypeCombBox(OrgViewType[] orgViewTypes) {
        this.cbOrgViewType.removeAllItems();
        for (int i = 0; i < orgViewTypes.length; ++i) {
            this.cbOrgViewType.addItem((Object)orgViewTypes[i]);
        }
        if (orgViewTypes.length == 1) {
            this.cbOrgViewType.setVisible(false);
            this.tvOrgTree.setBounds(this.tvOrgTree.getX(), 5, this.tvOrgTree.getWidth(), this.tvOrgTree.getHeight() + 25);
        }
    }

    protected void initKeyStroke() {
    }
}

