/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.ImportCompayFieldsEnum;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgTypeForF7;
import com.kingdee.eas.basedata.org.client.AbstractOuF7UI;
import com.kingdee.eas.basedata.org.client.OrgF7SelectException;
import com.kingdee.eas.basedata.org.client.OuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.helper.OrgUIDataUtil;
import com.kingdee.eas.basedata.org.client.helper.OuF7SetCacheHelper;
import com.kingdee.eas.basedata.org.client.tree.util.OrgTreeUtil;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class OuF7UI
extends AbstractOuF7UI {
    private static Logger logger = Logger.getLogger(OuF7UI.class);
    private OuF7PromptDialog dialog;
    private boolean isCancel = true;
    private Set returnValue = null;
    private FullOrgUnitInfo[] allOrgInfoCache = null;
    private FullOrgUnitInfo curCUOrgInfo = null;
    private boolean loadAllData = false;
    OrgTypeForF7 oldOrgType = null;
    private OuF7SetCacheHelper setCacheHelper = new OuF7SetCacheHelper();
    private boolean isInOnload = false;
    private boolean isSearched = false;

    public OuF7UI() throws Exception {
        DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
        sm.setSelectionMode(2);
        this.tOrgTree.setSelectionModel((TreeSelectionModel)sm);
        this.tOrgTree.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(OuF7UI.this.tOrgTree.getModel().getRoot())) {
                    OuF7UI.this.tOrgTree.expandPath(new TreePath(OuF7UI.this.tOrgTree.getModel().getRoot()));
                }
            }
        });
        this.initOrgTypeModel();
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.checkBlured.setSelected(true);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.NUMBER);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.NAME);
        this.comboField.setSelectedIndex(0);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (OuF7UI.this.dialog != null && OuF7UI.this.dialog.isCumulate()) {
                        Set valueSet = OuF7UI.this.setCacheHelper.getSetByF7Type(OuF7UI.this.oldOrgType);
                        OuF7UI.this.saveReturnValues(valueSet);
                    }
                    OuF7UI.this.builderTree();
                    OuF7UI.this.isSearched = true;
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Component)((Object)OuF7UI.this), (Throwable)ex);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this.isInOnload = true;
        try {
            super.onLoad();
            this.tOrgTree.setModel((TreeModel)new DefaultTreeModel(null));
            this.dialog = (OuF7PromptDialog)this.getUIContext().get("OuF7Proxy");
            this.tOrgTree.setShowCheckBox(this.dialog.isMultiSelect());
            this.builderTree();
            this.btnAllSel.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
            this.btnAllClr.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
            if (this.dialog.isMultiSelect()) {
                this.btnAllSel.setVisible(true);
                this.btnAllClr.setVisible(true);
            }
            this.btnAllSel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        OuF7UI.this.doAllSelAndAllClr(true);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"error", (Throwable)e1);
                    }
                }
            });
            this.btnAllClr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        OuF7UI.this.doAllSelAndAllClr(false);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"error", (Throwable)e1);
                    }
                }
            });
            this.chkContainSealUp.setSelected(false);
            this.chkContainSealUp.setVisible(this.dialog.isShowContainSealUp());
            if (this.tOrgTree.getModel().getRoot() != null && ((DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot()).getChildCount() > 0) {
                this.tOrgTree.setSelectionNode((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot()).getChildAt(0));
            }
        }
        finally {
            this.isInOnload = false;
        }
    }

    private void initOrgTypeModel() {
        this.cbOrgType.removeAllItems();
        Iterator iter = OrgTypeForF7.iterator();
        while (iter.hasNext()) {
            this.cbOrgType.addItem(iter.next());
        }
        this.cbOrgType.setSelectedItem((Object)OrgTypeForF7.All);
        this.oldOrgType = (OrgTypeForF7)((Object)this.cbOrgType.getSelectedItem());
        this.cbOrgType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (OuF7UI.this.dialog != null && OuF7UI.this.dialog.isCumulate()) {
                        Set valueSet = OuF7UI.this.setCacheHelper.getSetByF7Type(OuF7UI.this.oldOrgType);
                        valueSet.clear();
                        OuF7UI.this.saveReturnValues(valueSet);
                        OuF7UI.this.oldOrgType = (OrgTypeForF7)((Object)OuF7UI.this.cbOrgType.getSelectedItem());
                        OuF7UI.this.isSearched = false;
                    }
                    OuF7UI.this.builderTree();
                }
                catch (Exception e1) {
                    OuF7UI.this.handleException(e1);
                }
            }
        });
    }

    private void doAllSelAndAllClr(boolean selected) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot();
        if (this.tOrgTree.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.tOrgTree.getSelectionPath().getLastPathComponent();
        }
        if (root == null) {
            return;
        }
        Enumeration enu = root.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        HashSet<String> allDelOrgIdSet = new HashSet<String>();
        while (enu.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enu.nextElement();
            if (!this.canTheNodeBeSelected(node)) continue;
            node.setChecked(selected);
            Object obj = node.getUserObject();
            if (!(obj instanceof FullOrgUnitInfo)) continue;
            FullOrgUnitInfo fullOrg = (FullOrgUnitInfo)obj;
            allDelOrgIdSet.add(fullOrg.getId().toString());
        }
        if (!selected) {
            this.setCacheHelper.delOrgIdInAllOrgType(allDelOrgIdSet);
        }
        this.tOrgTree.validate();
        this.tOrgTree.repaint();
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    private FullOrgUnitInfo[] getFullInfosInDifferentTrees(List idList, boolean isShowSub) throws Exception {
        if (this.allOrgInfoCache == null) {
            this.allOrgInfoCache = OrgUIDataUtil.getFullInfosInDifferentTrees(idList, this.dialog.isShowSub());
        }
        return this.allOrgInfoCache;
    }

    private void dealTreeData() throws Exception {
        if (this.dialog.isMultiCUs()) {
            List idList = this.dialog.getCuIdList();
            if (idList != null && idList.size() != 0) {
                FullOrgUnitInfo[] rootOrgAry = this.getFullInfosInDifferentTrees(idList, this.dialog.isShowSub());
                this.dialog.buildMultiCUTreeModel(this.tOrgTree, rootOrgAry, null, StepAddParamInfo.rootAllInstance);
                this.loadAllData = true;
            }
            this.tOrgTree.setRootVisible(false);
            this.tOrgTree.setShowsRootHandles(true);
        } else {
            IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
            this.curCUOrgInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.dialog.getCuID())));
            this.dialog.buildTreeModel(this.tOrgTree, this.curCUOrgInfo, StepAddParamInfo.rootAllInstance);
            this.loadAllData = true;
            TreeModel treeModel = this.tOrgTree.getModel();
            if (treeModel.getRoot() == null || ((DefaultKingdeeTreeNode)treeModel.getRoot()).getUserObject() == null) {
                this.tOrgTree.setRootVisible(false);
            } else {
                this.tOrgTree.setRootVisible(true);
            }
        }
    }

    private void innerBuildTree() throws Exception {
        boolean enmptyText = this.txtFieldValue.getText() == null || this.txtFieldValue.getText().trim().length() == 0;
        String value = enmptyText ? null : this.txtFieldValue.getText().trim();
        int field = ((ImportCompayFieldsEnum)((Object)this.comboField.getSelectedItem())).getValue();
        boolean isBlured = this.checkBlured.isSelected();
        this.dialog.setFilterValue(field, value, isBlured);
        this.dealTreeData();
        OrgTreeUtil.filterNodeByUserOrgType(this.tOrgTree, (OrgTypeForF7)((Object)this.cbOrgType.getSelectedItem()));
        this.tOrgTree.validate();
        this.tOrgTree.repaint();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    private Set getAllCheckedOrgSet(boolean isOrgIDs) {
        HashSet<String> retSet = new HashSet<String>();
        List orgType4F7List = OrgTypeForF7.getEnumList();
        for (int i = 0; i < orgType4F7List.size(); ++i) {
            OrgTypeForF7 curOrgType4F7 = (OrgTypeForF7)((Object)orgType4F7List.get(i));
            Set curSet = this.setCacheHelper.getSetByF7Type(curOrgType4F7);
            if (curSet.size() <= 0) continue;
            if (isOrgIDs) {
                Iterator it = curSet.iterator();
                while (it.hasNext()) {
                    retSet.add(((FullOrgUnitInfo)it.next()).getId().toString());
                }
                continue;
            }
            retSet.addAll(curSet);
        }
        return retSet;
    }

    void builderTree() throws Exception {
        if (this.dialog.isCumulate()) {
            Set returnAllOrgIDs = this.getAllCheckedOrgSet(true);
            if (this.isInOnload && this.dialog.checkedOrgIds != null) {
                returnAllOrgIDs.addAll(this.dialog.checkedOrgIds);
            }
            if (returnAllOrgIDs.size() > 0) {
                this.dialog.setCheckedOrgIDs(returnAllOrgIDs);
            }
        }
        if (this.dialog.isBuildAsync()) {
            Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            LongTimeDialog ltd = null;
            ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
            ltd.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    OuF7UI.this.innerBuildTree();
                    return new Boolean(true);
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            ltd.show();
        } else {
            this.innerBuildTree();
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new HashSet();
        } else {
            this.returnValue.clear();
        }
        this.saveReturnValues(this.returnValue);
        if (this.dialog != null && this.dialog.isCumulate()) {
            Set allCheckedOrgs = this.getAllCheckedOrgSet(false);
            if (!this.isSearched) {
                Set currentTypeOrgs = this.setCacheHelper.getSetByF7Type(this.oldOrgType);
                allCheckedOrgs.removeAll(currentTypeOrgs);
            }
            this.returnValue.addAll(allCheckedOrgs);
        }
        this.isSearched = false;
        try {
            if (this.returnValue.size() == 0) {
                throw OrgF7SelectException.SelectOne;
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
        catch (OrgF7SelectException f7e) {
            MsgBox.showInfo((Component)((Object)this), (String)f7e.getMsg());
        }
    }

    private void saveReturnValues(Set returnSet) throws Exception {
        try {
            if (this.dialog.isMultiSelect()) {
                DefaultKingdeeTreeNode root;
                if (this.tOrgTree.getModel() != null && (root = (DefaultKingdeeTreeNode)this.tOrgTree.getModel().getRoot()) != null) {
                    this.traceNode(root, returnSet);
                }
            } else {
                if (this.tOrgTree == null) {
                    return;
                }
                TreePath path = this.tOrgTree.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (OrgF7InnerUtils.isTreeNodeDisable(node)) {
                        throw OrgF7SelectException.SelectValidOrg;
                    }
                    returnSet.add((FullOrgUnitInfo)node.getUserObject());
                }
            }
        }
        catch (OrgF7SelectException f7e) {
            MsgBox.showInfo((Component)((Object)this), (String)f7e.getMsg());
        }
    }

    private void traceNode(DefaultKingdeeTreeNode root, Set list) throws Exception {
        Enumeration enumOrg = root.breadthFirstEnumeration();
        while (enumOrg.hasMoreElements()) {
            DefaultKingdeeTreeNode objNode = (DefaultKingdeeTreeNode)enumOrg.nextElement();
            Object obj = objNode.getUserObject();
            if (!(obj instanceof FullOrgUnitInfo) || !objNode.isChecked()) continue;
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)obj;
            list.add(orgUnit);
        }
    }

    @Override
    protected void tOrgTree_mouseClicked(MouseEvent e) throws Exception {
        super.tOrgTree_mouseClicked(e);
    }

    @Override
    protected void chkContainSealUp_itemStateChanged(ItemEvent e) throws Exception {
        super.chkContainSealUp_itemStateChanged(e);
        if (this.chkContainSealUp.isSelected()) {
            this.dialog.setContainOUSealUp(true);
        } else {
            this.dialog.setContainOUSealUp(false);
        }
        this.builderTree();
    }

    public ArrayList getReturnValue() {
        if (this.returnValue == null) {
            return null;
        }
        return new ArrayList(this.returnValue);
    }

    public void displayChkShowAssistantOrg() {
        this.chkShowAssistantOrg.setVisible(true);
        this.chkShowAssistantOrg.setSelected(false);
    }

    @Override
    protected void chkShowAssistantOrg_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkShowAssistantOrg.isVisible()) {
            this.dialog.setDisplayAssistantOrgTree(this.chkShowAssistantOrg.isSelected());
        }
        this.builderTree();
    }

    public void displayCbOrgType() {
        this.cbOrgType.setVisible(true);
    }

    protected void initKeyStroke() {
    }

    public OrgTypeForF7 getOrgTypeForF7() {
        return (OrgTypeForF7)((Object)this.cbOrgType.getSelectedItem());
    }
}

