/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.OrgF7Helper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PermItemFilterService {
    private static Logger logger = Logger.getLogger((String)PermItemFilterService.class.getName());

    public static FilterInfo getPermItemFilter(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException {
        FilterInfo filter = null;
        try {
            filter = OrgF7Helper.isAdminType(dialog.getUserPK()) ? PermItemFilterService.buildAdminFilter(dialog, viewType, treeInfo) : (StringUtils.isEmpty((String)dialog.getPermissionItem()) ? PermItemFilterService.buildOrgRangeFilter(dialog, viewType, treeInfo) : PermItemFilterService.buildPermItemFilter(dialog, viewType, treeInfo));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private static FilterInfo buildPermItemFilter(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException, EASBizException {
        FilterInfo filter = null;
        String paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByPermItem(dialog.getPermissionItem(), dialog.getUserPK(), viewType);
        try {
            filter = new FilterInfo("unit.id in (" + paramSQL + ")");
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private static FilterInfo buildOrgRangeFilter(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException {
        return OrgF7Helper.getFilterByOrgRange("unit.id", dialog.getUserPK().toString(), OrgF7Helper.getOrgRangeType(viewType));
    }

    private static FilterInfo buildAdminFilter(NewOrgViewF7PromptDialog dialog, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException {
        return OrgF7Helper.getFilterByOrgRange("unit.cu.id", dialog.getUserPK().toString(), 10);
    }
}

