/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.MultiOrgSwitchUtils;
import com.kingdee.eas.basedata.org.MultiOrgsClientCacheImplUtil;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class SwitchOrgF7PromptDialog
extends NewOrgF7PromptDialog {
    private static Logger logger = Logger.getLogger(SwitchOrgF7PromptDialog.class);
    private static final String ORG_SWITCH_PROPERTY_FILE = "OrgSwitchPropertyFile.properties";
    private File orgSwitchPropertyFile = null;
    private Properties props = null;
    private int oldOrgViewTypeIndex = 0;
    private int oldQuickQueryIndex = 0;

    public SwitchOrgF7PromptDialog() {
    }

    public SwitchOrgF7PromptDialog(IUIObject _uiObject) {
        super(_uiObject);
    }

    public SwitchOrgF7PromptDialog(Frame _owner) {
        super(_owner);
    }

    public SwitchOrgF7PromptDialog(Dialog _owner) {
        super(_owner);
    }

    @Override
    protected void init() {
        super.init();
        this.setContainSealUp(true);
        this.orgViewTypes = this.createOrgViewType();
        this.setTitle(this.getName("OrgSwitch"));
        this.setNeedAddAssistant(true);
    }

    private OrgViewType[] createOrgViewType() {
        ArrayList<OrgViewType> orgViewTypeList = new ArrayList<OrgViewType>();
        orgViewTypeList.add(OrgViewType.getInstance(this.getName("All"), -1, "", ""));
        orgViewTypeList.add(OrgTypeInfoMgr.getInstance().getOrgTypeInfo(OrgType.ControlUnit).getOrgViewType());
        Set orgTypeSet = OrgTypeInfoMgr.getInstance().getAllOrgType();
        for (OrgType orgType : orgTypeSet) {
            OrgTypeInfo orgTypeInfo;
            if (orgType.getValue() == -1) continue;
            if (orgType.getValue() == 0) continue;
            if (orgType.getValue() == 10 || !(orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgType)).isBasicOrgType() || orgTypeInfo.getOrgViewType() != null && orgTypeInfo.getOrgViewType().getValue() == 0) continue;
            orgViewTypeList.add(orgTypeInfo.getOrgViewType());
        }
        OrgViewType[] retOrgViewAry = new OrgViewType[orgViewTypeList.size()];
        for (int i = 0; i < orgViewTypeList.size(); ++i) {
            retOrgViewAry[i] = (OrgViewType)((Object)orgViewTypeList.get(i));
        }
        return retOrgViewAry;
    }

    public void setOrgViewTypes(OrgViewType[] _orgViewTypes) {
        if (_orgViewTypes == null || _orgViewTypes.length == 0) {
            throw new IllegalArgumentException("Illegal parameter!");
        }
        this.orgViewTypes = _orgViewTypes;
    }

    public void setOrgTypes(OrgType[] _orgTypes) {
        if (_orgTypes == null || _orgTypes.length == 0) {
            throw new IllegalArgumentException("Illegal parameter!");
        }
        OrgViewType[] orgViewTypes = new OrgViewType[_orgTypes.length];
        for (int i = 0; i < orgViewTypes.length; ++i) {
            orgViewTypes[i] = NewOrgViewHelper.convert(_orgTypes[i]);
        }
        this.setOrgViewTypes(orgViewTypes);
    }

    protected OrgUnitInfo[] getTypedInfos(ArrayList src) {
        return null;
    }

    public void switchOrg(KDTable tblMain) throws Exception {
        IRow selectedRow = KDTableUtil.getSelectedRow((KDTable)tblMain);
        if (selectedRow == null) {
            MsgBox.showInfo((String)this.getName("SelectTips"));
            return;
        }
        String id = selectedRow.getCell(this.isCbTypeTextEqualsALL() ? "id" : "unit.id").getValue().toString();
        MultiOrgSwitchUtils.switchOrgForClient((Component)((Object)this.getInnerF7UI()), id);
        this.getInnerF7UI().setCancel(false);
        this.getInnerF7UI().getUIWindow().close();
    }

    private String getOrgRangeOql() {
        StringBuffer result = new StringBuffer();
        StringBuffer temp = new StringBuffer();
        String userPK = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        temp.append("SELECT FOrgID").append(" FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(userPK).append("' AND FType = ").append(10);
        if (!this.isCbTypeTextEqualsALL()) {
            result.append("UNIT.id in (").append(temp.toString()).append(")");
        } else {
            result.append("id in (").append(temp.toString()).append(")");
        }
        return result.toString();
    }

    @Override
    public boolean isCbTypeTextEqualsALL() {
        return this.getComboTypeSelectedItem().getValue() == -1;
    }

    @Override
    public FilterInfo getOuterFilterInfo() {
        try {
            FilterInfo orgRangeFilter = new FilterInfo(this.getOrgRangeOql());
            return orgRangeFilter;
        }
        catch (ParserException e) {
            logger.error((Object)"getOrgRangeFilter error.", (Throwable)e);
            return null;
        }
    }

    @Override
    protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
        OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
        info.setNeedAddAssistantFilter(true);
        info.setNeedAddOrgRange(true);
        info.setNeedConsiderFaultTree(true);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
        info.setConstructParam(decorators);
        return info;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.switchOrg(this.getInnerF7UI().tblMain);
    }

    @Override
    protected int getSelectedOrgTypeOnUIShow() {
        this.loadProperties();
        return this.oldOrgViewTypeIndex;
    }

    @Override
    protected int getQueryFieldIndexOnUILoad() {
        this.loadProperties();
        return this.oldQuickQueryIndex;
    }

    private void loadProperties() {
        String key;
        this.initPropertiesHandler();
        if (this.props != null && this.props.containsKey(key = MultiOrgsClientCacheImplUtil.getPathStrFromObjID(SysContext.getSysContext().getCurrentUserInfo().getId().toString()))) {
            String[] properties = this.props.getProperty(key).split(";");
            this.oldOrgViewTypeIndex = Integer.parseInt(properties[0]);
            this.oldQuickQueryIndex = Integer.parseInt(properties[1]);
            if (properties.length >= 3) {
                this.setDefaultContainSub(Boolean.parseBoolean(properties[2]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onWindowDestroy() throws FileNotFoundException, IOException {
        if (this.props != null) {
            int newOrgViewTypeIndex = this.getInnerF7UI().cbOrgType.getSelectedIndex();
            int newQuickQueryIndex = this.getInnerF7UI().comboField.getSelectedIndex();
            boolean defaultContainSub = this.getInnerF7UI().chkContainSub.isSelected();
            String value = new StringBuffer().append(newOrgViewTypeIndex).append(";").append(newQuickQueryIndex).append(";").append(defaultContainSub).toString();
            String key = MultiOrgsClientCacheImplUtil.getPathStrFromObjID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            FileOutputStream fileOutputStream = null;
            try {
                if (!this.orgSwitchPropertyFile.exists()) {
                    this.orgSwitchPropertyFile.createNewFile();
                }
                this.props = new Properties();
                fileOutputStream = new FileOutputStream(this.orgSwitchPropertyFile);
                this.props.setProperty(key, value);
                this.props.store(fileOutputStream, "");
            }
            catch (IOException e) {
                logger.error((Object)e);
                this.props = null;
                return;
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPropertiesHandler() {
        if (this.props == null) {
            String easClientRoot = System.getProperty("easclient.root");
            FileInputStream fileInputStream = null;
            if (!StringUtils.isEmpty((String)easClientRoot)) {
                this.orgSwitchPropertyFile = new File(new StringBuffer().append(easClientRoot).append(File.separator).append(ORG_SWITCH_PROPERTY_FILE).toString());
                try {
                    if (!this.orgSwitchPropertyFile.exists()) {
                        this.orgSwitchPropertyFile.createNewFile();
                    }
                    this.props = new Properties();
                    fileInputStream = new FileInputStream(this.orgSwitchPropertyFile);
                    this.props.load(fileInputStream);
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    this.props = null;
                    return;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

