/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class UReCreateView {
    public static void main(String[] args) throws Exception {
        new UReCreateView()._rebuildAllView(null);
    }

    public Connection getConnection(Context ctx) throws SQLException {
        String driver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        String url = "jdbc:microsoft:sqlserver://tcsql:1433;DatabaseName=eas41_org_test;SelectMethod=Cursor;";
        try {
            Class.forName(driver);
            return DriverManager.getConnection(url, "sa", "sa");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
    }

    protected void _rebuildAllView(Context ctx) throws BOSException, EASBizException {
        this._innerRebuildOUView(ctx, OrgViewType.CTRLUNIT, "00000000-0000-0000-0000-0000000000014F2827FD");
        this._innerRebuildOUView(ctx, OrgViewType.ADMIN, "00000000-0000-0000-0000-0000000000034F2827FD");
        this._innerRebuildOUView(ctx, OrgViewType.COMPANY, "00000000-0000-0000-0000-0000000000024F2827FD");
        this._innerRebuildOUView(ctx, OrgViewType.SALE, "00000000-0000-0000-0000-0000000000064F2827FD");
        this._innerRebuildOUView(ctx, OrgViewType.STORAGE, "00000000-0000-0000-0000-0000000000074F2827FD");
        this._innerRebuildOUView(ctx, OrgViewType.PURCHASE, "00000000-0000-0000-0000-0000000000084F2827FD");
        this._innerRebuildOUView(ctx, OrgViewType.PROFITCENTER, "00000000-0000-0000-0000-0000000000044F2827FD");
        this._innerRebuildOUView(ctx, OrgViewType.COSTCENTER, "00000000-0000-0000-0000-0000000000054F2827FD");
        this._innerRebuildOUView(ctx, OrgViewType.RESPONSECENTER, "00000000-0000-0000-0000-0000000000094F2827FD");
    }

    private void _insertSYSCU(PreparedStatement pstmt, Statement stmt) throws BOSException, EASBizException {
        ResultSet rs = null;
        try {
            String sql = "SELECT * FROM T_ORG_BaseUnit WHERE FID='11111111-1111-1111-1111-111111111111CCE7AED4'";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                String ln = rs.getString("FLongNumber");
                int level = rs.getInt("FLevel");
                int isLeaf = rs.getInt("FIsLeaf");
                String structID = NewOrgViewHelper.getNewStructID();
                pstmt.setString(1, structID);
                pstmt.setString(2, "00000000-0000-0000-0000-0000000000014F2827FD");
                pstmt.setString(3, "11111111-1111-1111-1111-111111111111CCE7AED4");
                pstmt.setString(4, null);
                pstmt.setString(5, ln);
                pstmt.setInt(6, isLeaf);
                pstmt.setInt(7, level);
                pstmt.setInt(8, 0);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQLError:" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private boolean isValid(OrgViewType type, ResultSet rs) throws SQLException {
        switch (type.getValue()) {
            case 10: {
                return rs.getInt("FIsCU") == 1;
            }
            case 0: {
                return rs.getInt("FIsAdminOrgUnit") == 1;
            }
            case 1: {
                return rs.getInt("FIsCompanyOrgUnit") == 1;
            }
            case 2: {
                return rs.getInt("FIsSaleOrgUnit") == 1;
            }
            case 3: {
                return rs.getInt("FIsPurchaseOrgUnit") == 1;
            }
            case 4: {
                return rs.getInt("FIsStorageOrgUnit") == 1;
            }
            case 6: {
                return rs.getInt("FIsProfitOrgUnit") == 1;
            }
            case 5: {
                return rs.getInt("FIsCostOrgUnit") == 1;
            }
            case 15: {
                return rs.getInt("FIsCompanyOrgUnit") == 1 || rs.getInt("FIsProfitOrgUnit") == 1 || rs.getInt("FIsCostOrgUnit") == 1;
            }
        }
        return false;
    }

    private String viewType2ColumnName(OrgViewType type) {
        switch (type.getValue()) {
            case 10: {
                return "(FIsCU=1)";
            }
            case 0: {
                return "(FIsCU=1 OR FIsAdminOrgUnit=1)";
            }
            case 1: {
                return "(FIsCU=1 OR FIsCompanyOrgUnit=1)";
            }
            case 2: {
                return "(FIsCU=1 OR FIsSaleOrgUnit=1)";
            }
            case 3: {
                return "(FIsCU=1 OR FIsPurchaseOrgUnit=1)";
            }
            case 4: {
                return "(FIsCU=1 OR FIsStorageOrgUnit=1)";
            }
            case 6: {
                return "(FIsCU=1 OR FIsProfitOrgUnit=1)";
            }
            case 5: {
                return "(FIsCU=1 OR FIsCostOrgUnit=1)";
            }
            case 15: {
                return "(FIsCU=1 OR FIsCompanyOrgUnit=1 OR FIsProfitOrgUnit=1 OR FIsCostOrgUnit=1)";
            }
        }
        return null;
    }

    private void _innerRebuildOUView(Context ctx, OrgViewType viewType, String treeID) throws BOSException, EASBizException {
        Connection con = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashMap<String, String> ou2struct = new HashMap<String, String>();
        HashMap<String, String> ln2ID = new HashMap<String, String>();
        try {
            con = this.getConnection(ctx);
            con.setAutoCommit(false);
            stmt = con.createStatement();
            stmt.executeUpdate("DELETE FROM T_ORG_Structure WHERE FTreeID='" + treeID + "'");
            rs = stmt.executeQuery("SELECT FLongNumber FROM T_ORG_BaseUnit WHERE FID='00000000-0000-0000-0000-000000000000CCE7AED4'");
            String rootLn = null;
            if (rs.next()) {
                rootLn = rs.getString("FLongNumber");
            }
            rs.close();
            if (rootLn == null) {
                throw new RuntimeException("not specify root");
            }
            String sql = "SELECT * FROM T_ORG_BaseUnit WHERE (FLongNumber= ? OR FLongNumber Like ?) AND " + this.viewType2ColumnName(viewType) + " ORDER BY FLongNumber";
            String insertSql = "INSERT INTO T_ORG_Structure (FID,FTreeID,FUnitID,FParentID,FLongNumber,FIsLeaf,FLevel,FIsValid) VALUES(?,?,?,?,?,?,?,?)";
            rs = stmt.executeQuery(sql);
            pstmt = con.prepareStatement(insertSql);
            while (rs.next()) {
                OrgUnitInfo info = new OrgUnitInfo();
                String unitID = rs.getString("FID");
                String fn = rs.getString("FNumber");
                String ln = rs.getString("FLongNumber");
                int level = rs.getInt("FLevel");
                int isLeaf = rs.getInt("FIsLeaf");
                String parentUnitID = rs.getString("FParentID");
                String structID = NewOrgViewHelper.getNewStructID();
                ou2struct.put(unitID, structID);
                String parentStructID = (String)ou2struct.get(NewOrgViewHelper.getParentIDByLn(ln, ln2ID));
                ln2ID.put(ln, unitID);
                boolean valid = this.isValid(viewType, rs);
                pstmt.setString(1, rootLn);
                pstmt.setString(2, rootLn + "!%");
                pstmt.setString(3, structID);
                pstmt.setString(4, treeID);
                pstmt.setString(5, unitID);
                pstmt.setString(6, parentStructID);
                pstmt.setString(7, ln);
                pstmt.setInt(8, isLeaf);
                pstmt.setInt(9, level);
                pstmt.setInt(10, valid ? 1 : 0);
                pstmt.executeUpdate();
            }
            if (viewType.equals((Object)OrgViewType.CTRLUNIT)) {
                this._insertSYSCU(pstmt, stmt);
            }
            con.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    if (con != null) {
                        con.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new BOSException("SQLError:" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)con);
    }
}

