/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.di;

import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OUListUI;
import com.kingdee.eas.basedata.org.client.OrgSpecialTablesClientUtil;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class OrgDIUtil {
    private static Logger logger = Logger.getLogger((String)OUListUI.class.getName());

    public static void performImportForOrgType(OrgType orgType) {
        try {
            OrgDIUtil.checkCanDoImportOrExportTask(orgType);
            if (OrgDIUtil.doImportTask(OrgDIUtil.getSolutionName(orgType), OrgDIUtil.getTitle(orgType))) {
                OrgDIUtil.askToAuditOrgs();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void performImportForFIAccountRange(String typeName) {
        try {
            OrgDIUtil.doImportTask("FIAccountRange", typeName);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void performImportForKey(String key) {
        try {
            OrgDIUtil.checkAtRootCU(OrgDIUtil.getTitle(key));
            if (OrgDIUtil.doImportTask(OrgDIUtil.getSolutionName(key), OrgDIUtil.getTitle(key))) {
                OrgDIUtil.askToAuditOrgs();
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    public static void performExportForOrgType(Component owner, OrgType orgType, IMetaDataPK mainQueryPK, EntityViewInfo mainQuery) {
        try {
            OrgDIUtil.checkCanDoImportOrExportTask(orgType);
            OrgDIUtil.doExportTask(owner, OrgDIUtil.getSolutionName(orgType), OrgDIUtil.getTitle(orgType), mainQueryPK, mainQuery);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void performExportForKey(Component owner, String key, IMetaDataPK mainQueryPK, EntityViewInfo mainQuery) {
        try {
            OrgDIUtil.checkAtRootCU(OrgDIUtil.getTitle(key));
            OrgDIUtil.doExportTask(owner, OrgDIUtil.getSolutionName(key), OrgDIUtil.getTitle(key), mainQueryPK, mainQuery);
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    private static void askToAuditOrgs() {
        if (MsgBox.showConfirm2((String)(OrgDIUtil.getString("SYNC_TITLE") + OrgToolUtils.getResource("res_37"))) == 0) {
            OrgSpecialTablesClientUtil.rebuildAllSpecialTablesForImport();
        }
    }

    private static void checkAtRootCU(String title) throws Exception {
    }

    private static void checkCanDoImportOrExportTask(OrgType orgType) throws Exception {
        if (orgType.getValue() != -1) {
            boolean isException = false;
            FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper(unitInfo);
            boolean bl = isException = !orgTypeHelper.isOrgType(orgType);
            if (isException) {
                String title = OrgDIUtil.getTitle(orgType);
                throw new OUException(OUException.DI_ROOT_MUST_BE_BIZORG, new String[]{title, title});
            }
        }
    }

    private static boolean doImportTask(String solutionName, String dlgTitle) throws Exception {
        DatataskCaller task = new DatataskCaller();
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        KDFrame owner = null;
        owner = win instanceof KDFrame ? (KDFrame)win : new KDFrame();
        task.setParentComponent((Component)owner);
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = dlgTitle;
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        if ("eas.basedata.org.cu".equalsIgnoreCase(solutionName) || "eas.basedata.org.ou".equalsIgnoreCase(solutionName)) {
            task.invoke(paramList, 0, true);
        } else {
            task.invoke(paramList, 0, true, true);
        }
        return !task.isCanceld();
    }

    private static void doExportTask(Component owner, String sluName, String dlgTitle, IMetaDataPK mainQueryPK, EntityViewInfo mainQuery) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent(owner);
        DatataskParameter param = new DatataskParameter();
        param.solutionName = sluName;
        param.alias = dlgTitle;
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQueryPK", (Object)mainQueryPK);
        if (mainQuery == null) {
            mainQuery = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"1", CompareType.EQUALS));
            mainQuery.setFilter(filterInfo);
        }
        param.putContextParam((Object)"mainQuery", (Object)mainQuery);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.invoke(paramList, 1);
    }

    private static String getSolutionName(OrgType orgType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("10", "eas.basedata.org.cu");
        map.put("-1", "eas.basedata.org.ou");
        map.put("0", "eas.basedata.org.admin");
        map.put("1", "eas.basedata.org.company");
        map.put("3", "eas.basedata.org.purchase");
        map.put("2", "eas.basedata.org.sale");
        map.put("4", "eas.basedata.org.storage");
        map.put("5", "eas.basedata.org.costcenterorgunit");
        map.put("6", "eas.basedata.org.profitcenter");
        map.put("16", "eas.basedata.org.hro");
        map.put("24", "eas.basedata.org.transport");
        map.put("32", "eas.basedata.org.quality");
        String solutionName = (String)map.get(orgType.getValue() + "");
        if (StringUtils.isEmpty((String)solutionName)) {
            logger.error((Object)(" OrgType :" + orgType.getName() + " not set import solution,please set up solution first!!!"));
            map.put(orgType.getValue() + "", "eas.basedata.org." + orgType.getName());
        }
        return map.get(orgType.getValue() + "").toString();
    }

    private static String getSolutionName(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("UnionRange", "eas.basedata.org.UnionRange");
        map.put("UnionGroup", "eas.basedata.org.UnionGroup");
        map.put("UnionCompany", "eas.basedata.org.UnionCompany");
        return map.get(key).toString();
    }

    private static String getTitle(OrgType orgType) {
        String title = orgType.getAlias();
        if (orgType.getValue() == -1) {
            title = OrgDIUtil.getString("OU_NAME");
        }
        return title;
    }

    private static String getTitle(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("UnionRange", OrgDIUtil.getString("UNION_RANGE"));
        map.put("UnionGroup", OrgDIUtil.getString("UNION_GROUP"));
        map.put("UnionCompany", OrgDIUtil.getString("UNION_COMPANY"));
        return map.get(key).toString();
    }

    private static String getString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)key);
    }
}

