/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.basedata.org.client.NewOuF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class NewOUUnionF7
extends NewOuF7PromptDialog {
    private boolean isDisplayMaintain = true;

    public NewOUUnionF7() {
    }

    public NewOUUnionF7(IUIObject _uiObject) {
        super(_uiObject);
        this.setTitle(this.getName("CommonF7Tile"));
    }

    public NewOUUnionF7(Frame _owner) {
        super(_owner);
        this.setTitle(this.getName("CommonF7Tile"));
    }

    public NewOUUnionF7(Dialog _owner) {
        super(_owner);
        this.setTitle(this.getName("CommonF7Tile"));
    }

    @Override
    protected FilterInfo buildTreeNodeFilter(Object userObject) throws BOSException {
        FilterInfo result = new FilterInfo();
        if (this.isCbTypeTextEqualsALL() && userObject != null) {
            if (userObject instanceof OrgTreeInfo) {
                result = this.getTreeNodeFilter4OrgTreeInfo((OrgTreeInfo)userObject);
            } else if (userObject instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo tmp = (FullOrgUnitInfo)userObject;
                if (!tmp.isIsUnion()) {
                    result = super.buildTreeNodeFilter(userObject);
                    if (this.isChkSubSelected() && tmp.isIsCU()) {
                        result.mergeFilter(this.getTreeNodeFilter4FullOrgUnit(tmp), "OR");
                    }
                } else {
                    String[] treeID = new String[]{tmp.getString("treeId")};
                    String treeCUID = tmp.getString("treeCUID");
                    result.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUnitIDFromOrgStructure(treeID, treeCUID, tmp.getString("structLongNumber"), this.isChkSubSelected()), CompareType.INCLUDE));
                }
            }
        } else if (this.getComboTypeSelectedItem() == OrgViewType.UNIONDEBT) {
            result = super.buildTreeNodeFilter(userObject);
            result.mergeFilter(this.addTreeFilter(), "AND");
        } else {
            return super.buildTreeNodeFilter(userObject);
        }
        return result;
    }

    private Set getUnitIDFromOrgStructure(String[] treeID, String treeCUID, String longNumber, boolean includeSub) throws BOSException {
        HashSet<String> result = new HashSet<String>();
        if (!StringUtils.isEmpty((String)treeCUID) && treeID != null) {
            OrgStructureCollection coll = null;
            try {
                coll = this.loadDataBelowTreeInfo(treeID, treeCUID, longNumber, includeSub);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (coll != null && coll.size() > 0) {
                int j = coll.size();
                for (int i = 0; i < j; ++i) {
                    result.add(coll.get(i).getUnit().getId().toString());
                }
            } else {
                result.add("nodata");
            }
        }
        return result;
    }

    private OrgStructureCollection loadDataBelowTreeInfo(String[] treeIDs, String treeCUID, String longNumber, boolean includeSub) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        OrgStructureCollection coll = null;
        if (!StringUtils.isEmpty((String)treeCUID) && treeIDs != null) {
            String longNumberStr = "";
            String level = "";
            if (!StringUtils.isEmpty((String)longNumber)) {
                longNumberStr = " and (longnumber = '" + longNumber + "' or longnumber like '" + longNumber + "!%')";
                if (!includeSub) {
                    level = " and (level >= " + longNumber.split("!").length + " and level <= " + (longNumber.split("!").length + 1) + ")";
                }
            }
            oql.append("select unit.id ").append(" where unit.isunion = 1 and tree.id in (").append(this.transArr2String(treeIDs)).append(")").append(!StringUtils.isEmpty((String)longNumber) || includeSub ? "" : " and level = 1 ").append(longNumberStr).append(level).append(" and (tree.CU.id = '").append(treeCUID).append("'").append(this.appendMaintainCU("'" + treeCUID + "'")).append(") order by longnumber");
            IOrgStructure iStructure = OrgStructureFactory.getRemoteInstance();
            coll = iStructure.getOrgStructureCollection(oql.toString());
        }
        return coll;
    }

    private StringBuffer transArr2String(String[] treeIDs) {
        StringBuffer result = new StringBuffer();
        if (treeIDs != null) {
            int j = treeIDs.length;
            for (int i = 0; i < j; ++i) {
                result.append("'").append(treeIDs[i]).append("'");
                if (i == j - 1) continue;
                result.append(",");
            }
        }
        return result;
    }

    private StringBuffer appendMaintainCU(String cuID) {
        StringBuffer maintainOQL = new StringBuffer();
        if (this.isDisplayMaintain && !StringUtils.isEmpty((String)cuID)) {
            maintainOQL.append(" or (unit.maintainCU.id in (").append(cuID).append(")").append(" and tree.CU.id not in (").append(cuID).append(")").append(")");
        }
        return maintainOQL;
    }

    private FilterInfo addTreeFilter() {
        OrgTreeInfo treeInfo = this.getComboTreeSelectedItem();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.type", (Object)new Integer(8), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)new Integer(UnionVersionStatusEnum.START.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)new Integer(UnionVersionStatusEnum.ARCHIVE.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.CU.id", (Object)treeInfo.getCU().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3) and #4");
        if (this.isDisplayMaintain) {
            filter.getFilterItems().add(new FilterItemInfo("unit.maintainCU.id", (Object)treeInfo.getCU().getId().toString(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("tree.CU.id", (Object)treeInfo.getCU().getId().toString(), CompareType.NOTINCLUDE));
            filter.setMaskString("#0 and #1 and (#2 or #3) and (#4 or (#5 and #6))");
        }
        return filter;
    }

    private FilterInfo getTreeNodeFilter4FullOrgUnit(FullOrgUnitInfo info) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (info != null) {
            List orgTreeInfos = null;
            try {
                orgTreeInfos = NewOrgF7FacadeFactory.getRemoteInstance().getCUUnion(new String[]{info.getId().toString()}, this.buildNewOrgF7AssistInfo(null, null, null));
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            String[] ids = null;
            if (orgTreeInfos != null && orgTreeInfos.size() > 0) {
                ids = new String[orgTreeInfos.size()];
                int j = orgTreeInfos.size();
                for (int i = 0; i < j; ++i) {
                    ids[i] = ((OrgTreeInfo)orgTreeInfos.get(i)).getId().toString();
                }
            } else {
                ids = new String[]{"nodata"};
            }
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUnitIDFromOrgStructure(ids, info.getId().toString(), null, true), CompareType.INCLUDE));
        }
        return filter;
    }

    private FilterInfo getTreeNodeFilter4OrgTreeInfo(OrgTreeInfo info) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (info != null) {
            String[] treeID = new String[]{info.getId().toString()};
            String treeCUID = info.getCU().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUnitIDFromOrgStructure(treeID, treeCUID, null, this.isChkSubSelected()), CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
        OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
        info.setDisplayMaintain(this.isDisplayMaintain);
        if (this.isCbTypeTextEqualsALL()) {
            info.setAppHandleClassName("com.kingdee.eas.basedata.org.app.helper.BizOrgRangeDirectTreeNode");
            ArrayList<String> decorators = new ArrayList<String>();
            decorators.add("com.kingdee.eas.basedata.org.app.helper.UnitAssemblage");
            decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
            info.setConstructParam(decorators);
        }
        return info;
    }

    public void disableTheOUWhichIsOnlyAdmin() {
        StringBuffer sql = new StringBuffer();
        sql.append("\"BASEUNIT\"").append(".FOrgTypeStr <> ';;Admin;' and ").append("\"BASEUNIT\"").append(".FOrgTypeStr <> ';Admin;'");
        this.setExtraTreeFilters(sql.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.orgTypeStr", (Object)";;Admin;", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.orgTypeStr", (Object)";Admin;", CompareType.NOTEQUALS));
        this.setOuterFilterInfo(filter);
    }

    public boolean isDisplayMaintain() {
        return this.isDisplayMaintain;
    }

    public void setDisplayMaintain(boolean isDisplayMaintain) {
        this.isDisplayMaintain = isDisplayMaintain;
    }

    @Override
    protected OrgTreeCollection fillTreeComboOnUnion() throws EASBizException, BOSException {
        OrgTreeCollection coll = new OrgTreeCollection();
        OrgAssistInfo info = new OrgAssistInfo();
        info.setDisplayMaintain(true);
        List orgTreeInfos = NewOrgF7FacadeFactory.getRemoteInstance().getCUUnion(new String[]{this.getRootUnitID()}, info);
        if (orgTreeInfos != null) {
            int j = orgTreeInfos.size();
            for (int i = 0; i < j; ++i) {
                coll.add((OrgTreeInfo)orgTreeInfos.get(i));
            }
        }
        return coll;
    }

    @Override
    public TreeModel buildTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, DefaultKingdeeTreeNode selectedNode) throws Exception {
        if (selectedNode == null) {
            if (orgViewType == OrgViewType.UNIONDEBT) {
                if (orgTreeInfo == null) {
                    return new DefaultTreeModel((TreeNode)new DefaultKingdeeTreeNode());
                }
                String oql = "select id, unit.name, longNumber where tree.id = '" + orgTreeInfo.getId().toString() + "' and level = 1";
                OrgStructureInfo unionRoot = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo(oql);
                selectedNode = new DefaultKingdeeTreeNode();
                selectedNode.setUserObject((Object)unionRoot);
            } else if (this.isCbTypeTextEqualsALL() && this.getRootUnits() == null) {
                selectedNode = new DefaultKingdeeTreeNode();
                selectedNode.setUserObject(NewOrgF7FacadeFactory.getRemoteInstance().getMutiRootNodes(null).get(0));
            }
        }
        return super.buildTreeModel(orgViewType, orgTreeInfo, selectedNode);
    }
}

