/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class NewOrgF7
extends NewOrgViewF7PromptDialog {
    private static Logger logger = Logger.getLogger(NewOrgF7.class);

    public NewOrgF7() {
    }

    public NewOrgF7(IUIObject _uiObject) {
        super(_uiObject);
    }

    public NewOrgF7(Frame _owner) {
        super(_owner);
    }

    public NewOrgF7(Dialog _owner) {
        super(_owner);
    }

    @Override
    protected void init() {
        super.init();
        this.orgViewTypes = this.createOrgViewType();
        this.setNeedAddOrgRange(true);
        this.setNeedAddSealUp(true);
    }

    private OrgViewType[] createOrgViewType() {
        ArrayList<OrgViewType> orgViewTypeList = new ArrayList<OrgViewType>();
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
            if (orgTypeInfo.getOrgViewType() == null || OrgViewType.UNIONDEBT == orgTypeInfo.getOrgViewType()) continue;
            orgViewTypeList.add(orgTypeInfo.getOrgViewType());
        }
        OrgViewType[] retOrgViewAry = new OrgViewType[orgViewTypeList.size()];
        for (int i = 0; i < orgViewTypeList.size(); ++i) {
            retOrgViewAry[i] = (OrgViewType)((Object)orgViewTypeList.get(i));
        }
        return retOrgViewAry;
    }

    public void setOrgViewTypes(OrgViewType[] _orgViewTypes) {
        if (_orgViewTypes == null || _orgViewTypes.length == 0) {
            throw new IllegalArgumentException("Illegal parameter!");
        }
        this.orgViewTypes = _orgViewTypes;
    }

    public void setOrgTypes(OrgType[] _orgTypes) {
        if (_orgTypes == null || _orgTypes.length == 0) {
            throw new IllegalArgumentException("Illegal parameter!");
        }
        OrgViewType[] orgViewTypes = new OrgViewType[_orgTypes.length];
        for (int i = 0; i < orgViewTypes.length; ++i) {
            orgViewTypes[i] = NewOrgViewHelper.convert(_orgTypes[i]);
        }
        this.setOrgViewTypes(orgViewTypes);
    }

    @Override
    protected OrgUnitInfo[] getTypedInfos(Collection selectedOrgs) {
        if (selectedOrgs == null || selectedOrgs.size() == 0) {
            return null;
        }
        OrgUnitInfo[] values = new OrgUnitInfo[selectedOrgs.size()];
        OrgViewType viewType = this.getComboTypeSelectedItem();
        OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(viewType).getOrgType();
        if (curOrgType == OrgType.UnionDebt) {
            return super.getTypedInfos(selectedOrgs);
        }
        HashSet<String> idSet = new HashSet<String>();
        for (FullOrgUnitInfo unitInfo : selectedOrgs) {
            idSet.add(unitInfo.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        OrgUnitCollection col = null;
        try {
            col = NewOrgViewHelper.getOrgUnitCollection(null, curOrgType, viewInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        for (int i = 0; i < col.size(); ++i) {
            values[i] = (OrgUnitInfo)col.getObject(i);
        }
        return values;
    }
}

