/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.basedata.org.client.uihelper.IOrgTypeClientHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientDefaultImpl;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class NewOrgUnitFilterInfoProducer
implements IFilterInfoProducer {
    private NewOrgViewF7PromptDialog model;
    private FilterInfo fiToReturn;
    private String treeID;
    private OrgViewType orgViewType;

    public NewOrgViewF7PromptDialog getModel() {
        this.fiToReturn = null;
        return this.model;
    }

    public NewOrgUnitFilterInfoProducer(OrgType orgType) {
        if (OrgType.ControlUnit == orgType) {
            this.model = new NewCtrlF7();
            this.treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
            this.orgViewType = OrgViewType.CTRLUNIT;
        } else {
            OrgTypeClientDefaultImpl clientHelper = (OrgTypeClientDefaultImpl)OrgTypeClientCenter.getInstance().getClientImp(orgType);
            this.model = clientHelper.createNewF7ByCondition("TREETYPE_BIZUNIT");
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
            this.treeID = orgTypeInfo.getOrgTreeID();
            this.orgViewType = orgTypeInfo.getOrgViewType();
        }
    }

    public NewOrgUnitFilterInfoProducer(OrgType orgType, String permissionItem) {
        this(orgType);
        this.model.setPermissionItem(permissionItem);
    }

    public NewOrgUnitFilterInfoProducer(NewOrgViewF7PromptDialog model, boolean needAddOrgRange) {
        this(model);
        if (model != null && !needAddOrgRange) {
            model.setNeedAddOrgRange(false);
        }
    }

    public NewOrgUnitFilterInfoProducer(NewOrgViewF7PromptDialog model, String permissionItem) {
        this(model);
        this.model.setPermissionItem(permissionItem);
    }

    public NewOrgUnitFilterInfoProducer(NewOrgViewF7PromptDialog model) {
        this.model = model;
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo curOrgTypeInfo : orgTypeCol) {
            IOrgTypeClientHelper iOrgClient = OrgTypeClientCenter.getInstance().getClientImp(curOrgTypeInfo.getOrgType());
            NewOrgViewF7PromptDialog curF7 = ((OrgTypeClientDefaultImpl)iOrgClient).createNewF7ByCondition("TREETYPE_ORDINARY");
            if (curF7 == null || !((Object)((Object)curF7)).getClass().getName().equals(((Object)((Object)model)).getClass().getName())) continue;
            this.treeID = curOrgTypeInfo.getOrgTreeID();
            this.orgViewType = curOrgTypeInfo.getOrgViewType();
        }
        if (model instanceof NewCtrlF7) {
            this.treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
            this.orgViewType = OrgViewType.CTRLUNIT;
        }
    }

    public FilterInfo getFilterInfo() {
        if (this.fiToReturn != null) {
            return this.fiToReturn;
        }
        this.fiToReturn = new FilterInfo();
        try {
            this.model.createF7UI();
            StringBuffer longNumberQuery = null;
            if (this.orgViewType == OrgViewType.UNIONDEBT) {
                String treeID = this.model.getTreeID();
                if (StringUtils.isEmpty((String)treeID)) {
                    return this.getFilterInfoForAllUnion();
                }
                this.treeID = treeID;
            } else {
                String[] rootLongNumbers = this.getRootLongNumbers();
                longNumberQuery = new StringBuffer();
                if (rootLongNumbers != null && rootLongNumbers.length > 0) {
                    for (int i = 0; i < rootLongNumbers.length; ++i) {
                        longNumberQuery.append("(\"UNIT\".FLongNumber = '").append(rootLongNumbers[i]).append("' OR \"UNIT\".FLongNumber Like '").append(rootLongNumbers[i]).append("!%')");
                        if (i == rootLongNumbers.length - 1) continue;
                        longNumberQuery.append(" OR ");
                    }
                }
            }
            String sql = this.model.getEntityViewInSQL();
            if (null == longNumberQuery || 0 == longNumberQuery.length()) {
                this.fiToReturn.mergeFilter(new FilterInfo("id in (" + sql + ")"), "AND");
                return this.fiToReturn;
            }
            StringBuffer result = new StringBuffer();
            result.append("id in (").append(sql.substring(0, sql.indexOf("WHERE"))).append(" WHERE (").append(longNumberQuery).append(") AND ").append(sql.substring(sql.indexOf("WHERE") + "WHERE".length())).append(")");
            this.fiToReturn.mergeFilter(new FilterInfo(result.toString()), "AND");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return this.fiToReturn;
    }

    private String[] getRootLongNumbers() throws BOSException, EASBizException {
        IOrgStructure istruct = OrgStructureFactory.getRemoteInstance();
        if (this.model.getRootUnits() == null || this.model.getRootUnits().size() == 0) {
            String rootUnitID = this.model.getRootUnitID();
            StringBuffer oql = new StringBuffer();
            oql.append("select unit.longnumber where unit.id = '").append(rootUnitID).append("' and tree.id = '").append(this.treeID).append("'");
            OrgStructureInfo structInfo = istruct.getOrgStructureInfo(oql.toString());
            return new String[]{structInfo.getUnit().getLongNumber()};
        }
        List rootUnitIDs = this.model.getRootUnits();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < rootUnitIDs.size(); ++i) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)rootUnitIDs.get(i);
            ids.add(info.getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("unit.id", ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.treeID, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("unit.longnumber"));
        viewInfo.setSelector(selector);
        OrgStructureCollection coll = istruct.getOrgStructureCollection(viewInfo);
        if (coll == null || coll.size() == 0) {
            return new String[0];
        }
        String[] result = new String[coll.size()];
        for (int i = 0; i < coll.size(); ++i) {
            result[i] = coll.get(i).getUnit().getLongNumber();
        }
        return result;
    }

    private FilterInfo getFilterInfoForAllUnion() throws Exception {
        String oql = "select unit.id where tree.type = 8";
        IOrgStructure istruct = OrgStructureFactory.getRemoteInstance();
        OrgStructureCollection coll = istruct.getOrgStructureCollection("select unit.id where tree.type = 8");
        if (coll == null || coll.size() == 0) {
            this.fiToReturn = new FilterInfo();
            this.fiToReturn.getFilterItems().add(new FilterItemInfo("id", (Object)"*"));
        } else {
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                ids.add(coll.get(i).getUnit().getId().toString());
            }
            this.fiToReturn = new FilterInfo();
            this.fiToReturn.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        }
        return this.fiToReturn;
    }

    public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
        this.model.setCurrentCUID(cui.getId().toString());
    }

    public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
    }
}

