/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.OrgF7Helper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.tree.TreeModel;

public class OrgF7
extends OrgF7PromptDialog {
    private boolean isShowNameandNumber = false;

    public OrgF7() {
    }

    public OrgF7(IUIObject _uiObject) {
        super(_uiObject);
    }

    public OrgF7(Frame _owner) {
        super(_owner);
    }

    public OrgF7(Dialog _owner) {
        super(_owner);
    }

    @Override
    protected void init() {
        super.init();
        this.orgViewTypes = this.createOrgViewType();
    }

    private OrgViewType[] createOrgViewType() {
        ArrayList<OrgViewType> orgViewTypeList = new ArrayList<OrgViewType>();
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
            if (orgTypeInfo.getOrgViewType() == null || OrgViewType.UNIONDEBT == orgTypeInfo.getOrgViewType()) continue;
            orgViewTypeList.add(orgTypeInfo.getOrgViewType());
        }
        OrgViewType[] retOrgViewAry = new OrgViewType[orgViewTypeList.size()];
        for (int i = 0; i < orgViewTypeList.size(); ++i) {
            retOrgViewAry[i] = (OrgViewType)((Object)orgViewTypeList.get(i));
        }
        return retOrgViewAry;
    }

    public void setOrgViewTypes(OrgViewType[] _orgViewTypes) {
        if (_orgViewTypes == null || _orgViewTypes.length == 0) {
            throw new IllegalArgumentException("Illegal parameter!");
        }
        this.orgViewTypes = _orgViewTypes;
    }

    public void setOrgTypes(OrgType[] _orgTypes) {
        if (_orgTypes == null || _orgTypes.length == 0) {
            throw new IllegalArgumentException("Illegal parameter!");
        }
        OrgViewType[] orgViewTypes = new OrgViewType[_orgTypes.length];
        for (int i = 0; i < orgViewTypes.length; ++i) {
            orgViewTypes[i] = NewOrgViewHelper.convert(_orgTypes[i]);
        }
        this.setOrgViewTypes(orgViewTypes);
    }

    @Override
    protected OrgUnitInfo[] getTypedInfos(ArrayList src) {
        if (src.size() == 0) {
            return null;
        }
        OrgUnitInfo[] values = new OrgUnitInfo[src.size()];
        int treeType = (Integer)((FullOrgUnitInfo)src.get(0)).get("treeType");
        OrgViewType orgViewType = OrgViewType.getEnum(treeType);
        OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType).getOrgType();
        try {
            if (treeType == 8) {
                for (int i = 0; i < src.size(); ++i) {
                    FullOrgUnitInfo fullInfo = (FullOrgUnitInfo)src.get(i);
                    BOSUuid id = fullInfo.getId();
                    if (fullInfo.isIsCompanyOrgUnit()) {
                        values[i] = NewOrgViewHelper.getOrgUnitInfo(null, id.toString(), OrgType.Company);
                        continue;
                    }
                    if (!fullInfo.isIsUnion()) continue;
                    values[i] = fullInfo;
                }
            }
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < src.size(); ++i) {
                idSet.add(((FullOrgUnitInfo)src.get(i)).getId().toString());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
            OrgUnitCollection col = NewOrgViewHelper.getOrgUnitCollection(null, curOrgType, viewInfo);
            for (int i = 0; i < col.size(); ++i) {
                values[i] = (OrgUnitInfo)col.getObject(i);
            }
        }
        catch (Exception e) {
            return null;
        }
        return values;
    }

    public boolean isShowNameandNumber() {
        return this.isShowNameandNumber;
    }

    public void setShowNameandNumber(boolean isShowNameandNumber) {
        this.isShowNameandNumber = isShowNameandNumber;
    }

    @Override
    protected void clipTreeModel(TreeModel model) {
        if (this.isShowNameandNumber) {
            OrgF7Helper.displayNumberinTreeNode((DefaultKingdeeTreeNode)model.getRoot());
        }
    }
}

