/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.DataPermParam;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;

public class OrgUnitDelegationF7 {
    private static final String fullOrgUnitQuery = "com.kingdee.eas.basedata.org.app.FullOrgUnitQuery";
    private KDBizPromptBox promptBox;
    private DelegationPartsEnum thePartOfTheNeededUnit;
    private OrgType theTypeOfTheNeededUnit;
    private String theGivenUnitID;
    private OrgType theGivenUnitType;
    private boolean useOrgRangeAsFilter = true;
    private boolean includeSelf = false;
    private FilterInfo fiToReturn;
    private boolean isUseDefaultBoxConfig = false;
    private static final String sqlToGetTheToUnitID = "select a.FToUnitID from T_ORG_UnitRelation as a inner join T_ORG_TypeRelation as b on a.FTypeRelationID = b.FID where a.FFromUnitID = {0} and b.FFromType = {1} {2}";
    private static final String sqlTheToUnitType = "and b.FToType = {0}";
    private static final String sqlToGetTheFromUnitID = "select a.FFromUnitID from T_ORG_UnitRelation as a inner join T_ORG_TypeRelation as b on a.FTypeRelationID = b.FID where a.FToUnitID = {0} and b.FToType = {1} {2}";
    private static final String sqlTheFromUnitType = "and b.FFromType = {0}";
    private List theGivenUnitIDList = null;
    private boolean isMultiGivenOrgUnits = false;
    private DataPermParam dataPermParam = null;

    public OrgUnitDelegationF7(KDBizPromptBox promptBox, DelegationPartsEnum theNeededUnitPart, OrgType theTypeOfTheNeededUnit) {
        assert (promptBox != null && theNeededUnitPart != null && theTypeOfTheNeededUnit != null);
        this.promptBox = promptBox;
        this.thePartOfTheNeededUnit = theNeededUnitPart;
        this.theTypeOfTheNeededUnit = theTypeOfTheNeededUnit;
    }

    public OrgUnitDelegationF7(KDBizPromptBox promptBox, DelegationPartsEnum theNeededUnitPart, OrgType theTypeOfTheNeededUnit, boolean isUseDefaultBoxConfig) {
        assert (promptBox != null && theNeededUnitPart != null && theTypeOfTheNeededUnit != null);
        this.isUseDefaultBoxConfig = isUseDefaultBoxConfig;
        this.promptBox = promptBox;
        this.thePartOfTheNeededUnit = theNeededUnitPart;
        this.theTypeOfTheNeededUnit = theTypeOfTheNeededUnit;
    }

    public OrgUnitDelegationF7(KDBizPromptBox promptBox, DelegationPartsEnum theNeededUnit) {
        assert (promptBox != null && theNeededUnit != null);
        this.promptBox = promptBox;
        this.thePartOfTheNeededUnit = theNeededUnit;
        this.theTypeOfTheNeededUnit = null;
    }

    public OrgUnitDelegationF7(DelegationPartsEnum theNeededUnitPart, OrgType theTypeOfTheNeededUnit) {
        this(new KDBizPromptBox(), theNeededUnitPart, theTypeOfTheNeededUnit);
    }

    public void setTheGivenOrgUnit(String theGivenUnitID, OrgType theGivenUnitType) {
        assert (theGivenUnitID != null && !theGivenUnitID.equals("") && theGivenUnitType != null);
        this.theGivenUnitID = theGivenUnitID;
        this.theGivenUnitType = theGivenUnitType;
        this.isMultiGivenOrgUnits = false;
        this.doSomeSetting();
    }

    private void doSomeSetting() {
        if (this.promptBox.getQueryInfo() == null) {
            this.setQueryInfoForQuery();
        }
        if (!this.isMultiGivenOrgUnits) {
            this.setEntityViewInfoForQuery();
        } else {
            this.setEntityViewInfoForQuery2();
        }
        if (!this.isUseDefaultBoxConfig) {
            this.setTheOtherThings();
        }
    }

    public void setTheGivenOrgUnits(List theGivenUnitIDList, OrgType theGivenUnitType) {
        assert (theGivenUnitIDList != null && theGivenUnitIDList.size() != 0 && theGivenUnitType != null);
        this.theGivenUnitIDList = theGivenUnitIDList;
        this.theGivenUnitType = theGivenUnitType;
        this.isMultiGivenOrgUnits = true;
        this.doSomeSetting();
    }

    public void setIsMultiGivenOrgUnits(boolean isMultiGivenOrgUnits) {
        this.isMultiGivenOrgUnits = isMultiGivenOrgUnits;
    }

    public void setNeedUserOrgRangeAsFilter(boolean useOrgRangeAsFiler) {
        this.useOrgRangeAsFilter = useOrgRangeAsFiler;
        if (!this.isMultiGivenOrgUnits) {
            this.setEntityViewInfoForQuery();
        } else {
            this.setEntityViewInfoForQuery2();
        }
    }

    public void setDoNotUseUserOrgRangeAsFilter() {
        this.useOrgRangeAsFilter = false;
        if (!this.isMultiGivenOrgUnits) {
            this.setEntityViewInfoForQuery();
        } else {
            this.setEntityViewInfoForQuery2();
        }
    }

    public void setIncludeSelfWhenSelfIsAlsoOfTheWantedType() {
        this.includeSelf = true;
        if (!this.isMultiGivenOrgUnits) {
            this.setEntityViewInfoForQuery();
        } else {
            this.setEntityViewInfoForQuery2();
        }
    }

    private void setTheOtherThings() {
        this.promptBox.setDisplayFormat("$name$");
        this.promptBox.setEditFormat("$number$");
        this.promptBox.setCommitFormat("$number$");
        this.promptBox.setHasCUDefaultFilter(false);
        this.promptBox.setEditable(true);
    }

    private void setQueryInfoForQuery() {
        String theQueryInfoToSet = "";
        theQueryInfoToSet = this.theTypeOfTheNeededUnit == null ? fullOrgUnitQuery : OrgTypeClientCenter.getInstance().getClientImp(this.theTypeOfTheNeededUnit).findQueryStr("QUERY_TYPE_ORG_DEFAULT");
        this.promptBox.setQueryInfo(theQueryInfoToSet);
    }

    private void setEntityViewInfoForQuery() {
        if (this.theGivenUnitID == null || this.theGivenUnitID.trim().length() == 0) {
            return;
        }
        String sqlTemplate = "";
        String sqlTemplateElement0 = "'" + this.theGivenUnitID + "'";
        String sqlTemplateElement1 = this.theGivenUnitType.getValue() + "";
        String sqlTemplateElement2 = "";
        if (this.thePartOfTheNeededUnit.getValue() == 0) {
            sqlTemplate = sqlToGetTheFromUnitID;
            if (this.theTypeOfTheNeededUnit != null) {
                sqlTemplateElement2 = MessageFormat.format(sqlTheFromUnitType, this.theTypeOfTheNeededUnit.getValue() + "");
            }
        } else {
            assert (this.thePartOfTheNeededUnit.getValue() == 1);
            sqlTemplate = sqlToGetTheToUnitID;
            if (this.theTypeOfTheNeededUnit != null) {
                sqlTemplateElement2 = MessageFormat.format(sqlTheToUnitType, this.theTypeOfTheNeededUnit.getValue() + "");
            }
        }
        String sql = MessageFormat.format(sqlTemplate, sqlTemplateElement0, sqlTemplateElement1, sqlTemplateElement2);
        EntityViewInfo eviToSet = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        eviToSet.setFilter(fi);
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        this.addSelfWhenNeeded(fi, fic);
        this.addUserOrgRangeFilterWhenNeeded(eviToSet);
        this.addDataPerm(eviToSet);
        this.fiToReturn = eviToSet.getFilter();
        this.promptBox.setEntityViewInfo(eviToSet);
    }

    private void setEntityViewInfoForQuery2() {
        if (this.theGivenUnitIDList == null || this.theGivenUnitIDList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        if (this.thePartOfTheNeededUnit.getValue() == 0) {
            sql.append("select a.FFromUnitID from T_ORG_UnitRelation as a ").append("inner join T_ORG_TypeRelation as b ").append("on a.FTypeRelationID = b.FID ").append("where a.FToUnitID in ").append(this.getIDListAsString(this.theGivenUnitIDList)).append(" and b.FToType = ").append(this.theGivenUnitType.getValue());
            if (this.theTypeOfTheNeededUnit != null) {
                sql.append(" and b.FFromType = ").append(this.theTypeOfTheNeededUnit.getValue());
            }
        } else {
            assert (this.thePartOfTheNeededUnit.getValue() == 1);
            sql.append("select a.FToUnitID from T_ORG_UnitRelation as a ").append("inner join T_ORG_TypeRelation as b ").append("on a.FTypeRelationID = b.FID ").append("where a.FFromUnitID in ").append(this.getIDListAsString(this.theGivenUnitIDList)).append(" and b.FFromType = ").append(this.theGivenUnitType.getValue());
            if (this.theTypeOfTheNeededUnit != null) {
                sql.append(" and b.FToType = ").append(this.theTypeOfTheNeededUnit.getValue());
            }
        }
        EntityViewInfo eviToSet = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        eviToSet.setFilter(fi);
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        this.addSelfWhenNeeded(fi, fic);
        this.addUserOrgRangeFilterWhenNeeded(eviToSet);
        this.addDataPerm(eviToSet);
        this.fiToReturn = eviToSet.getFilter();
        this.promptBox.setEntityViewInfo(eviToSet);
    }

    private String getIDListAsString(List idList) {
        StringBuffer idListStr = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            if (i == 0) {
                idListStr.append("(");
            }
            idListStr.append("'").append(idList.get(i)).append("'");
            if (i < idList.size() - 1) {
                idListStr.append(", ");
            }
            if (i != idList.size() - 1) continue;
            idListStr.append(")");
        }
        return idListStr.toString();
    }

    public FilterInfo getFilterInfoForQuery() {
        return this.fiToReturn;
    }

    private void addSelfWhenNeeded(FilterInfo fi, FilterItemCollection fic) {
        if (this.includeSelf) {
            fic.add(new FilterItemInfo("id", (Object)this.theGivenUnitID));
            fi.setMaskString("#0 or #1");
        }
    }

    private void addUserOrgRangeFilterWhenNeeded(EntityViewInfo evi) {
        if (this.useOrgRangeAsFilter && this.theTypeOfTheNeededUnit != null) {
            OrgViewType ovt = NewOrgViewHelper.convert(this.theTypeOfTheNeededUnit);
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId(ovt));
            try {
                HashMap hm = OrgF7InnerUtils.getAuthorizedOrgViewIDs((IObjectPK)userPK, ovt, (IObjectPK)treePK, null, null);
                FilterInfo fi = new FilterInfo();
                if (hm.size() != 0) {
                    fi.getFilterItems().add(new FilterItemInfo("id", hm.keySet(), CompareType.INCLUDE));
                } else {
                    fi.getFilterItems().add(new FilterItemInfo("id", (Object)"*"));
                }
                evi.getFilter().mergeFilter(fi, "and");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void addDataPerm(EntityViewInfo eviToSet) {
        if (this.dataPermParam == null) {
            return;
        }
        try {
            String rule = PermissionFactory.getRemoteInstance().getQueryPermissionSQL(this.dataPermParam.userId, this.dataPermParam.orgId, this.dataPermParam.permItem);
            eviToSet.getFilter().mergeFilter(new FilterInfo("id in (" + rule + ")"), "and");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void setDataPermission(IObjectPK orgId, IObjectPK userId, String permItemName) throws BOSException, EASBizException {
        this.dataPermParam = new DataPermParam(orgId, userId, permItemName);
    }

    public void setDataPermission(String permItemName) throws EASBizException, BOSException {
        BOSUuid orgId = SysContext.getSysContext().getCurrentOrgUnit().getId();
        BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
        this.setDataPermission((IObjectPK)new ObjectUuidPK(orgId), (IObjectPK)new ObjectUuidPK(userId), permItemName);
    }
}

