/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.basedata.org.client.uihelper.IOrgTypeClientHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Collection;

public class OrgUnitFilterInfoProducer
implements IFilterInfoProducer {
    protected OrgF7PromptDialog model;
    protected OrgTreeInfo oti;
    protected OrgViewType ovt;
    private FilterInfo fiToReturn;
    private boolean multiSelect = false;

    public OrgF7PromptDialog getModel() {
        this.fiToReturn = null;
        return this.model;
    }

    public OrgUnitFilterInfoProducer(OrgType orgType) {
        this.oti = new OrgTreeInfo();
        if (10 == orgType.getValue()) {
            this.model = new CtrlF7();
            this.oti.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000014F2827FD"));
            this.ovt = OrgViewType.CTRLUNIT;
        } else {
            this.model = OrgTypeClientCenter.getInstance().getClientImp(orgType).createF7ByCondition("TREETYPE_BIZUNIT");
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
            this.oti.setId(BOSUuid.read((String)orgTypeInfo.getOrgTreeID()));
            this.ovt = orgTypeInfo.getOrgViewType();
        }
    }

    public OrgUnitFilterInfoProducer(OrgType orgType, String permissionItem) {
        this(orgType);
        if (this.model != null) {
            this.model.setPermissionItem(permissionItem);
        }
    }

    public OrgUnitFilterInfoProducer(OrgF7PromptDialog model, boolean usePermission) {
        this(model);
        if (model != null && !usePermission) {
            model.disablePerm();
        }
    }

    public OrgUnitFilterInfoProducer(OrgF7PromptDialog model) {
        this.model = model;
        this.oti = new OrgTreeInfo();
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo curOrgTypeInfo : orgTypeCol) {
            IOrgTypeClientHelper iOrgClient = OrgTypeClientCenter.getInstance().getClientImp(curOrgTypeInfo.getOrgType());
            OrgF7PromptDialog curF7 = iOrgClient.createF7ByCondition("TREETYPE_ORDINARY");
            if (curF7 == null || !curF7.getClass().getName().equals(model.getClass().getName())) continue;
            this.oti.setId(BOSUuid.read((String)curOrgTypeInfo.getOrgTreeID()));
            this.ovt = curOrgTypeInfo.getOrgViewType();
        }
        if (model instanceof CtrlF7) {
            this.oti.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000014F2827FD"));
            this.ovt = OrgViewType.CTRLUNIT;
        }
    }

    public FilterInfo getFilterInfo() {
        if (this.ovt == null) {
            return null;
        }
        if (this.fiToReturn != null) {
            return this.fiToReturn;
        }
        try {
            if (this.ovt.getValue() == 8) {
                String treeID = this.model.getTreeID();
                if (treeID == null || treeID.length() == 0) {
                    return this.getFilterInfoForAllUnion();
                }
                this.oti.setId(BOSUuid.read((String)treeID));
            }
            this.model.getTreeModel(this.ovt, this.oti);
            this.fiToReturn = this.model.getEntityViewInfoForCommitingInF7().getFilter();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return this.fiToReturn;
    }

    private String getNotUnionSql() {
        StringBuffer sb = new StringBuffer("");
        Collection orgTypeInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (orgTypeInfo == null || StringUtils.isEmpty((String)orgTypeInfo.getOrgTreeID())) continue;
            sb.append("'").append(orgTypeInfo.getOrgTreeID()).append("',");
        }
        if (sb.toString().endsWith(",")) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    private FilterInfo getFilterInfoForAllUnion() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("where id not in (").append(this.getNotUnionSql()).append(")");
        IOrgTree iot = OrgTreeFactory.getRemoteInstance();
        OrgTreeCollection otc = iot.getOrgTreeCollection(sb.toString());
        if (otc.size() == 0) {
            this.fiToReturn = new FilterInfo();
            this.fiToReturn.getFilterItems().add(new FilterItemInfo("id", (Object)"*"));
        } else {
            this.model.getTreeModel(this.ovt, otc.get(0));
            FilterInfo fi = this.model.getEntityViewInfoForCommitingInF7().getFilter();
            FilterInfo fi2 = null;
            int n = otc.size();
            for (int i = 1; i < n; ++i) {
                this.model.getTreeModel(this.ovt, otc.get(i));
                fi2 = this.model.getEntityViewInfoForCommitingInF7().getFilter();
                fi.mergeFilter(fi2, "or");
            }
            this.fiToReturn = fi;
        }
        return this.fiToReturn;
    }

    public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
        this.model.setCurrentCUID(cui.getId().toString());
    }

    public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
    }

    public OrgUnitFilterInfoProducer() {
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
        if (this.model != null) {
            this.model.setMultiSelect(multiSelect);
        }
    }
}

