/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.helper;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AfterOrgMoveHandlerInfo;
import com.kingdee.eas.basedata.org.AfterOrgMoveTaskCollection;
import com.kingdee.eas.basedata.org.AfterOrgMoveTaskFactory;
import com.kingdee.eas.basedata.org.AfterOrgMoveTaskInfo;
import com.kingdee.eas.basedata.org.CheckResult;
import com.kingdee.eas.basedata.org.ExecuteStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAfterOrgMoveTask;
import com.kingdee.eas.basedata.org.IBeforeOrgMoveChecker;
import com.kingdee.eas.basedata.org.OrgMoveParam;
import com.kingdee.eas.basedata.org.OrgMoveParamPropertyFilter;
import com.kingdee.eas.basedata.org.OrgXMLElement;
import com.kingdee.eas.basedata.org.helper.OrgConfigHelper;
import com.kingdee.eas.basedata.org.helper.StringRandomUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgMoveClientHelper {
    private static final Logger logger = Logger.getLogger(OrgMoveClientHelper.class);
    public static final String BEFORE_ORG_MOVE_CHECKERS = "beforeorgmovecheckers";
    public static final String AFTER_ORG_MOVE_HANDLER = "AfterOrgMoveHandler";
    public static final String SELECTED_ORG_ID = "selectedOrgId";

    public static void checkBeforeOrgMove(FullOrgUnitInfo orgInfo) {
        List<String> beforeCheckerClasses = OrgConfigHelper.getItemValues(BEFORE_ORG_MOVE_CHECKERS);
        for (String className : beforeCheckerClasses) {
            IBeforeOrgMoveChecker checker = OrgMoveClientHelper.getBeforeOrgMoveChecker(className);
            CheckResult result = checker.checkBeforMove(orgInfo);
            if (result.isCheckPass()) continue;
            MsgBox.showInfo((String)result.getMessage());
            SysUtil.abort();
        }
    }

    private static IBeforeOrgMoveChecker getBeforeOrgMoveChecker(String className) {
        Class<?> clz = null;
        IBeforeOrgMoveChecker ret = null;
        try {
            clz = Class.forName(className);
            ret = (IBeforeOrgMoveChecker)clz.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    public static List<AfterOrgMoveHandlerInfo> getAfterOrgMoveHandlerInfoList() {
        List orgElements;
        try {
            orgElements = OrgConfigHelper.getXMLBizClasses(AFTER_ORG_MOVE_HANDLER, null);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new RuntimeException(e);
        }
        ArrayList<AfterOrgMoveHandlerInfo> ret = new ArrayList<AfterOrgMoveHandlerInfo>();
        for (OrgXMLElement ele : orgElements) {
            AfterOrgMoveHandlerInfo info = new AfterOrgMoveHandlerInfo();
            info.setKey(ele.getKey());
            info.setClassName(ele.getValue());
            info.setDescription(ele.getDescription());
            info.setDependence(ele.getDependence());
            ret.add(info);
        }
        return ret;
    }

    public static String saveAfterOrgMoveTask(OrgMoveParam orgMoveParam) throws Exception {
        List<AfterOrgMoveHandlerInfo> afterOrgMoveHandlerList = OrgMoveClientHelper.getAfterOrgMoveHandlerInfoList();
        IAfterOrgMoveTask iAfterOrgMoveTask = AfterOrgMoveTaskFactory.getRemoteInstance();
        CoreBaseCollection taskCol = new CoreBaseCollection();
        String identityStr = StringRandomUtil.getRandomString();
        String paramObjJsonStr = JSONObject.toJSONString((Object)orgMoveParam, (SerializeFilter)new OrgMoveParamPropertyFilter(), (SerializerFeature[])new SerializerFeature[0]);
        Timestamp createTime = new Timestamp(new Date().getTime());
        for (AfterOrgMoveHandlerInfo handler : afterOrgMoveHandlerList) {
            AfterOrgMoveTaskInfo task = new AfterOrgMoveTaskInfo();
            task.setHandler(handler.getKey());
            task.setExecuteStatus(ExecuteStatusEnum.notExecuted);
            task.setIdentity(identityStr);
            task.setParamObj(paramObjJsonStr);
            task.setCreateTime(createTime);
            task.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            task.setMovedOrgId(orgMoveParam.getMovedOrgId());
            taskCol.add((CoreBaseInfo)task);
        }
        iAfterOrgMoveTask.saveBatchData(taskCol);
        return identityStr;
    }

    public static AfterOrgMoveTaskCollection getTaskList(String taskIdentity, String selectedOrgId, boolean showExecuted) throws BOSException {
        FilterItemInfo isExecutedFilterItem;
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)taskIdentity)) {
            FilterItemInfo identityFilterItem = new FilterItemInfo("identity", (Object)taskIdentity, CompareType.EQUALS);
            filter.getFilterItems().add(identityFilterItem);
        } else {
            FilterItemInfo moveOrgIdFilterItem = new FilterItemInfo("movedOrgId", (Object)selectedOrgId);
            filter.getFilterItems().add(moveOrgIdFilterItem);
        }
        if (!showExecuted) {
            isExecutedFilterItem = new FilterItemInfo("executeStatus", (Object)0, CompareType.EQUALS);
            filter.getFilterItems().add(isExecutedFilterItem);
        } else {
            isExecutedFilterItem = new FilterItemInfo("executeStatus", (Object)2, CompareType.NOTEQUALS);
            filter.getFilterItems().add(isExecutedFilterItem);
        }
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo createTimeSorter = new SorterItemInfo("createTime");
        sorters.add(createTimeSorter);
        SorterItemInfo handlerSorter = new SorterItemInfo("handler");
        sorters.add(handlerSorter);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSorter(sorters);
        IAfterOrgMoveTask iAfterOrgMoveTask = AfterOrgMoveTaskFactory.getRemoteInstance();
        return iAfterOrgMoveTask.getAfterOrgMoveTaskCollection(view);
    }
}

