/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgView;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForEntityEnum;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgUIDataUtil {
    private static Logger logger = Logger.getLogger((String)OrgUIDataUtil.class.getName());
    private Map orgInfoCacheMap = new HashMap();

    public static FullOrgUnitInfo[] getFullInfosInDifferentTrees(List idList, boolean isShowSub) throws Exception {
        if (idList == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int j = idList.size();
        for (int i = 0; i < j; ++i) {
            String temp = (String)idList.get(i);
            sb.append("'").append(temp).append("',");
        }
        StringBuffer oql = new StringBuffer("select * where id in (");
        oql.append(sb.substring(0, sb.length() - 1)).append(") order by longNumber");
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitCollection col = iFull.getFullOrgUnitCollection(oql.toString());
        Object[] infos = col.toArray();
        if (isShowSub) {
            block1: for (int i = 0; i < infos.length; ++i) {
                String longNumber = ((FullOrgUnitInfo)infos[i]).getLongNumber();
                for (int j2 = 0; j2 < i; ++j2) {
                    if (!longNumber.startsWith(((FullOrgUnitInfo)infos[j2]).getLongNumber() + "!")) continue;
                    col.remove((FullOrgUnitInfo)infos[i]);
                    continue block1;
                }
            }
        }
        infos = col.toArray();
        FullOrgUnitInfo[] unitInfos = new FullOrgUnitInfo[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            unitInfos[i] = (FullOrgUnitInfo)infos[i];
        }
        return unitInfos;
    }

    public boolean isEntityOrgUnit(String orgId, OrgTypeForEntityEnum currentOrgTypeForEntity) throws BOSException, EASBizException {
        if (!this.orgInfoCacheMap.containsKey((Object)currentOrgTypeForEntity)) {
            IOrgView iOrgView = OrgViewFactory.getRemoteInstance();
            BizOrgQueryParam bizOrgParam = new BizOrgQueryParam();
            bizOrgParam.setBizUnitType("TRUE");
            OrgUnitCollection orgUnitCol = iOrgView.getOrgUnitCollection(OrgTypeInfoMgr.getInstance().getOrgTypeInfo(currentOrgTypeForEntity).getOrgType(), bizOrgParam);
            HashSet<String> bizUnitSet = new HashSet<String>();
            for (int i = 0; i < orgUnitCol.size(); ++i) {
                bizUnitSet.add(orgUnitCol.get(i).getId().toString());
            }
            this.orgInfoCacheMap.put(currentOrgTypeForEntity, bizUnitSet);
        }
        Set cacheSet = (Set)this.orgInfoCacheMap.get((Object)currentOrgTypeForEntity);
        logger.debug((Object)("currentOrgTypeForEntity is" + (Object)((Object)currentOrgTypeForEntity) + " org Id is:" + orgId + " set is:" + cacheSet));
        return cacheSet.contains(orgId);
    }

    public boolean isEntityOrg(String orgId, OrgType orgType, BizOrgQueryParam bizOrgParam) throws BOSException, EASBizException {
        String cacheKey;
        if (bizOrgParam == null) {
            bizOrgParam = new BizOrgQueryParam();
            bizOrgParam.setBizUnitType("TRUE");
        }
        if (!this.orgInfoCacheMap.containsKey(cacheKey = (Object)((Object)orgType) + bizOrgParam.toString())) {
            IOrgView iOrgView = OrgViewFactory.getRemoteInstance();
            OrgUnitCollection orgUnitCol = iOrgView.getOrgUnitCollection(orgType, bizOrgParam);
            HashSet<String> bizUnitSet = new HashSet<String>();
            for (int i = 0; i < orgUnitCol.size(); ++i) {
                bizUnitSet.add(orgUnitCol.get(i).getId().toString());
            }
            this.orgInfoCacheMap.put(cacheKey, bizUnitSet);
        }
        Set cacheSet = (Set)this.orgInfoCacheMap.get(cacheKey);
        logger.debug((Object)("currentOrgTypeForEntity is" + (Object)((Object)orgType) + " org Id is:" + orgId + " set is:" + cacheSet));
        return cacheSet.contains(orgId);
    }

    public boolean isSealUpOrg(String orgId, OrgType orgType) throws EASBizException, BOSException {
        BizOrgQueryParam bizOrgParam = new BizOrgQueryParam();
        bizOrgParam.setOrgOUSealType("TRUE");
        if (orgType.getValue() == 10 || orgType.getValue() == -1) {
            bizOrgParam.setBizObjType("BIZOBJ_VIEW");
        } else {
            bizOrgParam.setBizObjType("BIZOBJ_PART");
        }
        return this.isEntityOrg(orgId, orgType, bizOrgParam);
    }

    public static void setValueInfo(IObjectValue iObjectValue, IRowSet rowSet, Map fieldMap, Map filedAliasMap) throws SQLException {
        if (iObjectValue == null || rowSet == null || fieldMap == null || fieldMap.isEmpty()) {
            throw new IllegalArgumentException(" iObjectValue,rowSet,fieldMap is null!");
        }
        for (String filedName : fieldMap.keySet()) {
            String clazzName = (String)fieldMap.get(filedName);
            String fieldAliasName = (String)filedAliasMap.get(filedName);
            iObjectValue.put(filedName, OrgUIDataUtil.getRowSetValue(rowSet, fieldAliasName, clazzName));
        }
    }

    public static Object getRowSetValue(IRowSet rowSet, String fieldAliasName, String clazzName) throws SQLException {
        logger.debug((Object)("get fieldAliasName is" + fieldAliasName));
        String value = rowSet.getString(fieldAliasName);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        logger.debug((Object)("value is:" + value));
        if (String.class.getName().equals(clazzName)) {
            return value;
        }
        if (BOSUuid.class.getName().equals(clazzName)) {
            return BOSUuid.read((String)value);
        }
        if (Date.class.getName().equals(clazzName)) {
            return new Date(rowSet.getDate(fieldAliasName).getTime());
        }
        if (Boolean.class.getName().equals(clazzName)) {
            if ("1".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (Integer.class.getName().equals(clazzName)) {
            return new Integer(value);
        }
        return null;
    }

    public void initOrgInfoCacheMap() {
        this.orgInfoCacheMap.clear();
    }
}

