/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgView;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.eas.basedata.org.client.tree.util.OrgTreeUtil;
import com.kingdee.eas.basedata.org.stepadd.QueryTreeParamInfo;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class CUTreeBuilder {
    private boolean isCu;
    private boolean isStruct;
    private boolean isViewAll;
    private boolean isContainOUSealUp = true;
    private OrgTreeInfo orgTreeInfo;
    private Object parentInfo = null;
    private boolean useORMapping = true;
    private boolean isShowAssistantOrg = false;
    private static Logger logger = Logger.getLogger(CUTreeBuilder.class);

    public CUTreeBuilder(Object parentInfo, boolean isBolCU, boolean isOrgStructure, OrgTreeInfo treeInfo, boolean isViewAll) throws Exception {
        this.parentInfo = parentInfo;
        this.isCu = isBolCU;
        this.isStruct = isOrgStructure;
        this.orgTreeInfo = treeInfo;
        this.isViewAll = isViewAll;
    }

    public CUTreeBuilder(Object parentInfo, boolean isBolCU, boolean isOrgStructure, OrgTreeInfo treeInfo, boolean isViewAll, boolean isContainOUSealUp) throws Exception {
        this(parentInfo, isBolCU, isOrgStructure, treeInfo, isViewAll);
        this.isContainOUSealUp = isContainOUSealUp;
    }

    public CUTreeBuilder(Object parentInfo, boolean isBolCU, boolean isOrgStructure, OrgTreeInfo treeInfo, boolean isViewAll, boolean isContainOUSealUp, boolean useORMapping) throws Exception {
        this(parentInfo, isBolCU, isOrgStructure, treeInfo, isViewAll);
        this.isContainOUSealUp = isContainOUSealUp;
        this.useORMapping = useORMapping;
    }

    public CUTreeBuilder(Object parentInfo, boolean isBolCU, boolean isOrgStructure, OrgTreeInfo treeInfo, boolean isViewAll, boolean isContainOUSealUp, boolean useORMapping, boolean isShowAssistantOrg) throws Exception {
        this(parentInfo, isBolCU, isOrgStructure, treeInfo, isViewAll);
        this.isContainOUSealUp = isContainOUSealUp;
        this.useORMapping = useORMapping;
        this.isShowAssistantOrg = isShowAssistantOrg;
    }

    public JTree buildTree(JTree tree) throws Exception {
        return this.buildTree(tree, null);
    }

    public JTree buildTree(JTree tree, StepAddParamInfo stepAddParamInfo) throws Exception {
        KDTreeNode rootNode = new KDTreeNode(this.parentInfo);
        AbstractObjectCollection col = this.getChildren(null, stepAddParamInfo);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        this.buildChildren(rootNode, col, stepAddParamInfo);
        tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
        tree.setShowsRootHandles(true);
        return tree;
    }

    public TreeModel buildTreeModel() throws Exception {
        KDTreeNode rootNode = new KDTreeNode(this.parentInfo);
        AbstractObjectCollection col = this.getChildren(null);
        this.buildChildren(rootNode, col);
        return new DefaultTreeModel((TreeNode)rootNode);
    }

    public TreeModel buildTreeModel(FullOrgUnitInfo pInfo, StepAddParamInfo stepAddParamInfo) throws Exception {
        KDTreeNode rootNode = new KDTreeNode(this.parentInfo);
        AbstractObjectCollection col = this.getChildren(pInfo, stepAddParamInfo);
        this.buildChildren(rootNode, col, stepAddParamInfo);
        return new DefaultTreeModel((TreeNode)rootNode);
    }

    private void buildChildren(KDTreeNode parentNode, AbstractObjectCollection col, StepAddParamInfo stepAddParamInfo) {
        OrgTreeUtil.insertNode2Root((DefaultKingdeeTreeNode)parentNode, col, this.isStruct, stepAddParamInfo);
    }

    private void buildChildren(KDTreeNode parentNode, AbstractObjectCollection col) {
        OrgTreeUtil.insertNode2Root((DefaultKingdeeTreeNode)parentNode, col, this.isStruct, null);
    }

    public void refreshTreeNode(JTree tree, KDTreeNode parentNode) throws Exception {
        AbstractObjectCollection col = this.getChildren(null);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        this.buildChildren(parentNode, col);
    }

    public AbstractObjectCollection getChildren(FullOrgUnitInfo pInfo) throws Exception {
        return this.getChildren(pInfo, null);
    }

    public AbstractObjectCollection getChildren(FullOrgUnitInfo pInfo, StepAddParamInfo stepAddParamInfo) throws Exception {
        IOrgView iOrgView = OrgViewFactory.getRemoteInstance();
        QueryTreeParamInfo queryInfo = new QueryTreeParamInfo(this.parentInfo, pInfo, this.isCu, this.isStruct, this.orgTreeInfo, this.isViewAll, this.isContainOUSealUp, this.useORMapping, this.isShowAssistantOrg);
        logger.info((Object)(" query child org param is:" + queryInfo + " stepAddParamInfo is:" + stepAddParamInfo));
        AbstractObjectCollection retCol = iOrgView.getChildren(queryInfo, stepAddParamInfo);
        logger.info((Object)(" retCol data size is:" + retCol.size()));
        return retCol;
    }
}

