/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.tree.ILNOrgTreeNodeCtrl;
import com.kingdee.eas.basedata.org.client.tree.OrgUnitNodeInfo;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.jdbc.rowset.IRowSet;

public class DefaultLNOrgTreeNodeCtrl
implements ILNOrgTreeNodeCtrl {
    IOrgStructure iOrgStructure = null;
    OrgTreeInfo treeInfo = null;
    boolean isInAvailGroup = true;

    public DefaultLNOrgTreeNodeCtrl(IOrgStructure iOrgStructure, OrgTreeInfo treeInfo) throws Exception {
        this.iOrgStructure = iOrgStructure;
        this.treeInfo = treeInfo;
    }

    public DefaultLNOrgTreeNodeCtrl(IOrgStructure iOrgStructure, OrgTreeInfo treeInfo, boolean isInAvailGroup) throws Exception {
        this.iOrgStructure = iOrgStructure;
        this.treeInfo = treeInfo;
        this.isInAvailGroup = isInAvailGroup;
    }

    @Override
    public AbstractObjectCollection getChildren(OrgUnitNodeInfo parentNodeInfo, int level, boolean isGroup) throws Exception {
        return this.getChildren(parentNodeInfo, level, isGroup, null);
    }

    @Override
    public AbstractObjectCollection getChildren(OrgUnitNodeInfo parentNodeInfo, int level, boolean isGroup, FilterInfo filter) throws Exception {
        OrgStructureCollection result = null;
        result = parentNodeInfo != null ? this.iOrgStructure.getTreeCollection(parentNodeInfo.getStructureInfo(), this.treeInfo, this.isInAvailGroup, isGroup) : this.iOrgStructure.getTreeCollection(null, this.treeInfo, this.isInAvailGroup, isGroup);
        return result;
    }

    private String getMaskString(int count) {
        String maskStr = "";
        if (count < 2) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            maskStr = i == 0 ? maskStr + "#" + String.valueOf(i) : maskStr + " and #" + String.valueOf(i);
        }
        return maskStr;
    }

    @Override
    public IRowSet getChildrenByRowSet(OrgUnitNodeInfo strucInfo, int level, boolean isGroup, FilterInfo filter) throws Exception {
        OrgTreeInfo tInfo = this.treeInfo;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId()));
        int filterCount = 0;
        if (filter != null && filter.size() > 0) {
            for (int i = 0; i < filter.size(); ++i) {
                filterInfo.getFilterItems().add(filter.getFilterItems().get(i));
            }
            filterCount = filter.size();
        }
        if (filterCount + 1 >= 2) {
            filterInfo.setMaskString(this.getMaskString(filterCount + 1));
        }
        if (isGroup) {
            filterInfo.getFilterItems().add(new FilterItemInfo("unit.isGrouping", (Object)new Integer(1)));
            filterInfo.setMaskString(this.getMaskString(filterCount + 2));
        }
        if (strucInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(strucInfo.getLongNumber() + "%"), CompareType.LIKE));
            if (isGroup) {
                filterInfo.setMaskString(this.getMaskString(filterCount + 3));
            } else {
                filterInfo.setMaskString(this.getMaskString(filterCount + 2));
            }
        }
        viewInfo.setFilter(filterInfo);
        OrgType curOrgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(tInfo.getType()).getOrgType();
        String queryName = OrgTypeClientCenter.getInstance().getClientImp(curOrgType).findQueryStr("QUERY_TYPE_ORG_BUILD_TREE");
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = null;
        rows = queryExcu.executeQuery();
        return rows;
    }
}

