/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree;

import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AbstractOrgStructureInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOrgInnerFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.tree.ILNOrgTreeNodeCtrl;
import com.kingdee.eas.basedata.org.client.tree.IOrgTreeBuilder;
import com.kingdee.eas.basedata.org.client.tree.OrgUnitNodeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LNOrgTreeBuilder
implements IOrgTreeBuilder {
    private ILNOrgTreeNodeCtrl ctrl;
    private int initalLevel;
    private int expandLevel;
    private boolean isGroup;
    private boolean isInAvailGroup = true;

    public LNOrgTreeBuilder(ILNOrgTreeNodeCtrl ctrl, int initalLevel, int expandLevel, boolean isGroup) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.isGroup = isGroup;
    }

    public LNOrgTreeBuilder(ILNOrgTreeNodeCtrl ctrl, int initalLevel, int expandLevel, boolean isGroup, boolean isInAvailGroup) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.isGroup = isGroup;
        this.isInAvailGroup = isInAvailGroup;
    }

    @Override
    public JTree buildTree(JTree tree, FilterInfo filter) throws Exception {
        return this.buildTree(tree, filter, null);
    }

    @Override
    public JTree buildTree(JTree tree) throws Exception {
        return this.buildTree(tree, null);
    }

    private void getChildren(KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            OrgUnitNodeInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof OrgUnitNodeInfo) {
                treeNodeInfo = (OrgUnitNodeInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            treeNode.removeAllChildren();
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel, this.isGroup);
            this.buildChildren(treeNode, col, this.expandLevel);
        }
    }

    private void buildChildren(KDTreeNode parentNode, AbstractObjectCollection col, int level) throws Exception {
        KDTreeNode beforeTreeNode = parentNode;
        Icon iconBusiness = EASResource.getIcon((String)"imgTree_businessgroup");
        Icon iconGroup = EASResource.getIcon((String)"imgTree_group");
        Icon iconCompany = EASResource.getIcon((String)"imgTree_company");
        if (!this.isInAvailGroup) {
            this.builderInAvailTree(parentNode, col, level);
            return;
        }
        Iterator iter = col.iterator();
        Object curStrucInfo = null;
        while (iter.hasNext()) {
            OrgStructureInfo treeNodeInfo = (OrgStructureInfo)iter.next();
            OrgUnitNodeInfo nodeInfo = new OrgUnitNodeInfo(treeNodeInfo);
            KDTreeNode treeNode = new KDTreeNode((Object)nodeInfo);
            if (nodeInfo.getLevel() == 1) {
                if (nodeInfo.getOrgUnitInfo().isIsGrouping()) {
                    treeNode.setCustomIcon(iconBusiness);
                } else {
                    treeNode.setCustomIcon(iconGroup);
                }
            }
            if (beforeTreeNode.getLevel() == 0) {
                beforeTreeNode.add((MutableTreeNode)treeNode);
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((OrgUnitNodeInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                if (((OrgUnitNodeInfo)treeNode.getUserObject()).getOrgUnitInfo().isIsGrouping()) {
                    treeNode.setCustomIcon(iconBusiness);
                } else {
                    treeNode.setCustomIcon(iconCompany);
                }
                beforeTreeNode.add((MutableTreeNode)treeNode);
            }
            beforeTreeNode = treeNode;
        }
    }

    private void buildChildrenByRowSet(KDTreeNode parentNode, IRowSet rows, int level) throws Exception {
        Icon iconBusiness = EASResource.getIcon((String)"imgTree_businessgroup");
        Icon iconGroup = EASResource.getIcon((String)"imgTree_group");
        Icon iconCompany = EASResource.getIcon((String)"imgTree_company");
        KDTreeNode beforeTreeNode = parentNode;
        if (!this.isInAvailGroup) {
            this.builderInAvailTreeByRowSet(parentNode, rows, level);
            return;
        }
        Object curStrucInfo = null;
        if (rows == null) {
            return;
        }
        while (rows.next()) {
            OrgStructureInfo treeNodeInfo = this.createOrgStructureInfo(rows);
            OrgUnitNodeInfo nodeInfo = new OrgUnitNodeInfo(treeNodeInfo);
            KDTreeNode treeNode = new KDTreeNode((Object)nodeInfo);
            if (nodeInfo.getLevel() == 1) {
                if (nodeInfo.getOrgUnitInfo().isIsGrouping()) {
                    treeNode.setCustomIcon(iconBusiness);
                } else {
                    treeNode.setCustomIcon(iconGroup);
                }
            }
            if (beforeTreeNode.getLevel() == 0) {
                beforeTreeNode.add((MutableTreeNode)treeNode);
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((OrgUnitNodeInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                if (((OrgUnitNodeInfo)treeNode.getUserObject()).getOrgUnitInfo().isIsGrouping()) {
                    treeNode.setCustomIcon(iconBusiness);
                } else {
                    treeNode.setCustomIcon(iconCompany);
                }
                int index = ((OrgUnitNodeInfo)treeNode.getUserObject()).getIndex();
                int childCount = beforeTreeNode.getChildCount();
                if (childCount == 0 || index == 0) {
                    beforeTreeNode.add((MutableTreeNode)treeNode);
                } else if (index == 1) {
                    beforeTreeNode.insert((MutableTreeNode)treeNode, 0);
                } else {
                    boolean flag = true;
                    int size = beforeTreeNode.getChildCount();
                    for (int i = 0; i < size; ++i) {
                        KDTreeNode childNode = (KDTreeNode)beforeTreeNode.getChildAt(i);
                        if (index >= ((OrgUnitNodeInfo)childNode.getUserObject()).getIndex()) continue;
                        beforeTreeNode.insert((MutableTreeNode)treeNode, i);
                        flag = false;
                        break;
                    }
                    if (flag) {
                        beforeTreeNode.add((MutableTreeNode)treeNode);
                    }
                }
            }
            beforeTreeNode = treeNode;
        }
    }

    private OrgStructureInfo createOrgStructureInfo(IRowSet row) throws UuidException, SQLException {
        OrgStructureInfo structInfo = new OrgStructureInfo();
        structInfo.setId(BOSUuid.read((String)row.getString("id")));
        structInfo.setLongNumber(row.getString("longNumber"));
        structInfo.setLevel(row.getInt("level"));
        structInfo.setIsLeaf(row.getBoolean("isLeaf"));
        OrgUnitInfo orgUnitInfo = new OrgUnitInfo();
        orgUnitInfo.setId(BOSUuid.read((String)row.getString("unit.id")));
        orgUnitInfo.setNumber(row.getString("unit.number"));
        orgUnitInfo.setName(row.getString("unit.name"));
        orgUnitInfo.setIsGrouping(row.getBoolean("unit.isGrouping"));
        orgUnitInfo.setIsFreeze(row.getBoolean("unit.isFreeze"));
        orgUnitInfo.setInvalidDate(row.getDate("unit.invalidDate"));
        orgUnitInfo.setEffectDate(row.getDate("unit.effectDate"));
        switch (row.getInt("tree.type")) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                break;
            }
        }
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(BOSUuid.read((String)row.getString("tree.id")));
        structInfo.setTree(treeInfo);
        return structInfo;
    }

    void builderInAvailTree(KDTreeNode parentNode, AbstractObjectCollection col, int level) throws Exception {
        Icon iconBusiness = EASResource.getIcon((String)"imgTree_businessgroup");
        Icon iconGroup = EASResource.getIcon((String)"imgTree_group");
        Icon iconCompany = EASResource.getIcon((String)"imgTree_company");
        KDTreeNode beforeTreeNode = parentNode;
        Iterator iter = col.iterator();
        OrgStructureCollection strucInfos = (OrgStructureCollection)col;
        Date date1 = null;
        IOrgInnerFacade iInner = OrgInnerFacadeFactory.getRemoteInstance();
        date1 = iInner.getServerDate();
        if (strucInfos.size() != 0 && strucInfos.get(0).getUnit().getInvalidDate() != null && DateTimeUtils.dayBefore((Date)strucInfos.get(0).getUnit().getInvalidDate(), (Date)date1)) {
            return;
        }
        AbstractOrgStructureInfo curNodeInfo = null;
        while (iter.hasNext()) {
            OrgStructureInfo treeNodeInfo = (OrgStructureInfo)iter.next();
            OrgUnitNodeInfo nodeInfo = new OrgUnitNodeInfo(treeNodeInfo);
            KDTreeNode treeNode = new KDTreeNode((Object)nodeInfo);
            if (nodeInfo.getLevel() == 1) {
                if (nodeInfo.getOrgUnitInfo().isIsGrouping()) {
                    treeNode.setCustomIcon(iconBusiness);
                } else {
                    treeNode.setCustomIcon(iconGroup);
                }
            }
            if (beforeTreeNode.getLevel() == 0) {
                beforeTreeNode.add((MutableTreeNode)treeNode);
            } else {
                if (curNodeInfo != null && treeNodeInfo.getLongNumber().startsWith(curNodeInfo.getLongNumber())) continue;
                if (!treeNodeInfo.getUnit().isIsGrouping() && treeNodeInfo.getUnit().getInvalidDate() != null && DateTimeUtils.dayBefore((Date)treeNodeInfo.getUnit().getInvalidDate(), (Date)date1)) {
                    curNodeInfo = treeNodeInfo;
                    continue;
                }
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((OrgUnitNodeInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                if (((OrgUnitNodeInfo)treeNode.getUserObject()).getOrgUnitInfo().isIsGrouping()) {
                    treeNode.setCustomIcon(iconBusiness);
                } else {
                    treeNode.setCustomIcon(iconCompany);
                }
                beforeTreeNode.add((MutableTreeNode)treeNode);
            }
            beforeTreeNode = treeNode;
        }
    }

    void builderInAvailTreeByRowSet(KDTreeNode parentNode, IRowSet rows, int level) throws Exception {
        Icon iconBusiness = EASResource.getIcon((String)"imgTree_businessgroup");
        Icon iconGroup = EASResource.getIcon((String)"imgTree_group");
        Icon iconCompany = EASResource.getIcon((String)"imgTree_company");
        KDTreeNode beforeTreeNode = parentNode;
        Date date1 = null;
        IOrgInnerFacade iInner = OrgInnerFacadeFactory.getRemoteInstance();
        date1 = iInner.getServerDate();
        if (rows == null) {
            return;
        }
        if (rows.size() != 0) {
            rows.first();
            if (rows.getDate("unit.invalidDate") != null && DateTimeUtils.dayBefore((Date)rows.getDate("unit.invalidDate"), (Date)date1)) {
                return;
            }
        }
        AbstractOrgStructureInfo curNodeInfo = null;
        rows.beforeFirst();
        while (rows.next()) {
            OrgStructureInfo treeNodeInfo = this.createOrgStructureInfo(rows);
            OrgUnitNodeInfo nodeInfo = new OrgUnitNodeInfo(treeNodeInfo);
            KDTreeNode treeNode = new KDTreeNode((Object)nodeInfo);
            if (nodeInfo.getLevel() == 1) {
                if (nodeInfo.getOrgUnitInfo().isIsGrouping()) {
                    treeNode.setCustomIcon(iconBusiness);
                } else {
                    treeNode.setCustomIcon(iconGroup);
                }
            }
            if (beforeTreeNode.getLevel() == 0) {
                beforeTreeNode.add((MutableTreeNode)treeNode);
            } else {
                if (curNodeInfo != null && treeNodeInfo.getLongNumber().startsWith(curNodeInfo.getLongNumber())) continue;
                if (!treeNodeInfo.getUnit().isIsGrouping() && treeNodeInfo.getUnit().getInvalidDate() != null && DateTimeUtils.dayBefore((Date)treeNodeInfo.getUnit().getInvalidDate(), (Date)date1)) {
                    curNodeInfo = treeNodeInfo;
                    continue;
                }
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((OrgUnitNodeInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                if (((OrgUnitNodeInfo)treeNode.getUserObject()).getOrgUnitInfo().isIsGrouping()) {
                    treeNode.setCustomIcon(iconBusiness);
                } else {
                    treeNode.setCustomIcon(iconCompany);
                }
                int index = ((OrgUnitNodeInfo)treeNode.getUserObject()).getIndex();
                int childCount = beforeTreeNode.getChildCount();
                if (childCount == 0) {
                    beforeTreeNode.add((MutableTreeNode)treeNode);
                } else if (index == 0) {
                    beforeTreeNode.insert((MutableTreeNode)treeNode, 0);
                } else {
                    boolean flag = true;
                    int size = beforeTreeNode.getChildCount();
                    for (int i = 0; i < size; ++i) {
                        KDTreeNode childNode = (KDTreeNode)beforeTreeNode.getChildAt(i);
                        if (index >= ((OrgUnitNodeInfo)childNode.getUserObject()).getIndex()) continue;
                        beforeTreeNode.insert((MutableTreeNode)treeNode, i);
                        flag = false;
                        break;
                    }
                    if (flag) {
                        beforeTreeNode.add((MutableTreeNode)treeNode);
                    }
                }
            }
            beforeTreeNode = treeNode;
        }
    }

    @Override
    public void refreshTreeNode(KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(false);
        this.getChildren(treeNode);
    }

    @Override
    public JTree buildTree(final JTree tree, FilterInfo filter, OrgUnitNodeInfo nodeInfo) throws Exception {
        if (tree.getModel() == null || tree.getModel().getRoot() == null || !(tree.getModel().getRoot() instanceof KDTreeNode)) {
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
        }
        IRowSet rows = null;
        INewOrgViewFacade facade = NewOrgViewFacadeFactory.getRemoteInstance();
        rows = facade.buildRowSetByCU(SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString(), "00000000-0000-0000-0000-0000000000034F2827FD");
        if (rows != null && rows.size() == 1) {
            tree.putClientProperty("JTree.lineStyle", "None");
        } else {
            tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        if (rows != null) {
            // empty if block
        }
        tree.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(tree.getModel().getRoot())) {
                    tree.expandPath(new TreePath(tree.getModel().getRoot()));
                }
            }
        });
        tree.setRootVisible(true);
        tree.setModel(new DefaultTreeModel((TreeNode)NewOrgViewHelper.buildTreeByRowSet(rows)));
        tree.setShowsRootHandles(true);
        return tree;
    }
}

