/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class MutiRootTreeHelper {
    public static DefaultTreeModel unionMutiRootTree(TreeModel[] models, boolean isShowSub) {
        int i;
        boolean[] retains = new boolean[models.length];
        DefaultKingdeeTreeNode[] roots = new DefaultKingdeeTreeNode[models.length];
        for (i = 0; i < models.length; ++i) {
            retains[i] = true;
            roots[i] = (DefaultKingdeeTreeNode)models[i].getRoot();
        }
        if (!isShowSub && models.length > 1) {
            for (i = models.length - 1; i > 0; --i) {
                String siblingLongNumber;
                DefaultKingdeeTreeNode siblingNode;
                int k;
                String parentLongNumber;
                int j;
                String longNumber = ((FullOrgUnitInfo)roots[i].getUserObject()).getLongNumber();
                for (j = i - 1; j >= 0 && !longNumber.startsWith(parentLongNumber = ((FullOrgUnitInfo)roots[j].getUserObject()).getLongNumber() + "!"); --j) {
                }
                if (j < 0) continue;
                int count = roots[j].getChildCount();
                for (k = 0; k < count && (siblingNode = (DefaultKingdeeTreeNode)roots[j].getChildAt(k)).getUserObject() != null && longNumber.compareTo(siblingLongNumber = ((FullOrgUnitInfo)siblingNode.getUserObject()).getLongNumber()) >= 0; ++k) {
                }
                roots[j].insert((MutableTreeNode)roots[i], k);
                retains[i] = false;
            }
        }
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
        for (int i2 = 0; i2 < roots.length; ++i2) {
            if (!retains[i2]) continue;
            rootNode.add((MutableTreeNode)roots[i2]);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
        return treeModel;
    }

    public static TreeModel buildMutiRootTreeModel(boolean isStruct, List rootUnits, OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        DefaultKingdeeTreeNode virtualRoot = MutiRootTreeHelper.buildMutiRootTree(isStruct, rootUnits, orgViewType, orgTreeInfo);
        return new DefaultTreeModel((TreeNode)virtualRoot);
    }

    public static DefaultKingdeeTreeNode buildMutiRootTree(boolean isStruct, List rootUnits, OrgViewType orgViewType, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        DefaultKingdeeTreeNode virtualRoot = new DefaultKingdeeTreeNode();
        if (null == rootUnits || 0 == rootUnits.size()) {
            return virtualRoot;
        }
        if (!isStruct) {
            for (int i = 0; i < rootUnits.size(); ++i) {
                virtualRoot.add((MutableTreeNode)new DefaultKingdeeTreeNode(rootUnits.get(i)));
            }
            return virtualRoot;
        }
        HashSet<String> isOrgTypeUnitIDs = new HashSet<String>();
        OrgType orgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType).getOrgType();
        for (int i = 0; i < rootUnits.size(); ++i) {
            FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)rootUnits.get(i);
            boolean isOrgType = OrgUtils.isOrgType(unitInfo, orgType);
            if (!isOrgType) continue;
            isOrgTypeUnitIDs.add(unitInfo.getId().toString());
        }
        OrgStructureCollection coll = MutiRootTreeHelper.getStructureCollection(orgTreeInfo.getId().toString(), isOrgTypeUnitIDs);
        if (null == coll || 0 == coll.size()) {
            return virtualRoot;
        }
        for (int i = 0; i < coll.size(); ++i) {
            virtualRoot.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)coll.getObject(i)));
        }
        return virtualRoot;
    }

    private static OrgStructureCollection getStructureCollection(String treeID, Set rootUnitIDs) throws BOSException, EASBizException {
        assert (!StringUtils.isEmpty((String)treeID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)rootUnitIDs, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("unit.name"));
        selectors.add(new SelectorItemInfo("longnumber"));
        selectors.add(new SelectorItemInfo("isleaf"));
        selectors.add(new SelectorItemInfo("unit.iscu"));
        selectors.add(new SelectorItemInfo("unit.isunion"));
        selectors.add(new SelectorItemInfo("unit.cu.id"));
        viewInfo.setSelector(selectors);
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("longnumber"));
        viewInfo.setSorter(sorters);
        IOrgStructure istruct = OrgStructureFactory.getRemoteInstance();
        return istruct.getOrgStructureCollection(viewInfo);
    }
}

