/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree.step;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.client.tree.step.OrgInfoHelper;
import com.kingdee.eas.basedata.org.client.tree.stepadd.AbstractKDTreeSExt;
import com.kingdee.eas.basedata.org.client.tree.stepadd.IDataProvider;
import com.kingdee.eas.basedata.org.client.tree.stepadd.IKDTreeStep;
import com.kingdee.eas.basedata.org.client.tree.stepadd.StepAddEvent;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.Assert;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class KDTreeOrgExt
extends AbstractKDTreeSExt
implements IKDTreeStep {
    private static Logger logger = Logger.getLogger(KDTreeOrgExt.class);
    private KDTree targetTree;

    public KDTreeOrgExt(KDTree targetTree) {
        this.targetTree = targetTree;
    }

    @Override
    public void stepAddData(StepAddEvent stepAddDataEvent) throws Exception {
        if (stepAddDataEvent.getIDataProvider() == null && StringUtils.isEmpty((String)stepAddDataEvent.getDealClassName())) {
            throw new IllegalArgumentException("dealClassName is null");
        }
        CoreBaseInfo tempVo = (CoreBaseInfo)stepAddDataEvent.getCurNode().getUserObject();
        if ("true".equals((String)tempVo.get("treeLoad")) && stepAddDataEvent.getCurLevel() != -1) {
            logger.info((Object)("this node already loaded" + tempVo.get("longNumber")));
            return;
        }
        if ("true".equals((String)tempVo.get("allSubTreeLoad")) && stepAddDataEvent.getCurLevel() == -1) {
            logger.info((Object)("this node all sub tree already loaded" + tempVo.get("longNumber")));
            return;
        }
        IDataProvider dataProvider = stepAddDataEvent.getIDataProvider();
        if (dataProvider == null) {
            dataProvider = this.getProvider(stepAddDataEvent.getDealClassName());
        }
        KDTree subTree = dataProvider.getSubTree(stepAddDataEvent);
        this.insertNewTree2Root(stepAddDataEvent.getCurNode(), subTree, dataProvider);
        tempVo.put("treeLoad", (Object)"true");
        if (stepAddDataEvent.getCurLevel() == -1 && !(tempVo instanceof OrgTreeInfo)) {
            this.setAllSubNodeAlreadyLoad(stepAddDataEvent.getCurNode());
        }
    }

    private void setAllSubNodeAlreadyLoad(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getUserObject() instanceof CoreBaseInfo) {
            CoreBaseInfo tempVo = (CoreBaseInfo)node.getUserObject();
            tempVo.put("treeLoad", (Object)"true");
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setAllSubNodeAlreadyLoad((DefaultKingdeeTreeNode)node.getChildAt(i));
        }
    }

    private String getNodeId(DefaultKingdeeTreeNode newNode) {
        return OrgInfoHelper.getNodeId(newNode);
    }

    private String getNodeNumber(DefaultKingdeeTreeNode newNode) {
        return OrgInfoHelper.getNodeNumber(newNode);
    }

    private String getNodeName(DefaultKingdeeTreeNode newNode) {
        return OrgInfoHelper.getNodeName(newNode);
    }

    private String getNodeParentNumber(DefaultKingdeeTreeNode newNode) {
        return OrgInfoHelper.getNodeParentNumber(newNode);
    }

    private void insertNewTree2Root(DefaultKingdeeTreeNode curNode, KDTree subTree, IDataProvider dataProvider) {
        if (subTree == null) {
            return;
        }
        String curNodeNumber = this.getNodeNumber(curNode);
        DefaultKingdeeTreeNode subTreeNode = (DefaultKingdeeTreeNode)((DefaultTreeModel)subTree.getModel()).getRoot();
        DefaultKingdeeTreeNode newTempNode = dataProvider.findNewRootNode(subTreeNode, curNodeNumber);
        if (newTempNode == null) {
            return;
        }
        logger.info((Object)("issert new node ,node info is:" + this.getNodeNumber(newTempNode)));
        Map alreayMap = this.getCurNodeChildPermItemId(curNode);
        for (int i = newTempNode.getChildCount() - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode newAddNode = (DefaultKingdeeTreeNode)newTempNode.getChildAt(i);
            if ((newAddNode == null || !curNodeNumber.equals(this.getNodeParentNumber(newAddNode))) && (newAddNode == null || !StringUtils.isEmpty((String)curNodeNumber))) continue;
            CoreBaseInfo readyInsertNode = (CoreBaseInfo)newAddNode.getUserObject();
            if (alreayMap.keySet().contains(readyInsertNode.getId())) {
                logger.info((Object)("already have this node ,node is:" + this.getNodeNumber(newAddNode) + " , name is:" + this.getNodeName(newAddNode)));
                DefaultKingdeeTreeNode insertChildNode = (DefaultKingdeeTreeNode)alreayMap.get(readyInsertNode.getId());
                logger.info((Object)"already have this node ,node is, copy child node");
                DefaultKingdeeTreeNode oldParentNode = (DefaultKingdeeTreeNode)insertChildNode.getParent();
                this.targetTree.removeNodeFromParent((MutableTreeNode)insertChildNode);
                this.targetTree.insertNodeInto((MutableTreeNode)newAddNode, (MutableTreeNode)oldParentNode, 0);
                logger.info((Object)"add over!");
                continue;
            }
            this.targetTree.insertNodeInto((MutableTreeNode)newAddNode, (MutableTreeNode)curNode, 0);
            alreayMap.put(readyInsertNode.getId(), newAddNode);
        }
        logger.info((Object)"last tree");
    }

    public void copyChildNode(DefaultKingdeeTreeNode sourceNode, DefaultKingdeeTreeNode toNode) {
        Assert.that((sourceNode != null ? 1 : 0) != 0);
        Assert.that((toNode != null ? 1 : 0) != 0);
        if (sourceNode == null || sourceNode.getChildCount() == 0) {
            logger.info((Object)"source or sourceNode child is null");
            return;
        }
        for (int i = sourceNode.getChildCount() - 1; i >= 0; --i) {
            toNode.insert((MutableTreeNode)((DefaultKingdeeTreeNode)sourceNode.getChildAt(i)), 0);
        }
    }

    private Map getCurNodeChildPermItemId(DefaultKingdeeTreeNode rootNode) {
        HashMap<BOSUuid, DefaultKingdeeTreeNode> retSet = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            CoreBaseInfo fullOrgUnitInfo = (CoreBaseInfo)childNode.getUserObject();
            if (fullOrgUnitInfo == null || fullOrgUnitInfo.getId() == null) continue;
            retSet.put(fullOrgUnitInfo.getId(), childNode);
        }
        return retSet;
    }
}

