/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.ToolUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class OrgReturnDataDeal {
    private static Logger logger = Logger.getLogger(OrgReturnDataDeal.class);
    private Set checkedOrgIds;

    public OrgReturnDataDeal(Set checkedOrgIds) {
        this.checkedOrgIds = checkedOrgIds;
    }

    public OrgUnitInfo[] getReturnData(OrgUnitInfo[] values, KDTree tOrgTree) {
        if (tOrgTree == null) {
            return values;
        }
        if (this.checkedOrgIds == null || this.checkedOrgIds.isEmpty()) {
            return values;
        }
        try {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tOrgTree.getModel().getRoot();
            Collection orgNotExistInTreeSet = this.findNotExistTree(this.checkedOrgIds, root);
            logger.info((Object)(" orgNotExistInTreeSet is:" + orgNotExistInTreeSet));
            if (orgNotExistInTreeSet.isEmpty()) {
                return values;
            }
            IFullOrgUnit iFullOrg = FullOrgUnitFactory.getRemoteInstance();
            String oql = " where id in (" + ToolUtils.aryToStr((Collection)orgNotExistInTreeSet, (boolean)true) + ")";
            logger.info((Object)("oql is:" + oql));
            FullOrgUnitCollection fullOrgCol = iFullOrg.getFullOrgUnitCollection(oql);
            for (int i = 0; i < values.length; ++i) {
                fullOrgCol.add(values[i].castToFullOrgUnitInfo());
            }
            OrgUnitInfo[] retRes = new OrgUnitInfo[fullOrgCol.size()];
            for (int i = 0; i < fullOrgCol.size(); ++i) {
                retRes[i] = fullOrgCol.get(i);
            }
            return retRes;
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            return values;
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return values;
        }
    }

    private Collection findNotExistTree(Set checkedOrgIds2, DefaultKingdeeTreeNode root) throws Exception {
        HashSet existOrgIdSet = new HashSet();
        this.traceNode(root, checkedOrgIds2, existOrgIdSet);
        return CollectionUtils.subtract((Collection)checkedOrgIds2, existOrgIdSet);
    }

    private void traceNode(DefaultKingdeeTreeNode root, Set checkedOrgIds2, Set existOrgIdSet) throws Exception {
        FullOrgUnitInfo fullOrgInfo;
        if (root.getUserObject() instanceof FullOrgUnitInfo && checkedOrgIds2.contains((fullOrgInfo = (FullOrgUnitInfo)root.getUserObject()).getId().toString())) {
            existOrgIdSet.add(fullOrgInfo.getId().toString());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, checkedOrgIds2, existOrgIdSet);
        }
    }
}

