/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree.stepadd;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.org.client.tree.stepadd.AbstractKDTreeSExt;
import com.kingdee.eas.basedata.org.client.tree.stepadd.IDataProvider;
import com.kingdee.eas.basedata.org.client.tree.stepadd.IKDTreeStep;
import com.kingdee.eas.basedata.org.client.tree.stepadd.StepAddEvent;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class KDTreeExt
extends AbstractKDTreeSExt
implements IKDTreeStep {
    private static Logger logger = Logger.getLogger(KDTreeExt.class);
    private KDTree targetTree;

    public KDTreeExt(KDTree targetTree) {
        this.targetTree = targetTree;
    }

    @Override
    public void stepAddData(StepAddEvent stepAddDataEvent) throws Exception {
        if (stepAddDataEvent.getIDataProvider() == null && StringUtils.isEmpty((String)stepAddDataEvent.getDealClassName())) {
            throw new IllegalArgumentException("dealClassName is null");
        }
        CoreBaseInfo tempVo = (CoreBaseInfo)stepAddDataEvent.getCurNode().getUserObject();
        if ("true".equals((String)tempVo.get("treeLoad"))) {
            return;
        }
        IDataProvider dataProvider = stepAddDataEvent.getIDataProvider();
        if (dataProvider == null) {
            dataProvider = this.getProvider(stepAddDataEvent.getDealClassName());
        }
        IObjectCollection dataCol = dataProvider.getData(stepAddDataEvent);
        if (stepAddDataEvent.getCurLevel() == -1) {
            logger.info((Object)"event.level == -1 ,load all tree");
            this.rebuildAllTree(dataCol, dataProvider);
        } else {
            logger.info((Object)("step load data over ,datasize is:" + dataCol.size()));
            this.insertData2Tree(stepAddDataEvent.getCurNode(), dataCol, dataProvider);
        }
        tempVo.put("treeLoad", (Object)"true");
        this.targetTree.repaint();
    }

    private void rebuildAllTree(IObjectCollection dataCol, IDataProvider dataProvider) throws Exception {
        KDTreeNode root = dataProvider.buildAllTree(dataCol);
        ((DefaultTreeModel)this.targetTree.getModel()).setRoot((TreeNode)root);
    }

    private void insertData2Tree(DefaultKingdeeTreeNode defaultKingdeeTreeNode, IObjectCollection dataCol, IDataProvider dataProvider) throws Exception {
        if (dataCol.isEmpty()) {
            logger.info((Object)"no new data to isnert , return");
            return;
        }
        dataProvider.insertNewNode(this.targetTree, (KDTreeNode)defaultKingdeeTreeNode, dataCol);
    }
}

