/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.tree.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForF7;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class OrgTreeUtil {
    private static Logger logger = Logger.getLogger(OrgTreeUtil.class);

    public static void clipTreeByOrgType(DefaultKingdeeTreeNode root, OrgType orgType) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            OrgTreeUtil.clipTreeByOrgType((DefaultKingdeeTreeNode)root.getChildAt(i), orgType);
        }
        Object value = root.getUserObject();
        if (value != null) {
            boolean retain = false;
            if (value instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo fullInfo = (FullOrgUnitInfo)value;
                retain = OrgUtils.isOrgType(fullInfo, orgType);
            }
            if (!retain) {
                OrgF7InnerUtils.disableTreeNode(root);
            }
        }
    }

    public static void filterNodeByUserOrgType(KDTree tOrgTree, OrgTypeForF7 orgTypeForF7) {
        TreeModel treeModel;
        if (!OrgTypeForF7.All.equals((Object)orgTypeForF7) && (treeModel = tOrgTree.getModel()) != null && treeModel.getRoot() != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
            OrgType orgType = NewOrgViewHelper.transform(orgTypeForF7);
            OrgTreeUtil.clipTreeByOrgType(root, orgType);
            OrgF7InnerUtils.clipTreeNodeByColor(root);
            ((DefaultTreeModel)treeModel).setRoot((TreeNode)root);
        }
    }

    public static void orderTreeNode(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode[] treeNodes) {
        String rootLongNumber = (String)((CoreBaseInfo)parentNode.getUserObject()).get("longNumber");
        String longNumber = null;
        HashMap<String, DefaultKingdeeTreeNode> longNumberMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int j = 0; j < treeNodes.length; ++j) {
            String tempLongNumber = (String)((CoreBaseInfo)treeNodes[j].getUserObject()).get("longNumber");
            longNumberMap.put(tempLongNumber, treeNodes[j]);
        }
        for (int i = 0; i < treeNodes.length; ++i) {
            longNumber = (String)((CoreBaseInfo)treeNodes[i].getUserObject()).get("longNumber");
            logger.debug((Object)(" deal this longNumber is:" + longNumber));
            int index = longNumber.lastIndexOf("!");
            if (index < 0) continue;
            String parentLongNumber = longNumber.substring(0, index);
            if (parentLongNumber.equals(rootLongNumber)) {
                parentNode.add((MutableTreeNode)treeNodes[i]);
                logger.debug((Object)("add root sub node ,node is:" + treeNodes[i]));
                continue;
            }
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)longNumberMap.get(parentLongNumber);
            if (tempNode == null) {
                parentNode.add((MutableTreeNode)treeNodes[i]);
                logger.debug((Object)(" add node " + treeNodes[i] + " into parent node is:" + parentNode));
                continue;
            }
            tempNode.add((MutableTreeNode)treeNodes[i]);
            logger.debug((Object)("parent node not foound , add root sub node ,node is:" + treeNodes[i]));
        }
    }

    private static void orderTreeNode(Object[] infos, boolean isStruct, DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode[] treeNodes) {
        OrgTreeUtil.orderTreeNode(parentNode, treeNodes);
    }

    public static void insertNode2Root(DefaultKingdeeTreeNode parentNode, AbstractObjectCollection col, boolean isStruct, StepAddParamInfo stepAddParamInfo) {
        parentNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        if (col.size() == 0) {
            logger.info((Object)" not found data ,return");
            return;
        }
        Object[] infos = new Object[col.size()];
        Object[] treeNodes = null;
        treeNodes = stepAddParamInfo != null && "TREE_TYPE_KDNODE".equals(stepAddParamInfo.getTreeType()) ? new KDTreeNode[col.size()] : new DefaultKingdeeTreeNode[col.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = col.getObject(i);
            treeNodes[i] = stepAddParamInfo != null && "TREE_TYPE_KDNODE".equals(stepAddParamInfo.getTreeType()) ? new KDTreeNode(infos[i]) : new DefaultKingdeeTreeNode(infos[i]);
            treeNodes[i].setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        }
        OrgTreeUtil.orderTreeNode(infos, isStruct, parentNode, treeNodes);
    }
}

