/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.uihelper;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OUEditUI;
import com.kingdee.eas.basedata.org.client.OUEditUIHelper;
import com.kingdee.eas.basedata.org.client.uihelper.IOUEditHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OrgEditPanelInfo;
import com.kingdee.eas.basedata.org.client.uihelper.UIHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OUEditUICenter {
    private static Logger logger = Logger.getLogger((String)OUEditUICenter.class.getName());
    private static List ouEditDealList = new ArrayList();
    private static OUEditUICenter factory = null;
    private static Map helperMap = new HashMap();
    private static List secondOuEditDealList = new ArrayList();
    private static OUEditUICenter secondFactory = null;
    private static Map secondHelperMap = new HashMap();
    private static boolean isUseSecondInstance = false;

    private OUEditUICenter() throws Exception {
        if (ouEditDealList.isEmpty()) {
            Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
            for (OrgTypeInfo orgTypeInfo : col) {
                String clzzName = orgTypeInfo.getUiClassName();
                if (StringUtils.isEmpty((String)clzzName)) {
                    logger.info((Object)("OrgTypeInfo is:" + orgTypeInfo));
                    continue;
                }
                IOUEditHelper oneHelper = this.createInstance(clzzName);
                if (oneHelper == null) continue;
                helperMap.put(orgTypeInfo.getOrgType(), oneHelper);
            }
            ouEditDealList.addAll(helperMap.values());
        }
    }

    public static void setCanUseSecondInstance() {
        isUseSecondInstance = true;
    }

    public static void disableCanUseSecondInstance() {
        isUseSecondInstance = false;
    }

    public IOUEditHelper createInstance(String className) {
        try {
            this.getClass();
            return (IOUEditHelper)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)("error, class is:" + className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("error class is:" + className), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("error class is:" + className), (Throwable)e);
        }
        return null;
    }

    public void initPanelByPermission(OUEditUI ouEditui) throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            this.initPanelByPermission(iOUHelper, ouEditui);
        }
    }

    private void initPanelByPermission(IOUEditHelper iOUHelper, OUEditUI ouEditui) throws Exception {
        boolean flag_Admin = OUEditUIHelper.checkFunctionPermission(iOUHelper.getPanelInfo().getPermItemName());
        iOUHelper.getUserSelectKDCheckBox().setEnabled(flag_Admin);
        if (iOUHelper.getUserSelectKDCheckBox().isSelected()) {
            UIHelper.setPanelEnabled(flag_Admin, (KDPanel)iOUHelper.getPanelInfo().getMyUI());
            if (!flag_Admin) {
                UIHelper.setSubComponentsEnable((Component)iOUHelper.getPanelInfo().getMyUI(), false);
            }
        }
    }

    public void orgUnit_actionPerformed(OUEditUI ouEditui) throws Exception {
    }

    public void orgUnit_itemStateChanged(OUEditUI ouEditui) throws Exception {
    }

    public static OUEditUICenter getInstance() throws Exception {
        if (factory == null) {
            factory = new OUEditUICenter();
        }
        return factory;
    }

    public static OUEditUICenter getNewInstance() throws Exception {
        if (isUseSecondInstance) {
            return OUEditUICenter.getSecondInstance();
        }
        OUEditUICenter.clearCache();
        return OUEditUICenter.getInstance();
    }

    public static OUEditUICenter getSecondInstance() throws Exception {
        OUEditUICenter.saveFirstInstance();
        factory = null;
        helperMap = new HashMap();
        ouEditDealList = new ArrayList();
        factory = new OUEditUICenter();
        return factory;
    }

    public static void saveFirstInstance() {
        secondFactory = factory;
        secondHelperMap = helperMap;
        secondOuEditDealList = ouEditDealList;
    }

    public static void recoverFirstInstance() {
        if (secondFactory != null) {
            factory = secondFactory;
            helperMap = secondHelperMap;
            ouEditDealList = secondOuEditDealList;
        }
    }

    public static IOUEditHelper getInstance(OrgType orgType) {
        if (factory == null) {
            try {
                factory = new OUEditUICenter();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (helperMap.containsKey((Object)orgType)) {
            return (IOUEditHelper)helperMap.get((Object)orgType);
        }
        throw new IllegalArgumentException(" orgType is not support :" + (Object)((Object)orgType));
    }

    public static IOUEditHelper getInstance(KDPanel selectedPanel) {
        Collection valueCol = helperMap.values();
        for (IOUEditHelper iOUEditHelper : valueCol) {
            if (!iOUEditHelper.getPanelInfo().getMyUI().getClass().toString().equals(selectedPanel.getClass().toString())) continue;
            return iOUEditHelper;
        }
        throw new IllegalArgumentException(" selectedPanel is not support :" + selectedPanel);
    }

    public void init(OUEditUI ouEditui) throws Exception {
        int i;
        ouEditDealList.clear();
        Iterator it = helperMap.keySet().iterator();
        HashMap<String, IOUEditHelper> keyMap = new HashMap<String, IOUEditHelper>();
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        while (it.hasNext()) {
            OrgType oneType = (OrgType)((Object)it.next());
            IOUEditHelper oneHelper = (IOUEditHelper)helperMap.get((Object)oneType);
            int index = oneHelper.getPanelInfo().getPanelPriority();
            keyMap.put(index + "", oneHelper);
            keyList.add(new Integer(index));
        }
        Collections.sort(keyList);
        for (i = 0; i < keyList.size(); ++i) {
            ouEditDealList.add(keyMap.get(keyList.get(i).toString()));
        }
        for (i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            iOUHelper.init(ouEditui);
        }
    }

    public void setChkEnableAllComp(boolean eanble) throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            this.setChkEnableAllComp(iOUHelper, eanble);
        }
    }

    private void setChkEnableAllComp(IOUEditHelper iOUHelper, boolean enable) throws Exception {
        iOUHelper.getUserSelectKDCheckBox().setEnabled(enable);
        UIHelper.setAllComponentsEnabled((Component)iOUHelper.getPanelInfo().getMyUI(), enable);
        iOUHelper.setComponentsEnabled(enable);
    }

    public void loadOrgFields(OUEditUI ouEditui) throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            logger.info((Object)(" begin loadOrgFields for :" + iOUHelper.getClass().getName()));
            iOUHelper.loadOrgFields(ouEditui);
        }
    }

    public void storeOrgFields() throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            iOUHelper.storeOrgFields();
        }
    }

    public void verifyInput(OUEditUI ouEditui) throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            iOUHelper.verifyInput(ouEditui);
        }
    }

    public List getNewAddOrgList(FullOrgUnitInfo oldData, OUEditUI ouEditui) throws Exception {
        Iterator it = helperMap.keySet().iterator();
        ArrayList<OrgType> retList = new ArrayList<OrgType>();
        while (it.hasNext()) {
            OrgType curType = (OrgType)((Object)it.next());
            IOUEditHelper iOUHelper = (IOUEditHelper)helperMap.get((Object)curType);
            if (!this.hasNewAdd(iOUHelper, oldData, ouEditui)) continue;
            retList.add(curType);
        }
        return retList;
    }

    private boolean hasNewAdd(IOUEditHelper iOUHelper, FullOrgUnitInfo oldData, OUEditUI ouEditui) throws Exception {
        String orgTypeStr = oldData.getOrgTypeStr();
        if (StringUtils.isEmpty((String)orgTypeStr)) {
            logger.info((Object)" orgTypeStr is null");
            return false;
        }
        boolean oldThisOrgType = OrgTypeHelper.isOrgType(oldData.getOrgTypeStr(), iOUHelper.getPanelInfo().getOrgType());
        return !oldThisOrgType && iOUHelper.getUserSelectKDCheckBox().isSelected();
    }

    public void disableSealUp(OUEditUI ouEditui) throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            this.disableSealUp(iOUHelper, ouEditui);
        }
    }

    private void disableSealUp(IOUEditHelper iOUHelper, OUEditUI ouEditui) throws Exception {
        String orgTypeStr = ouEditui.getOrgTypeHelper().createOrgTypeStrBySet();
        if (!StringUtils.isEmpty((String)orgTypeStr) && OrgTypeHelper.isOrgType(orgTypeStr, iOUHelper.getPanelInfo().getOrgType())) {
            OUPartCoreBaseInfo ouPartCoreInfo = ouEditui.getEditData().getOUPart(iOUHelper.getPanelInfo().getOrgType());
            if (ouPartCoreInfo == null) {
                return;
            }
            boolean sealUp = ouPartCoreInfo.getBoolean("isSealUp");
            if (sealUp) {
                iOUHelper.getUserSelectKDCheckBox().setEnabled(false);
                UIHelper.setSubComponentsEnable((Component)iOUHelper.getPanelInfo().getMyUI(), false);
            }
        }
    }

    public OrgEditPanelInfo getPanelInfo(KDPanel kDTabbedPane1) {
        for (OrgType curType : helperMap.keySet()) {
            IOUEditHelper iOUHelper = (IOUEditHelper)helperMap.get((Object)curType);
            OrgEditPanelInfo retInfo = iOUHelper.getPanelInfo();
            if (retInfo == null || !retInfo.getMyUI().getClass().getName().equals(kDTabbedPane1.getClass().getName())) continue;
            return retInfo;
        }
        return null;
    }

    public void sealUp(OUEditUI ouEditui) throws Exception {
        for (OrgType curType : helperMap.keySet()) {
            IOUEditHelper iOUHelper = (IOUEditHelper)helperMap.get((Object)curType);
            iOUHelper.sealUp(ouEditui);
        }
    }

    public void unSealUp(OUEditUI ouEditui) throws Exception {
        for (OrgType curType : helperMap.keySet()) {
            IOUEditHelper iOUHelper = (IOUEditHelper)helperMap.get((Object)curType);
            iOUHelper.unSealUp(ouEditui);
        }
    }

    public void submit_afterDeal(OUEditUI editUI, FullOrgUnitInfo oldData, String state, KDTree treeMain) throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            iOUHelper.submit_afterDeal(editUI, oldData, state, treeMain);
        }
    }

    public void setChkBox(boolean selected) throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            iOUHelper.getUserSelectKDCheckBox().setSelected(selected);
        }
    }

    public void setChkBoxEnable(boolean enable) throws Exception {
        for (int i = 0; i < ouEditDealList.size(); ++i) {
            IOUEditHelper iOUHelper = (IOUEditHelper)ouEditDealList.get(i);
            iOUHelper.getUserSelectKDCheckBox().setEnabled(enable);
        }
    }

    public static void clearCache() {
        factory = null;
        helperMap.clear();
        ouEditDealList.clear();
        secondFactory = null;
        secondHelperMap.clear();
        secondOuEditDealList.clear();
    }

    public static IObjectValue getOUpartInfo(IOUEditHelper editHelper, boolean curVersion, FullOrgUnitInfo orgUnitInfo, SelectorItemCollection selector) throws Exception {
        OrgEditPanelInfo panelInfo = editHelper.getPanelInfo();
        return UIHelper.getOUpartInfo(curVersion, orgUnitInfo, selector, panelInfo.getOrgType());
    }
}

