/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.uihelper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IOrgVersionMgrFacade;
import com.kingdee.eas.basedata.org.OUPartBaseInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.client.uihelper.IOUEditHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OUEditUICenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgEditPanelInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.util.OrgTypeUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class UIHelper {
    private static Logger logger = Logger.getLogger((String)UIHelper.class.getName());
    public static final String strResource = "com.kingdee.eas.basedata.org.client.OUResource";

    public static void initComboBoxModel(KDComboBox combox, Iterator iter) {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        while (iter.hasNext()) {
            model.addElement(iter.next());
        }
        combox.setModel(model);
    }

    public static void initComboBoxModel(KDComboBox combox, Collection col) {
        UIHelper.initComboBoxModel(combox, col.iterator());
    }

    public static void setSubComponentsEnable(Component parent, boolean b) {
        if (parent instanceof Container) {
            Container c = (Container)parent;
            Component[] children = c.getComponents();
            if (children == null) {
                if (!(parent instanceof JLabel || parent instanceof JPanel || parent instanceof KDTabbedPane)) {
                    parent.setEnabled(b);
                }
                return;
            }
            for (Component child : children) {
                UIHelper.setSubComponentsEnable(child, b);
            }
        }
        if (!(parent instanceof JLabel || parent instanceof JPanel || parent instanceof KDTabbedPane)) {
            parent.setEnabled(b);
        }
    }

    public static void setAllComponentsEnabled(Component comp, boolean enabled) {
        UIHelper.setAComponentEnabled(comp, enabled);
        if (comp instanceof Container) {
            Component[] subcomps = ((Container)comp).getComponents();
            int n = subcomps.length;
            for (int i = 0; i < n; ++i) {
                UIHelper.setAllComponentsEnabled(subcomps[i], enabled);
                if (!(comp instanceof KDScrollBar)) continue;
                comp.setEnabled(true);
            }
        }
    }

    public static void setAComponentEnabled(Component comp, boolean enabled) {
        if (!(comp instanceof JLabel) && !(comp instanceof JPanel)) {
            comp.setEnabled(enabled);
        }
    }

    public static void makeExcluCompsFromAllComponents(Component comp) {
        if (comp instanceof Container) {
            Component[] subcomps = ((Container)comp).getComponents();
            int n = subcomps.length;
            for (int i = 0; i < n; ++i) {
                UIHelper.makeExcluCompsFromAllComponents(subcomps[i]);
            }
        }
    }

    public static void action_remove(Component comp, KDTable oprTable, String pmpt) {
        UIHelper.action_remove(comp, oprTable, pmpt, strResource);
    }

    public static void action_remove(Component comp, KDTable oprTable, String pmpt, String strResource) {
        int rowIndex = oprTable.getSelectManager().getActiveRowIndex();
        if (rowIndex > -1) {
            int choice = MsgBox.showConfirm2((Component)comp, (String)EASResource.getString((String)strResource, (String)pmpt));
            if (MsgBox.isYes((int)choice)) {
                oprTable.removeRow(rowIndex);
            }
        } else {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    public static void orgUnitItemStateChangedExt(KDCheckBox checkBox, OrgTypeHelper orgTypeHelper, OrgEditPanelInfo panelInfo) {
        if (orgTypeHelper == null) {
            logger.info((Object)" orgTypeHelper is not init!");
            return;
        }
        if (checkBox.isSelected()) {
            orgTypeHelper.addOrgType(panelInfo.getOrgType());
        } else {
            orgTypeHelper.removeOrgType(panelInfo.getOrgType());
        }
    }

    public static void setSealDate(KDDatePicker sealDatePicker, boolean isSealedUp) {
        if (isSealedUp) {
            sealDatePicker.setValue((Object)new Date(System.currentTimeMillis()));
        } else {
            sealDatePicker.setValue(null);
        }
        sealDatePicker.setEnabled(false);
    }

    public static void sealUpOrg(OUPartCoreBaseInfo ouPartInfo, IOUEditHelper ouEditHelper, boolean sealUp, KDDatePicker datePicker) {
        if (sealUp) {
            if (ouPartInfo instanceof OUPartBaseInfo) {
                ouPartInfo.put("isSealUp", Boolean.TRUE);
            }
        } else {
            if (ouPartInfo != null) {
                ouPartInfo.setBoolean("isSealUp", false);
            }
            ouEditHelper.getUserSelectKDCheckBox().setEnabled(true);
            ouEditHelper.getUserSelectKDCheckBox().setSelected(false);
            UIHelper.setSubComponentsEnable((Component)ouEditHelper.getPanelInfo().getMyUI(), true);
        }
        UIHelper.setSealDate(datePicker, sealUp);
    }

    public static void setPanelEnabled(boolean flag, KDPanel panel) {
        if (!flag) {
            for (int i = 0; i < panel.getComponentCount(); ++i) {
                panel.getComponent(i).setEnabled(false);
            }
        }
    }

    private static int getTabPanelPriority(KDPanel panel) throws Exception {
        OrgEditPanelInfo panelInfo = OUEditUICenter.getInstance().getPanelInfo(panel);
        if (panelInfo == null) {
            return -1;
        }
        return panelInfo.getPanelPriority();
    }

    private static int getTabInsertIndex(KDTabbedPane kDTabbedPane1, KDPanel toInsert) throws Exception {
        int toInsertPriority = UIHelper.getTabPanelPriority(toInsert);
        int n = kDTabbedPane1.getTabCount();
        for (int i = 0; i < n; ++i) {
            KDPanel current = (KDPanel)kDTabbedPane1.getComponentAt(i);
            if (toInsertPriority >= UIHelper.getTabPanelPriority(current)) continue;
            return i;
        }
        return kDTabbedPane1.getTabCount();
    }

    public static void insertTabeIntoPanel(KDTabbedPane kDTabbedPanel, CoreUI testOrgUI, OrgType orgType) throws Exception {
        int index = UIHelper.getTabInsertIndex(kDTabbedPanel, (KDPanel)testOrgUI);
        kDTabbedPanel.insertTab(orgType.getAlias(), null, (Component)testOrgUI, null, index);
        kDTabbedPanel.setSelectedComponent((Component)testOrgUI);
    }

    public static boolean isBizPropertyExistInCU(FullOrgUnitInfo unitInfo, int orgType) throws BOSException, EASBizException {
        CtrlUnitInfo ctrlInfo;
        if (unitInfo.isIsCU()) {
            return true;
        }
        if (unitInfo.getCU() != null && unitInfo.getCU().getId() != null) {
            ICtrlUnit iCtrl = CtrlUnitFactory.getRemoteInstance();
            ObjectUuidPK ctrlPK = new ObjectUuidPK(unitInfo.getCU().getId());
            ctrlInfo = iCtrl.getCtrlUnitInfo((IObjectPK)ctrlPK);
        } else {
            ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        return OrgTypeUtils.isOrgType((OrgUnitInfo)ctrlInfo, orgType);
    }

    public static IObjectValue getOUpartInfo(boolean curVersion, FullOrgUnitInfo orgUnitInfo, SelectorItemCollection selector, OrgType orgType) throws Exception {
        if (curVersion) {
            return OrgTypeUtils.getPartDetailInfo(orgUnitInfo, orgType, selector);
        }
        IOrgVersionMgrFacade iOrgVersion = OrgVersionMgrFacadeFactory.getRemoteInstance();
        return iOrgVersion.getOUPartVersionInfo(orgType, orgUnitInfo.getVersionNumber(), (IObjectPK)new ObjectStringPK(orgUnitInfo.getId().toString()));
    }
}

