/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.CUBDControlDefaultObjectCollection;
import com.kingdee.eas.basedata.org.CUBDControlDefaultObjectFactory;
import com.kingdee.eas.basedata.org.CUBDControlDefaultObjectInfo;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.ICUBDControlDefaultObject;
import java.util.Locale;

public class CUBDControlUtils {
    public static CUBDControlCollection loadDefaultCUBDControl(Context ctx) throws BOSException {
        ICUBDControlDefaultObject iCUBDDefault = ctx == null ? CUBDControlDefaultObjectFactory.getRemoteInstance() : CUBDControlDefaultObjectFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSorter().add(new SorterItemInfo("defaultIndex"));
        CUBDControlCollection controlCol = CUBDControlUtils.convertDefault(iCUBDDefault.getCUBDControlDefaultObjectCollection(viewInfo));
        return controlCol;
    }

    private static CUBDControlCollection convertDefault(CUBDControlDefaultObjectCollection col) {
        CUBDControlCollection ret = new CUBDControlCollection();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            CUBDControlDefaultObjectInfo oldInfo = col.get(i);
            CUBDControlInfo newInfo = new CUBDControlInfo();
            newInfo.setBDBOSType(oldInfo.getBDBOSType());
            newInfo.setBDName(oldInfo.getBDName(new Locale("L2")), new Locale("L2"));
            newInfo.setBDName(oldInfo.getBDName(new Locale("L3")), new Locale("L3"));
            newInfo.setIsSuperiorViewable(oldInfo.isDefaultSuperiorViewable());
            newInfo.setIsSubordinateAddnewable(oldInfo.isDefaultSubordinateAddnewable());
            newInfo.setIsSubordinateEditable(oldInfo.isDefaultSubordinateEditable());
            newInfo.setIsSubordinateDeletable(oldInfo.isDefaultSubordinateDeletable());
            newInfo.setIsSubordinateUpgradable(oldInfo.isDefaultSubordinateUpgradable());
            newInfo.setIsDispatchChangable(oldInfo.isDefaultDispatchChangable());
            newInfo.setDispatchPattern(oldInfo.getDefaultDispatchPattern());
            newInfo.setIndex(oldInfo.getDefaultIndex());
            ret.add(newInfo);
        }
        return ret;
    }
}

