/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OrgToolUtils {
    private static Logger logger = Logger.getLogger((String)OrgToolUtils.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.basedata.org.OrgBasResource";
    private static final String EXT_RESOURCE = "com.kingdee.eas.basedata.org.OrgExtResource";

    public static BOSUuid readId(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return BOSUuid.read((String)id);
    }

    public static String getResource(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    public static String getExtResource(String key) {
        return EASResource.getString((String)EXT_RESOURCE, (String)key);
    }

    public static boolean isOrgIsLeaf(Context ctx, BOSUuid orgID) throws Exception {
        boolean isLeaf = false;
        IFullOrgUnit iFullOrgUnit = null;
        iFullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)iFullOrgUnit.getValue((IObjectPK)new ObjectUuidPK(orgID));
        if (orgInfo == null) {
            throw new OUException(OUException.ORGNOTEXISTS);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        isLeaf = !iFullOrgUnit.exists(filterInfo);
        return isLeaf;
    }

    public static boolean isOrgIsLeaf(Context ctx, String orgNumber) throws Exception {
        String oql;
        boolean isLeaf = false;
        IFullOrgUnit iFullOrgUnit = null;
        iFullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)iFullOrgUnit.getValue(oql = "select * where number = '" + orgNumber + "'");
        if (orgInfo == null) {
            throw new OUException(OUException.ORGNOTEXISTS);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        isLeaf = !iFullOrgUnit.exists(filterInfo);
        return isLeaf;
    }

    public static void removeCache(int orgTypeValue, boolean isBatchSealUp) {
        if (isBatchSealUp && -1 == orgTypeValue) {
            Collection orgTyepInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
            ArrayList orgBosTypeList = new ArrayList();
            for (OrgTypeInfo orgTypeInfo : orgTyepInfoCol) {
                if (!orgTypeInfo.isBasicOrgType()) continue;
                CacheServiceFactory.getInstance().discardType(orgTypeInfo.getBosType());
            }
        } else {
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgTypeIntValue(orgTypeValue);
            CacheServiceFactory.getInstance().discardType(orgTypeInfo.getBosType());
        }
    }

    public static void trimNameAndNumberSpaceOfObjectInfo(DataBaseInfo info) {
        if (!StringUtils.isEmpty((String)info.getName())) {
            info.setName(info.getName().trim());
        }
        if (!StringUtils.isEmpty((String)info.getNumber())) {
            info.setNumber(info.getNumber().trim());
        }
    }

    public static String[] allInvalidChar() {
        return new String[]{"'", "!", "_", "/"};
    }

    public static String[] allInvalidNumberChar() {
        return new String[]{"'", "!", "_"};
    }

    public static String[] allInvalidNameChar() {
        return new String[]{"'", "!", "_", "\\\\"};
    }

    public static String[] allInvalidChar_l1() {
        return new String[]{"!", "_", "/"};
    }

    public static String[] allInvalidNumberChar_l1() {
        return new String[]{"!", "_"};
    }

    public static String[] allInvalidNameChar_l1() {
        return new String[]{"!", "_", "\\\\"};
    }

    public static String[] allInvalidChar(Context ctx) {
        if (OrgToolUtils.isEn(ctx)) {
            return OrgToolUtils.allInvalidChar_l1();
        }
        return OrgToolUtils.allInvalidChar();
    }

    public static String[] allInvalidNumberChar(Context ctx) {
        if (OrgToolUtils.isEn(ctx)) {
            return OrgToolUtils.allInvalidNumberChar_l1();
        }
        return OrgToolUtils.allInvalidNumberChar();
    }

    public static String[] allInvalidNameChar(Context ctx) {
        if (OrgToolUtils.isEn(ctx)) {
            return OrgToolUtils.allInvalidNameChar_l1();
        }
        return OrgToolUtils.allInvalidNameChar();
    }

    public static boolean isEn(Context ctx) {
        try {
            Locale locale = null;
            locale = ctx == null ? SysContext.getSysContext().getLocale() : ctx.getLocale();
            if (locale == null) {
                return false;
            }
            return LocaleUtils.getLocaleString((Locale)locale).equals("l1");
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }
}

