/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.web.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForOrgSwitchingEnum;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class SwitchOrgTypeService
extends BuffaloService {
    private static final Logger logger = Logger.getLogger(SwitchOrgTypeService.class);

    public boolean getOrgUnitList(String type, boolean isShowSealedUp) {
        if (WebContextUtil.getEasContext((HttpServletRequest)((HttpServletRequest)this.getRequest())) == null) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        HttpSession session = request.getSession(true);
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        FullOrgUnitCollection col = null;
        try {
            if (type != null) {
                col = this.getUserOrgRangeOUsByOrgType(ctx, type, isShowSealedUp);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        session.setAttribute("OrgList", col);
        session.setAttribute("ORGTYPE", (Object)type);
        session.setAttribute("isShowSealedUp", (Object)new Boolean(isShowSealedUp));
        return true;
    }

    private FullOrgUnitCollection getUserOrgRangeOUsByOrgType(Context ctx, String orgSwitchType, boolean isShowSealedUp) throws Exception {
        int i;
        int swithOrgType;
        FullOrgUnitCollection fullCol = null;
        if (fullCol == null) {
            fullCol = this.getUserOrgRangeOUs(ctx, isShowSealedUp);
        }
        if ((swithOrgType = Integer.parseInt(orgSwitchType)) == 0) {
            return fullCol;
        }
        FullOrgUnitCollection fullCol2 = new FullOrgUnitCollection();
        OrgType orgType = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(OrgTypeForOrgSwitchingEnum.getEnum(swithOrgType)).getOrgType();
        FullOrgUnitInfo fullInfo = null;
        int n = fullCol.size();
        for (int i2 = 0; i2 < n; ++i2) {
            fullInfo = fullCol.get(i2);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper(fullInfo);
            if (!orgTypeHelper.isOrgType(orgType)) continue;
            fullCol2.add(fullInfo);
        }
        if (orgType.getValue() == 10) {
            return fullCol2;
        }
        if (fullCol2.size() == 0) {
            return fullCol2;
        }
        StringBuffer selectSql = new StringBuffer().append("SELECT id, longNumber WHERE id IN (");
        int n2 = fullCol2.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            String id = fullCol2.get(i3).getId().toString();
            if (i3 != n2 - 1) {
                selectSql.append("'").append(id).append("', ");
                continue;
            }
            selectSql.append("'").append(id).append("')");
        }
        OrgUnitCollection orgUnitCol = NewOrgViewHelper.getOrgUnitCollection(ctx, orgType, selectSql.toString());
        int n3 = orgUnitCol.size();
        for (int i4 = 0; i4 < n3; ++i4) {
            OrgUnitInfo unitInfo = (OrgUnitInfo)orgUnitCol.getObject(i4);
            BOSUuid id = unitInfo.getId();
            String longNumber = unitInfo.getLongNumber();
            fullCol2.get(id).setLongNumber(longNumber);
        }
        FullOrgUnitInfo[] fullInfos = new FullOrgUnitInfo[fullCol2.size()];
        int n4 = fullCol2.size();
        for (i = 0; i < n4; ++i) {
            fullInfos[i] = fullCol2.get(i);
        }
        for (i = 0; i < fullInfos.length - 1; ++i) {
            for (int j = i + 1; j < fullInfos.length; ++j) {
                if (fullInfos[i].getLongNumber().compareTo(fullInfos[j].getLongNumber()) <= 0) continue;
                FullOrgUnitInfo temp = fullInfos[i];
                fullInfos[i] = fullInfos[j];
                fullInfos[j] = temp;
            }
        }
        fullCol2.clear();
        for (i = 0; i < fullInfos.length; ++i) {
            fullCol2.add(fullInfos[i]);
        }
        return fullCol2;
    }

    private FullOrgUnitCollection getUserOrgRangeOUs(Context ctx, boolean isShowSealedUp) throws Exception {
        FullOrgUnitCollection fullCol = null;
        String userId = ctx.getCaller().toString();
        fullCol = OrgSwitchFacadeFactory.getLocalInstance(ctx).getSimpleOrgRanges((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)));
        FullOrgUnitCollection fullCol2 = new FullOrgUnitCollection();
        FullOrgUnitInfo fullInfo = null;
        int n = fullCol.size();
        for (int i = 0; i < n; ++i) {
            fullInfo = fullCol.get(i);
            OrgTypeHelper orgHelper = new OrgTypeHelper(fullInfo);
            if (orgHelper.containComplexOrgType()) continue;
            if (fullInfo.isIsOUSealUp()) {
                if (!isShowSealedUp) continue;
                fullCol2.add(fullInfo);
                continue;
            }
            fullCol2.add(fullInfo);
        }
        fullCol = fullCol2;
        return fullCol;
    }
}

