/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl;

import com.kingdee.bos.rabbitmq.amqp.AMQP;
import com.kingdee.bos.rabbitmq.amqp.AlreadyClosedException;
import com.kingdee.bos.rabbitmq.amqp.ChannelContinuationTimeoutException;
import com.kingdee.bos.rabbitmq.amqp.Command;
import com.kingdee.bos.rabbitmq.amqp.Method;
import com.kingdee.bos.rabbitmq.amqp.ShutdownSignalException;
import com.kingdee.bos.rabbitmq.amqp.impl.AMQCommand;
import com.kingdee.bos.rabbitmq.amqp.impl.AMQConnection;
import com.kingdee.bos.rabbitmq.amqp.impl.Frame;
import com.kingdee.bos.rabbitmq.amqp.impl.ShutdownNotifierComponent;
import com.kingdee.bos.rabbitmq.utility.BlockingValueOrException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQChannel
extends ShutdownNotifierComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQChannel.class);
    protected static final int NO_RPC_TIMEOUT = 0;
    protected final Object _channelMutex = new Object();
    private final AMQConnection _connection;
    private final int _channelNumber;
    private AMQCommand _command = new AMQCommand();
    private RpcContinuation _activeRpc = null;
    public volatile boolean _blockContent = false;
    protected final int _rpcTimeout;
    private final boolean _checkRpcResponseType;

    public AMQChannel(AMQConnection connection2, int channelNumber) {
        this._connection = connection2;
        this._channelNumber = channelNumber;
        if (connection2.getChannelRpcTimeout() < 0) {
            throw new IllegalArgumentException("Continuation timeout on RPC calls cannot be less than 0");
        }
        this._rpcTimeout = connection2.getChannelRpcTimeout();
        this._checkRpcResponseType = connection2.willCheckRpcResponseType();
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    public void handleFrame(Frame frame) throws IOException {
        AMQCommand command = this._command;
        if (command.handleFrame(frame)) {
            this._command = new AMQCommand();
            this.handleCompleteInboundCommand(command);
        }
    }

    public static IOException wrap(ShutdownSignalException ex) {
        return AMQChannel.wrap(ex, null);
    }

    public static IOException wrap(ShutdownSignalException ex, String message) {
        IOException ioe = new IOException(message);
        ioe.initCause(ex);
        return ioe;
    }

    public AMQCommand exnWrappingRpc(Method m) throws IOException {
        try {
            return this.privateRpc(m);
        }
        catch (AlreadyClosedException ace) {
            throw ace;
        }
        catch (ShutdownSignalException ex) {
            throw AMQChannel.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCompleteInboundCommand(AMQCommand command) throws IOException {
        if (!this.processAsync(command)) {
            RpcContinuation nextOutstandingRpc;
            if (this._checkRpcResponseType) {
                Object object = this._channelMutex;
                synchronized (object) {
                    if (this._activeRpc != null && !this._activeRpc.canHandleReply(command)) {
                        return;
                    }
                }
            }
            if ((nextOutstandingRpc = this.nextOutstandingRpc()) != null) {
                nextOutstandingRpc.handleCommand(command);
                this.markRpcFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueRpc(RpcContinuation k) {
        Object object = this._channelMutex;
        synchronized (object) {
            boolean waitClearedInterruptStatus = false;
            while (this._activeRpc != null) {
                try {
                    this._channelMutex.wait();
                }
                catch (InterruptedException e) {
                    waitClearedInterruptStatus = true;
                }
            }
            if (waitClearedInterruptStatus) {
                Thread.currentThread().interrupt();
            }
            this._activeRpc = k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            return this._activeRpc != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcContinuation nextOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            RpcContinuation result = this._activeRpc;
            this._activeRpc = null;
            this._channelMutex.notifyAll();
            return result;
        }
    }

    protected void markRpcFinished() {
    }

    public void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException(this.getCloseReason());
        }
    }

    public AMQCommand rpc(Method m) throws IOException, ShutdownSignalException {
        return this.privateRpc(m);
    }

    public AMQCommand rpc(Method m, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        return this.privateRpc(m, timeout);
    }

    private AMQCommand privateRpc(Method m) throws IOException, ShutdownSignalException {
        SimpleBlockingRpcContinuation k = new SimpleBlockingRpcContinuation(m);
        this.rpc(m, k);
        if (this._rpcTimeout == 0) {
            return (AMQCommand)k.getReply();
        }
        try {
            return (AMQCommand)k.getReply(this._rpcTimeout);
        }
        catch (TimeoutException e) {
            throw this.wrapTimeoutException(m, e);
        }
    }

    private void cleanRpcChannelState() {
        try {
            this.nextOutstandingRpc();
            this.markRpcFinished();
        }
        catch (Exception ex) {
            LOGGER.warn("Error while cleaning timed out channel RPC: {}", (Object)ex.getMessage());
        }
    }

    protected ChannelContinuationTimeoutException wrapTimeoutException(Method m, TimeoutException e) {
        this.cleanRpcChannelState();
        return new ChannelContinuationTimeoutException(e, this, this._channelNumber, m);
    }

    private AMQCommand privateRpc(Method m, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        SimpleBlockingRpcContinuation k = new SimpleBlockingRpcContinuation(m);
        this.rpc(m, k);
        try {
            return (AMQCommand)k.getReply(timeout);
        }
        catch (TimeoutException e) {
            this.cleanRpcChannelState();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rpc(Method m, RpcContinuation k) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingRpc(m, k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingRpc(Method m, RpcContinuation k) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.enqueueRpc(k);
            this.quiescingTransmit(m);
        }
    }

    public abstract boolean processAsync(Command var1) throws IOException;

    public String toString() {
        return "AMQChannel(" + this._connection + "," + this._channelNumber + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processShutdownSignal(ShutdownSignalException signal, boolean ignoreClosed, boolean notifyRpc) {
        try {
            Object object = this._channelMutex;
            synchronized (object) {
                if (!this.setShutdownCauseIfOpen(signal) && !ignoreClosed) {
                    throw new AlreadyClosedException(this.getCloseReason());
                }
                this._channelMutex.notifyAll();
            }
        }
        finally {
            if (notifyRpc) {
                this.notifyOutstandingRpc(signal);
            }
        }
    }

    public void notifyOutstandingRpc(ShutdownSignalException signal) {
        RpcContinuation k = this.nextOutstandingRpc();
        if (k != null) {
            k.handleShutdownSignal(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(Method m) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.transmit(new AMQCommand(m));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(AMQCommand c) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingTransmit(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingTransmit(Method m) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.quiescingTransmit(new AMQCommand(m));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingTransmit(AMQCommand c) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            if (c.getMethod().hasContent()) {
                while (this._blockContent) {
                    try {
                        this._channelMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.ensureIsOpen();
                }
            }
            c.transmit(this);
        }
    }

    public AMQConnection getConnection() {
        return this._connection;
    }

    public static class SimpleBlockingRpcContinuation
    extends BlockingRpcContinuation<AMQCommand> {
        public SimpleBlockingRpcContinuation() {
        }

        public SimpleBlockingRpcContinuation(Method method) {
            super(method);
        }

        @Override
        public AMQCommand transformReply(AMQCommand command) {
            return command;
        }
    }

    public static abstract class BlockingRpcContinuation<T>
    implements RpcContinuation {
        public final BlockingValueOrException<T, ShutdownSignalException> _blocker = new BlockingValueOrException();
        protected final Method request;

        public BlockingRpcContinuation() {
            this.request = null;
        }

        public BlockingRpcContinuation(Method request) {
            this.request = request;
        }

        @Override
        public void handleCommand(AMQCommand command) {
            this._blocker.setValue(this.transformReply(command));
        }

        @Override
        public void handleShutdownSignal(ShutdownSignalException signal) {
            this._blocker.setException(signal);
        }

        public T getReply() throws ShutdownSignalException {
            return this._blocker.uninterruptibleGetValue();
        }

        public T getReply(int timeout) throws ShutdownSignalException, TimeoutException {
            return this._blocker.uninterruptibleGetValue(timeout);
        }

        @Override
        public boolean canHandleReply(AMQCommand command) {
            if (this.request != null) {
                com.kingdee.bos.rabbitmq.amqp.impl.Method reply = command.getMethod();
                if (this.request instanceof AMQP.Basic.Qos) {
                    return reply instanceof AMQP.Basic.QosOk;
                }
                if (this.request instanceof AMQP.Basic.Get) {
                    return reply instanceof AMQP.Basic.GetOk || reply instanceof AMQP.Basic.GetEmpty;
                }
                if (this.request instanceof AMQP.Basic.Consume) {
                    if (!(reply instanceof AMQP.Basic.ConsumeOk)) {
                        return false;
                    }
                    String consumerTag = ((AMQP.Basic.Consume)this.request).getConsumerTag();
                    return consumerTag == null || consumerTag.equals("") || consumerTag.equals(((AMQP.Basic.ConsumeOk)((Object)reply)).getConsumerTag());
                }
                if (this.request instanceof AMQP.Basic.Cancel) {
                    if (!(reply instanceof AMQP.Basic.CancelOk)) {
                        return false;
                    }
                    return ((AMQP.Basic.Cancel)this.request).getConsumerTag().equals(((AMQP.Basic.CancelOk)((Object)reply)).getConsumerTag());
                }
                if (this.request instanceof AMQP.Basic.Recover) {
                    return reply instanceof AMQP.Basic.RecoverOk;
                }
                if (this.request instanceof AMQP.Exchange.Declare) {
                    return reply instanceof AMQP.Exchange.DeclareOk;
                }
                if (this.request instanceof AMQP.Exchange.Delete) {
                    return reply instanceof AMQP.Exchange.DeleteOk;
                }
                if (this.request instanceof AMQP.Exchange.Bind) {
                    return reply instanceof AMQP.Exchange.BindOk;
                }
                if (this.request instanceof AMQP.Exchange.Unbind) {
                    return reply instanceof AMQP.Exchange.UnbindOk;
                }
                if (this.request instanceof AMQP.Queue.Declare) {
                    return reply instanceof AMQP.Queue.DeclareOk;
                }
                if (this.request instanceof AMQP.Queue.Delete) {
                    return reply instanceof AMQP.Queue.DeleteOk;
                }
                if (this.request instanceof AMQP.Queue.Bind) {
                    return reply instanceof AMQP.Queue.BindOk;
                }
                if (this.request instanceof AMQP.Queue.Unbind) {
                    return reply instanceof AMQP.Queue.UnbindOk;
                }
                if (this.request instanceof AMQP.Queue.Purge) {
                    return reply instanceof AMQP.Queue.PurgeOk;
                }
                if (this.request instanceof AMQP.Tx.Select) {
                    return reply instanceof AMQP.Tx.SelectOk;
                }
                if (this.request instanceof AMQP.Tx.Commit) {
                    return reply instanceof AMQP.Tx.CommitOk;
                }
                if (this.request instanceof AMQP.Tx.Rollback) {
                    return reply instanceof AMQP.Tx.RollbackOk;
                }
                if (this.request instanceof AMQP.Confirm.Select) {
                    return reply instanceof AMQP.Confirm.SelectOk;
                }
            }
            return true;
        }

        public abstract T transformReply(AMQCommand var1);
    }

    public static interface RpcContinuation {
        public void handleCommand(AMQCommand var1);

        public boolean canHandleReply(AMQCommand var1);

        public void handleShutdownSignal(ShutdownSignalException var1);
    }
}

