/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl;

import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.Connection;
import com.kingdee.bos.rabbitmq.amqp.MetricsCollector;
import com.kingdee.bos.rabbitmq.amqp.ShutdownListener;
import com.kingdee.bos.rabbitmq.amqp.ShutdownSignalException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricsCollector
implements MetricsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetricsCollector.class);
    private final ConcurrentMap<String, ConnectionState> connectionState = new ConcurrentHashMap<String, ConnectionState>();
    private final Runnable markAcknowledgedMessageAction = new Runnable(){

        @Override
        public void run() {
            AbstractMetricsCollector.this.markAcknowledgedMessage();
        }
    };
    private final Runnable markRejectedMessageAction = new Runnable(){

        @Override
        public void run() {
            AbstractMetricsCollector.this.markRejectedMessage();
        }
    };

    @Override
    public void newConnection(final Connection connection2) {
        try {
            if (connection2.getId() == null) {
                connection2.setId(UUID.randomUUID().toString());
            }
            this.incrementConnectionCount(connection2);
            this.connectionState.put(connection2.getId(), new ConnectionState(connection2));
            connection2.addShutdownListener(new ShutdownListener(){

                @Override
                public void shutdownCompleted(ShutdownSignalException cause) {
                    AbstractMetricsCollector.this.closeConnection(connection2);
                }
            });
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in newConnection: " + e.getMessage());
        }
    }

    @Override
    public void closeConnection(Connection connection2) {
        try {
            ConnectionState removed = (ConnectionState)this.connectionState.remove(connection2.getId());
            if (removed != null) {
                this.decrementConnectionCount(connection2);
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in closeConnection: " + e.getMessage());
        }
    }

    @Override
    public void newChannel(final Channel channel) {
        try {
            this.incrementChannelCount(channel);
            channel.addShutdownListener(new ShutdownListener(){

                @Override
                public void shutdownCompleted(ShutdownSignalException cause) {
                    AbstractMetricsCollector.this.closeChannel(channel);
                }
            });
            this.connectionState((Connection)channel.getConnection()).channelState.put(channel.getChannelNumber(), new ChannelState(channel));
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in newChannel: " + e.getMessage());
        }
    }

    @Override
    public void closeChannel(Channel channel) {
        try {
            ChannelState removed = (ChannelState)this.connectionState((Connection)channel.getConnection()).channelState.remove(channel.getChannelNumber());
            if (removed != null) {
                this.decrementChannelCount(channel);
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in closeChannel: " + e.getMessage());
        }
    }

    @Override
    public void basicPublish(Channel channel) {
        try {
            this.markPublishedMessage();
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicPublish: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicConsume(Channel channel, String consumerTag, boolean autoAck) {
        block5: {
            try {
                if (autoAck) break block5;
                ChannelState channelState = this.channelState(channel);
                channelState.lock.lock();
                try {
                    this.channelState((Channel)channel).consumersWithManualAck.add(consumerTag);
                }
                finally {
                    channelState.lock.unlock();
                }
            }
            catch (Exception e) {
                LOGGER.info("Error while computing metrics in basicConsume: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicCancel(Channel channel, String consumerTag) {
        try {
            ChannelState channelState = this.channelState(channel);
            channelState.lock.lock();
            try {
                this.channelState((Channel)channel).consumersWithManualAck.remove(consumerTag);
            }
            finally {
                channelState.lock.unlock();
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicCancel: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumedMessage(Channel channel, long deliveryTag, boolean autoAck) {
        block5: {
            try {
                this.markConsumedMessage();
                if (autoAck) break block5;
                ChannelState channelState = this.channelState(channel);
                channelState.lock.lock();
                try {
                    this.channelState((Channel)channel).unackedMessageDeliveryTags.add(deliveryTag);
                }
                finally {
                    channelState.lock.unlock();
                }
            }
            catch (Exception e) {
                LOGGER.info("Error while computing metrics in consumedMessage: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumedMessage(Channel channel, long deliveryTag, String consumerTag) {
        try {
            this.markConsumedMessage();
            ChannelState channelState = this.channelState(channel);
            channelState.lock.lock();
            try {
                if (channelState.consumersWithManualAck.contains(consumerTag)) {
                    channelState.unackedMessageDeliveryTags.add(deliveryTag);
                }
            }
            finally {
                channelState.lock.unlock();
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in consumedMessage: " + e.getMessage());
        }
    }

    @Override
    public void basicAck(Channel channel, long deliveryTag, boolean multiple) {
        try {
            this.updateChannelStateAfterAckReject(channel, deliveryTag, multiple, this.markAcknowledgedMessageAction);
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicAck: " + e.getMessage());
        }
    }

    @Override
    public void basicNack(Channel channel, long deliveryTag) {
        try {
            this.updateChannelStateAfterAckReject(channel, deliveryTag, true, this.markRejectedMessageAction);
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicNack: " + e.getMessage());
        }
    }

    @Override
    public void basicReject(Channel channel, long deliveryTag) {
        try {
            this.updateChannelStateAfterAckReject(channel, deliveryTag, false, this.markRejectedMessageAction);
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicReject: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChannelStateAfterAckReject(Channel channel, long deliveryTag, boolean multiple, Runnable action) {
        ChannelState channelState = this.channelState(channel);
        channelState.lock.lock();
        try {
            if (multiple) {
                Iterator<Long> iterator = channelState.unackedMessageDeliveryTags.iterator();
                while (iterator.hasNext()) {
                    long messageDeliveryTag = iterator.next();
                    if (messageDeliveryTag > deliveryTag) continue;
                    iterator.remove();
                    action.run();
                }
            } else if (channelState.unackedMessageDeliveryTags.remove(deliveryTag)) {
                action.run();
            }
        }
        finally {
            channelState.lock.unlock();
        }
    }

    private ConnectionState connectionState(Connection connection2) {
        return (ConnectionState)this.connectionState.get(connection2.getId());
    }

    private ChannelState channelState(Channel channel) {
        return (ChannelState)this.connectionState((Connection)channel.getConnection()).channelState.get(channel.getChannelNumber());
    }

    public void cleanStaleState() {
        try {
            Iterator connectionStateIterator = this.connectionState.entrySet().iterator();
            while (connectionStateIterator.hasNext()) {
                Map.Entry connectionEntry = connectionStateIterator.next();
                Connection connection2 = ((ConnectionState)connectionEntry.getValue()).connection;
                if (connection2.isOpen()) {
                    Iterator channelStateIterator = ((ConnectionState)connectionEntry.getValue()).channelState.entrySet().iterator();
                    while (channelStateIterator.hasNext()) {
                        Map.Entry channelStateEntry = channelStateIterator.next();
                        Channel channel = ((ChannelState)channelStateEntry.getValue()).channel;
                        if (channel.isOpen()) continue;
                        channelStateIterator.remove();
                        this.decrementChannelCount(channel);
                        LOGGER.info("Ripped off state of channel {} of connection {}. This is abnormal, please report.", (Object)channel.getChannelNumber(), (Object)connection2.getId());
                    }
                    continue;
                }
                connectionStateIterator.remove();
                this.decrementConnectionCount(connection2);
                for (int i = 0; i < ((ConnectionState)connectionEntry.getValue()).channelState.size(); ++i) {
                    this.decrementChannelCount(null);
                }
                LOGGER.info("Ripped off state of connection {}. This is abnormal, please report.", (Object)connection2.getId());
            }
        }
        catch (Exception e) {
            LOGGER.info("Error during periodic clean of metricsCollector: " + e.getMessage());
        }
    }

    protected abstract void incrementConnectionCount(Connection var1);

    protected abstract void decrementConnectionCount(Connection var1);

    protected abstract void incrementChannelCount(Channel var1);

    protected abstract void decrementChannelCount(Channel var1);

    protected abstract void markPublishedMessage();

    protected abstract void markConsumedMessage();

    protected abstract void markAcknowledgedMessage();

    protected abstract void markRejectedMessage();

    private static class ChannelState {
        final Lock lock = new ReentrantLock();
        final Set<Long> unackedMessageDeliveryTags = new HashSet<Long>();
        final Set<String> consumersWithManualAck = new HashSet<String>();
        final Channel channel;

        private ChannelState(Channel channel) {
            this.channel = channel;
        }
    }

    private static class ConnectionState {
        final ConcurrentMap<Integer, ChannelState> channelState = new ConcurrentHashMap<Integer, ChannelState>();
        final Connection connection;

        private ConnectionState(Connection connection2) {
            this.connection = connection2;
        }
    }
}

