/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl;

import com.kingdee.bos.rabbitmq.amqp.AlreadyClosedException;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.Connection;
import com.kingdee.bos.rabbitmq.amqp.Consumer;
import com.kingdee.bos.rabbitmq.amqp.ExceptionHandler;
import com.kingdee.bos.rabbitmq.amqp.TopologyRecoveryException;
import java.io.IOException;
import java.net.ConnectException;
import org.slf4j.LoggerFactory;

public class ForgivingExceptionHandler
implements ExceptionHandler {
    @Override
    public void handleUnexpectedConnectionDriverException(Connection conn, Throwable exception) {
        this.log("An unexpected connection driver error occured", exception);
    }

    @Override
    public void handleReturnListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ReturnListener.handleReturn");
    }

    @Override
    public void handleFlowListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "FlowListener.handleFlow");
    }

    @Override
    public void handleConfirmListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ConfirmListener.handle{N,A}ck");
    }

    @Override
    public void handleBlockedListenerException(Connection connection2, Throwable exception) {
        this.handleConnectionKiller(connection2, exception, "BlockedListener");
    }

    @Override
    public void handleConsumerException(Channel channel, Throwable exception, Consumer consumer, String consumerTag, String methodName) {
        this.handleChannelKiller(channel, exception, "Consumer " + consumer + " (" + consumerTag + ") method " + methodName + " for channel " + channel);
    }

    @Override
    public void handleConnectionRecoveryException(Connection conn, Throwable exception) {
        if (!(exception instanceof ConnectException)) {
            this.log("Caught an exception during connection recovery!", exception);
        }
    }

    @Override
    public void handleChannelRecoveryException(Channel ch, Throwable exception) {
        this.log("Caught an exception when recovering channel " + ch.getChannelNumber(), exception);
    }

    @Override
    public void handleTopologyRecoveryException(Connection conn, Channel ch, TopologyRecoveryException exception) {
        this.log("Caught an exception when recovering topology " + exception.getMessage(), exception);
    }

    protected void handleChannelKiller(Channel channel, Throwable exception, String what) {
        this.log(what + "threw an exception for channel " + channel, exception);
    }

    protected void handleConnectionKiller(Connection connection2, Throwable exception, String what) {
        this.log(what + " threw an exception for connection " + connection2, exception);
        try {
            connection2.close(200, "Closed due to exception from " + what);
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        catch (IOException ioe) {
            this.log("Failure during close of connection " + connection2 + " after " + exception, ioe);
            connection2.abort(541, "Internal error closing connection for " + what);
        }
    }

    protected void log(String message, Throwable e) {
        if (ForgivingExceptionHandler.isSocketClosedOrConnectionReset(e)) {
            LoggerFactory.getLogger(ForgivingExceptionHandler.class).warn(message + " (Exception message: " + e.getMessage() + ")");
        } else {
            LoggerFactory.getLogger(ForgivingExceptionHandler.class).error(message, e);
        }
    }

    private static boolean isSocketClosedOrConnectionReset(Throwable e) {
        return e instanceof IOException && ("Connection reset".equals(e.getMessage()) || "Socket closed".equals(e.getMessage()) || "Connection reset by peer".equals(e.getMessage()));
    }
}

