/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl;

import com.kingdee.bos.rabbitmq.amqp.impl.SetQueue;
import com.kingdee.bos.rabbitmq.amqp.impl.VariableLinkedBlockingQueue;
import com.kingdee.bos.rabbitmq.amqp.impl.WorkPoolFullException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class WorkPool<K, W> {
    private static final int MAX_QUEUE_LENGTH = 1000;
    private final SetQueue<K> ready = new SetQueue();
    private final Set<K> inProgress = new HashSet<K>();
    private final Map<K, VariableLinkedBlockingQueue<W>> pool = new HashMap<K, VariableLinkedBlockingQueue<W>>();
    private final Set<K> unlimited = new HashSet<K>();
    private final EnqueueingCallback<W> enqueueingCallback;

    public WorkPool(final int queueingTimeout) {
        this.enqueueingCallback = queueingTimeout > 0 ? new EnqueueingCallback<W>(){

            @Override
            public void enqueue(BlockingQueue<W> queue, W item) {
                try {
                    boolean offered = queue.offer(item, queueingTimeout, TimeUnit.MILLISECONDS);
                    if (!offered) {
                        throw new WorkPoolFullException("Could not enqueue in work pool after " + queueingTimeout + " ms.");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread();
                }
            }
        } : new EnqueueingCallback<W>(){

            @Override
            public void enqueue(BlockingQueue<W> queue, W item) {
                try {
                    queue.put(item);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerKey(K key) {
        WorkPool workPool = this;
        synchronized (workPool) {
            if (!this.pool.containsKey(key)) {
                int initialCapacity = this.unlimited.isEmpty() ? 1000 : Integer.MAX_VALUE;
                this.pool.put(key, new VariableLinkedBlockingQueue(initialCapacity));
            }
        }
    }

    public synchronized void limit(K key) {
        this.unlimited.remove(key);
        if (this.unlimited.isEmpty()) {
            this.setCapacities(1000);
        }
    }

    public synchronized void unlimit(K key) {
        this.unlimited.add(key);
        if (!this.unlimited.isEmpty()) {
            this.setCapacities(Integer.MAX_VALUE);
        }
    }

    private void setCapacities(int capacity) {
        Iterator<VariableLinkedBlockingQueue<W>> it = this.pool.values().iterator();
        while (it.hasNext()) {
            it.next().setCapacity(capacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterKey(K key) {
        WorkPool workPool = this;
        synchronized (workPool) {
            this.pool.remove(key);
            this.ready.remove(key);
            this.inProgress.remove(key);
            this.unlimited.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllKeys() {
        WorkPool workPool = this;
        synchronized (workPool) {
            this.pool.clear();
            this.ready.clear();
            this.inProgress.clear();
            this.unlimited.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K nextWorkBlock(Collection<W> to, int size) {
        WorkPool workPool = this;
        synchronized (workPool) {
            K nextKey = this.readyToInProgress();
            if (nextKey != null) {
                VariableLinkedBlockingQueue<W> queue = this.pool.get(nextKey);
                this.drainTo(queue, to, size);
            }
            return nextKey;
        }
    }

    private int drainTo(VariableLinkedBlockingQueue<W> deList, Collection<W> c, int maxElements) {
        W first;
        int n;
        for (n = 0; n < maxElements && (first = deList.poll()) != null; ++n) {
            c.add(first);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWorkItem(K key, W item) {
        VariableLinkedBlockingQueue<W> queue;
        WorkPool workPool = this;
        synchronized (workPool) {
            queue = this.pool.get(key);
        }
        if (queue != null) {
            this.enqueueingCallback.enqueue(queue, item);
            workPool = this;
            synchronized (workPool) {
                if (this.isDormant(key)) {
                    this.dormantToReady(key);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWorkBlock(K key) {
        WorkPool workPool = this;
        synchronized (workPool) {
            if (!this.isRegistered(key)) {
                return false;
            }
            if (!this.inProgress.contains(key)) {
                throw new IllegalStateException("Client " + key + " not in progress");
            }
            if (this.moreWorkItems(key)) {
                this.inProgressToReady(key);
                return true;
            }
            this.inProgressToDormant(key);
            return false;
        }
    }

    private boolean moreWorkItems(K key) {
        VariableLinkedBlockingQueue<W> leList = this.pool.get(key);
        return leList != null && !leList.isEmpty();
    }

    private boolean isInProgress(K key) {
        return this.inProgress.contains(key);
    }

    private boolean isReady(K key) {
        return this.ready.contains(key);
    }

    private boolean isRegistered(K key) {
        return this.pool.containsKey(key);
    }

    private boolean isDormant(K key) {
        return !this.isInProgress(key) && !this.isReady(key) && this.isRegistered(key);
    }

    private void inProgressToReady(K key) {
        this.inProgress.remove(key);
        this.ready.addIfNotPresent(key);
    }

    private void inProgressToDormant(K key) {
        this.inProgress.remove(key);
    }

    private void dormantToReady(K key) {
        this.ready.addIfNotPresent(key);
    }

    private K readyToInProgress() {
        K key = this.ready.poll();
        if (key != null) {
            this.inProgress.add(key);
        }
        return key;
    }

    private static interface EnqueueingCallback<W> {
        public void enqueue(BlockingQueue<W> var1, W var2);
    }
}

