/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ByteBufferOutputStream
extends OutputStream {
    private final WritableByteChannel channel;
    private final ByteBuffer buffer;

    public ByteBufferOutputStream(WritableByteChannel channel, ByteBuffer buffer) {
        this.buffer = buffer;
        this.channel = channel;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            ByteBufferOutputStream.drain(this.channel, this.buffer);
        }
        this.buffer.put((byte)b);
    }

    @Override
    public void flush() throws IOException {
        ByteBufferOutputStream.drain(this.channel, this.buffer);
    }

    public static void drain(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        buffer.flip();
        while (buffer.hasRemaining() && channel.write(buffer) != -1) {
        }
        buffer.clear();
    }
}

