/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl.recovery;

import com.kingdee.bos.rabbitmq.amqp.AMQP;
import com.kingdee.bos.rabbitmq.amqp.Address;
import com.kingdee.bos.rabbitmq.amqp.AddressResolver;
import com.kingdee.bos.rabbitmq.amqp.BlockedListener;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.Connection;
import com.kingdee.bos.rabbitmq.amqp.ExceptionHandler;
import com.kingdee.bos.rabbitmq.amqp.ListAddressResolver;
import com.kingdee.bos.rabbitmq.amqp.MetricsCollector;
import com.kingdee.bos.rabbitmq.amqp.MissedHeartbeatException;
import com.kingdee.bos.rabbitmq.amqp.NoOpMetricsCollector;
import com.kingdee.bos.rabbitmq.amqp.RecoverableConnection;
import com.kingdee.bos.rabbitmq.amqp.RecoveryListener;
import com.kingdee.bos.rabbitmq.amqp.ShutdownListener;
import com.kingdee.bos.rabbitmq.amqp.ShutdownSignalException;
import com.kingdee.bos.rabbitmq.amqp.TopologyRecoveryException;
import com.kingdee.bos.rabbitmq.amqp.impl.AMQConnection;
import com.kingdee.bos.rabbitmq.amqp.impl.ConnectionParams;
import com.kingdee.bos.rabbitmq.amqp.impl.ErrorOnWriteListener;
import com.kingdee.bos.rabbitmq.amqp.impl.FrameHandlerFactory;
import com.kingdee.bos.rabbitmq.amqp.impl.NetworkConnection;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.AutorecoveringChannel;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.ConsumerRecoveryListener;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.QueueRecoveryListener;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecordedBinding;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecordedConsumer;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecordedExchange;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecordedExchangeBinding;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecordedQueue;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecordedQueueBinding;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecoveryAwareAMQConnection;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecoveryAwareAMQConnectionFactory;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecoveryAwareChannelN;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecoveryCanBeginListener;
import com.kingdee.bos.rabbitmq.utility.Utility;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutorecoveringConnection
implements RecoverableConnection,
NetworkConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutorecoveringConnection.class);
    private final RecoveryAwareAMQConnectionFactory cf;
    private final Map<Integer, AutorecoveringChannel> channels;
    private final ConnectionParams params;
    private volatile RecoveryAwareAMQConnection delegate;
    private final List<ShutdownListener> shutdownHooks = Collections.synchronizedList(new ArrayList());
    private final List<RecoveryListener> recoveryListeners = Collections.synchronizedList(new ArrayList());
    private final List<BlockedListener> blockedListeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, RecordedQueue> recordedQueues = Collections.synchronizedMap(new LinkedHashMap());
    private final List<RecordedBinding> recordedBindings = Collections.synchronizedList(new ArrayList());
    private final Map<String, RecordedExchange> recordedExchanges = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, RecordedConsumer> consumers = Collections.synchronizedMap(new LinkedHashMap());
    private final List<ConsumerRecoveryListener> consumerRecoveryListeners = Collections.synchronizedList(new ArrayList());
    private final List<QueueRecoveryListener> queueRecoveryListeners = Collections.synchronizedList(new ArrayList());
    private volatile boolean manuallyClosed = false;
    private final Object recoveryLock = new Object();

    public AutorecoveringConnection(ConnectionParams params, FrameHandlerFactory f, List<Address> addrs) {
        this(params, f, new ListAddressResolver(addrs));
    }

    public AutorecoveringConnection(ConnectionParams params, FrameHandlerFactory f, AddressResolver addressResolver) {
        this(params, f, addressResolver, new NoOpMetricsCollector());
    }

    public AutorecoveringConnection(ConnectionParams params, FrameHandlerFactory f, AddressResolver addressResolver, MetricsCollector metricsCollector) {
        this.cf = new RecoveryAwareAMQConnectionFactory(params, f, addressResolver, metricsCollector);
        this.params = params;
        this.setupErrorOnWriteListenerForPotentialRecovery();
        this.channels = new ConcurrentHashMap<Integer, AutorecoveringChannel>();
    }

    private void setupErrorOnWriteListenerForPotentialRecovery() {
        final ThreadFactory threadFactory = this.params.getThreadFactory();
        final ReentrantLock errorOnWriteLock = new ReentrantLock();
        this.params.setErrorOnWriteListener(new ErrorOnWriteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(final Connection connection2, final IOException exception) throws IOException {
                if (errorOnWriteLock.tryLock()) {
                    try {
                        Thread recoveryThread = threadFactory.newThread(new Runnable(){

                            @Override
                            public void run() {
                                AMQConnection c = (AMQConnection)connection2;
                                c.handleIoError(exception);
                            }
                        });
                        recoveryThread.setName("RabbitMQ Error On Write Thread");
                        recoveryThread.start();
                    }
                    finally {
                        errorOnWriteLock.unlock();
                    }
                }
                throw exception;
            }
        });
    }

    public void init() throws IOException, TimeoutException {
        this.delegate = this.cf.newConnection();
        this.addAutomaticRecoveryListener(this.delegate);
    }

    @Override
    public Channel createChannel() throws IOException {
        RecoveryAwareChannelN ch = (RecoveryAwareChannelN)this.delegate.createChannel();
        if (ch == null) {
            return null;
        }
        return this.wrapChannel(ch);
    }

    @Override
    public Channel createChannel(int channelNumber) throws IOException {
        return this.delegate.createChannel(channelNumber);
    }

    private Channel wrapChannel(RecoveryAwareChannelN delegateChannel) {
        if (delegateChannel == null) {
            return null;
        }
        AutorecoveringChannel channel = new AutorecoveringChannel(this, delegateChannel);
        this.registerChannel(channel);
        return channel;
    }

    void registerChannel(AutorecoveringChannel channel) {
        this.channels.put(channel.getChannelNumber(), channel);
    }

    void unregisterChannel(AutorecoveringChannel channel) {
        this.channels.remove(channel.getChannelNumber());
    }

    @Override
    public Map<String, Object> getServerProperties() {
        return this.delegate.getServerProperties();
    }

    @Override
    public Map<String, Object> getClientProperties() {
        return this.delegate.getClientProperties();
    }

    @Override
    public String getClientProvidedName() {
        return this.delegate.getClientProvidedName();
    }

    @Override
    public int getFrameMax() {
        return this.delegate.getFrameMax();
    }

    @Override
    public int getHeartbeat() {
        return this.delegate.getHeartbeat();
    }

    @Override
    public int getChannelMax() {
        return this.delegate.getChannelMax();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int timeout) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(closeCode, closeMessage, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int closeCode, String closeMessage, int timeout) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(closeCode, closeMessage, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int closeCode, String closeMessage) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(closeCode, closeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int timeout) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(timeout);
    }

    public AMQConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    @Override
    public void addBlockedListener(BlockedListener listener) {
        this.blockedListeners.add(listener);
        this.delegate.addBlockedListener(listener);
    }

    @Override
    public boolean removeBlockedListener(BlockedListener listener) {
        this.blockedListeners.remove(listener);
        return this.delegate.removeBlockedListener(listener);
    }

    @Override
    public void clearBlockedListeners() {
        this.blockedListeners.clear();
        this.delegate.clearBlockedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(closeCode, closeMessage);
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownHooks.add(listener);
        this.delegate.addShutdownListener(listener);
    }

    @Override
    public void removeShutdownListener(ShutdownListener listener) {
        this.shutdownHooks.remove(listener);
        this.delegate.removeShutdownListener(listener);
    }

    @Override
    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    @Override
    public void addRecoveryListener(RecoveryListener listener) {
        this.recoveryListeners.add(listener);
    }

    @Override
    public void removeRecoveryListener(RecoveryListener listener) {
        this.recoveryListeners.remove(listener);
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.delegate.getExceptionHandler();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public InetAddress getAddress() {
        return this.delegate.getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAutomaticRecoveryListener(final RecoveryAwareAMQConnection newConn) {
        final AutorecoveringConnection c = this;
        RecoveryCanBeginListener starter = new RecoveryCanBeginListener(){

            @Override
            public void recoveryCanBegin(ShutdownSignalException cause) {
                try {
                    if (AutorecoveringConnection.this.shouldTriggerConnectionRecovery(cause)) {
                        c.beginAutomaticRecovery();
                    }
                }
                catch (Exception e) {
                    newConn.getExceptionHandler().handleConnectionRecoveryException(c, e);
                }
            }
        };
        AutorecoveringConnection autorecoveringConnection = this;
        synchronized (autorecoveringConnection) {
            newConn.addRecoveryCanBeginListener(starter);
        }
    }

    protected boolean shouldTriggerConnectionRecovery(ShutdownSignalException cause) {
        return !cause.isInitiatedByApplication() || cause.getCause() instanceof MissedHeartbeatException;
    }

    public void addQueueRecoveryListener(QueueRecoveryListener listener) {
        this.queueRecoveryListeners.add(listener);
    }

    public void removeQueueRecoveryListener(QueueRecoveryListener listener) {
        this.queueRecoveryListeners.remove(listener);
    }

    public void addConsumerRecoveryListener(ConsumerRecoveryListener listener) {
        this.consumerRecoveryListeners.add(listener);
    }

    public void removeConsumerRecoveryListener(ConsumerRecoveryListener listener) {
        this.consumerRecoveryListeners.remove(listener);
    }

    private synchronized void beginAutomaticRecovery() throws InterruptedException {
        Thread.sleep(this.params.getRecoveryDelayHandler().getDelay(0));
        this.notifyRecoveryListenersStarted();
        RecoveryAwareAMQConnection newConn = this.recoverConnection();
        if (newConn == null) {
            return;
        }
        this.addAutomaticRecoveryListener(newConn);
        this.recoverShutdownListeners(newConn);
        this.recoverBlockedListeners(newConn);
        this.recoverChannels(newConn);
        this.delegate = newConn;
        if (this.params.isTopologyRecoveryEnabled()) {
            this.recoverEntities();
            this.recoverConsumers();
        }
        this.notifyRecoveryListenersComplete();
    }

    private void recoverShutdownListeners(RecoveryAwareAMQConnection newConn) {
        for (ShutdownListener sh : Utility.copy(this.shutdownHooks)) {
            newConn.addShutdownListener(sh);
        }
    }

    private void recoverBlockedListeners(RecoveryAwareAMQConnection newConn) {
        for (BlockedListener bl : Utility.copy(this.blockedListeners)) {
            newConn.addBlockedListener(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryAwareAMQConnection recoverConnection() throws InterruptedException {
        int attempts = 0;
        while (!this.manuallyClosed) {
            try {
                ++attempts;
                RecoveryAwareAMQConnection newConn = this.cf.newConnection();
                Object object = this.recoveryLock;
                synchronized (object) {
                    if (!this.manuallyClosed) {
                        return newConn;
                    }
                }
                newConn.abort();
                return null;
            }
            catch (Exception e) {
                Thread.sleep(this.params.getRecoveryDelayHandler().getDelay(attempts));
                this.getExceptionHandler().handleConnectionRecoveryException(this, e);
            }
        }
        return null;
    }

    private void recoverChannels(RecoveryAwareAMQConnection newConn) {
        for (AutorecoveringChannel ch : this.channels.values()) {
            try {
                ch.automaticallyRecover(this, newConn);
            }
            catch (Throwable t) {
                newConn.getExceptionHandler().handleChannelRecoveryException(ch, t);
            }
        }
    }

    private void notifyRecoveryListenersComplete() {
        for (RecoveryListener f : Utility.copy(this.recoveryListeners)) {
            f.handleRecovery(this);
        }
    }

    private void notifyRecoveryListenersStarted() {
        for (RecoveryListener f : Utility.copy(this.recoveryListeners)) {
            f.handleRecoveryStarted(this);
        }
    }

    private void recoverEntities() {
        this.recoverExchanges();
        this.recoverQueues();
        this.recoverBindings();
    }

    private void recoverExchanges() {
        for (RecordedExchange x : Utility.copy(this.recordedExchanges).values()) {
            try {
                x.recover();
            }
            catch (Exception cause) {
                String message = "Caught an exception while recovering exchange " + x.getName() + ": " + cause.getMessage();
                TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, x.getDelegateChannel(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverQueues() {
        for (Map.Entry<String, RecordedQueue> entry : Utility.copy(this.recordedQueues).entrySet()) {
            String oldName = entry.getKey();
            RecordedQueue q = entry.getValue();
            try {
                q.recover();
                String newName = q.getName();
                if (!oldName.equals(newName)) {
                    Map<String, RecordedQueue> map = this.recordedQueues;
                    synchronized (map) {
                        this.propagateQueueNameChangeToBindings(oldName, newName);
                        this.propagateQueueNameChangeToConsumers(oldName, newName);
                        if (q.isServerNamed()) {
                            this.deleteRecordedQueue(oldName);
                        }
                        this.recordedQueues.put(newName, q);
                    }
                }
                for (QueueRecoveryListener qrl : Utility.copy(this.queueRecoveryListeners)) {
                    qrl.queueRecovered(oldName, newName);
                }
            }
            catch (Exception cause) {
                String message = "Caught an exception while recovering queue " + oldName + ": " + cause.getMessage();
                TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, q.getDelegateChannel(), e);
            }
        }
    }

    private void recoverBindings() {
        for (RecordedBinding b : Utility.copy(this.recordedBindings)) {
            try {
                b.recover();
            }
            catch (Exception cause) {
                String message = "Caught an exception while recovering binding between " + b.getSource() + " and " + b.getDestination() + ": " + cause.getMessage();
                TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, b.getDelegateChannel(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverConsumers() {
        for (Map.Entry<String, RecordedConsumer> entry : Utility.copy(this.consumers).entrySet()) {
            String tag = entry.getKey();
            RecordedConsumer consumer = entry.getValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recovering consumer {}", (Object)consumer);
            }
            try {
                String newTag = consumer.recover();
                if (tag != null && !tag.equals(newTag)) {
                    Map<String, RecordedConsumer> map = this.consumers;
                    synchronized (map) {
                        this.consumers.remove(tag);
                        this.consumers.put(newTag, consumer);
                    }
                    consumer.getChannel().updateConsumerTag(tag, newTag);
                }
                for (ConsumerRecoveryListener crl : Utility.copy(this.consumerRecoveryListeners)) {
                    crl.consumerRecovered(tag, newTag);
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Consumer {} has recovered", (Object)consumer);
            }
            catch (Exception cause) {
                String message = "Caught an exception while recovering consumer " + tag + ": " + cause.getMessage();
                TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, consumer.getDelegateChannel(), e);
            }
        }
    }

    private void propagateQueueNameChangeToBindings(String oldName, String newName) {
        for (RecordedBinding b : Utility.copy(this.recordedBindings)) {
            if (!b.getDestination().equals(oldName)) continue;
            b.setDestination(newName);
        }
    }

    private void propagateQueueNameChangeToConsumers(String oldName, String newName) {
        for (RecordedConsumer c : Utility.copy(this.consumers).values()) {
            if (!c.getQueue().equals(oldName)) continue;
            c.setQueue(newName);
        }
    }

    void recordQueueBinding(AutorecoveringChannel ch, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        RecordedBinding binding = new RecordedQueueBinding(ch).source(exchange).destination(queue).routingKey(routingKey).arguments(arguments);
        this.recordedBindings.remove(binding);
        this.recordedBindings.add(binding);
    }

    boolean deleteRecordedQueueBinding(AutorecoveringChannel ch, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        RecordedBinding b = new RecordedQueueBinding(ch).source(exchange).destination(queue).routingKey(routingKey).arguments(arguments);
        return this.recordedBindings.remove(b);
    }

    void recordExchangeBinding(AutorecoveringChannel ch, String destination, String source, String routingKey, Map<String, Object> arguments) {
        RecordedBinding binding = new RecordedExchangeBinding(ch).source(source).destination(destination).routingKey(routingKey).arguments(arguments);
        this.recordedBindings.remove(binding);
        this.recordedBindings.add(binding);
    }

    boolean deleteRecordedExchangeBinding(AutorecoveringChannel ch, String destination, String source, String routingKey, Map<String, Object> arguments) {
        RecordedBinding b = new RecordedExchangeBinding(ch).source(source).destination(destination).routingKey(routingKey).arguments(arguments);
        return this.recordedBindings.remove(b);
    }

    void recordQueue(AMQP.Queue.DeclareOk ok, RecordedQueue q) {
        this.recordedQueues.put(ok.getQueue(), q);
    }

    void recordQueue(String queue, RecordedQueue meta) {
        this.recordedQueues.put(queue, meta);
    }

    void deleteRecordedQueue(String queue) {
        this.recordedQueues.remove(queue);
        Set<RecordedBinding> xs = this.removeBindingsWithDestination(queue);
        for (RecordedBinding b : xs) {
            this.maybeDeleteRecordedAutoDeleteExchange(b.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludeQueueFromRecovery(String queue, boolean ifUnused) {
        if (ifUnused) {
            Map<String, RecordedConsumer> map = this.consumers;
            synchronized (map) {
                Map<String, RecordedQueue> map2 = this.recordedQueues;
                synchronized (map2) {
                    if (!this.hasMoreConsumersOnQueue(this.consumers.values(), queue)) {
                        this.deleteRecordedQueue(queue);
                    }
                }
            }
        }
        this.deleteRecordedQueue(queue);
    }

    void recordExchange(String exchange, RecordedExchange x) {
        this.recordedExchanges.put(exchange, x);
    }

    void deleteRecordedExchange(String exchange) {
        this.recordedExchanges.remove(exchange);
        Set<RecordedBinding> xs = this.removeBindingsWithDestination(exchange);
        for (RecordedBinding b : xs) {
            this.maybeDeleteRecordedAutoDeleteExchange(b.getSource());
        }
    }

    void recordConsumer(String result, RecordedConsumer consumer) {
        this.consumers.put(result, consumer);
    }

    RecordedConsumer deleteRecordedConsumer(String consumerTag) {
        return this.consumers.remove(consumerTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeDeleteRecordedAutoDeleteQueue(String queue) {
        Map<String, RecordedConsumer> map = this.consumers;
        synchronized (map) {
            Map<String, RecordedQueue> map2 = this.recordedQueues;
            synchronized (map2) {
                RecordedQueue q;
                if (!this.hasMoreConsumersOnQueue(this.consumers.values(), queue) && (q = this.recordedQueues.get(queue)) != null && q.isAutoDelete()) {
                    this.deleteRecordedQueue(queue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeDeleteRecordedAutoDeleteExchange(String exchange) {
        Map<String, RecordedConsumer> map = this.consumers;
        synchronized (map) {
            Map<String, RecordedExchange> map2 = this.recordedExchanges;
            synchronized (map2) {
                RecordedExchange x;
                if (!this.hasMoreDestinationsBoundToExchange(Utility.copy(this.recordedBindings), exchange) && (x = this.recordedExchanges.get(exchange)) != null && x.isAutoDelete()) {
                    this.deleteRecordedExchange(exchange);
                }
            }
        }
    }

    boolean hasMoreDestinationsBoundToExchange(List<RecordedBinding> bindings, String exchange) {
        boolean result = false;
        for (RecordedBinding b : bindings) {
            if (!exchange.equals(b.getSource())) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean hasMoreConsumersOnQueue(Collection<RecordedConsumer> consumers, String queue) {
        boolean result = false;
        for (RecordedConsumer c : consumers) {
            if (!queue.equals(c.getQueue())) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<RecordedBinding> removeBindingsWithDestination(String s) {
        HashSet<RecordedBinding> result = new HashSet<RecordedBinding>();
        List<RecordedBinding> list = this.recordedBindings;
        synchronized (list) {
            Iterator<RecordedBinding> it = this.recordedBindings.iterator();
            while (it.hasNext()) {
                RecordedBinding b = it.next();
                if (!b.getDestination().equals(s)) continue;
                it.remove();
                result.add(b);
            }
        }
        return result;
    }

    public Map<String, RecordedQueue> getRecordedQueues() {
        return this.recordedQueues;
    }

    public Map<String, RecordedExchange> getRecordedExchanges() {
        return this.recordedExchanges;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public void setId(String id) {
        this.delegate.setId(id);
    }
}

