/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl.recovery;

import com.kingdee.bos.rabbitmq.amqp.Address;
import com.kingdee.bos.rabbitmq.amqp.AddressResolver;
import com.kingdee.bos.rabbitmq.amqp.ListAddressResolver;
import com.kingdee.bos.rabbitmq.amqp.MetricsCollector;
import com.kingdee.bos.rabbitmq.amqp.NoOpMetricsCollector;
import com.kingdee.bos.rabbitmq.amqp.impl.ConnectionParams;
import com.kingdee.bos.rabbitmq.amqp.impl.FrameHandler;
import com.kingdee.bos.rabbitmq.amqp.impl.FrameHandlerFactory;
import com.kingdee.bos.rabbitmq.amqp.impl.recovery.RecoveryAwareAMQConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class RecoveryAwareAMQConnectionFactory {
    private final ConnectionParams params;
    private final FrameHandlerFactory factory;
    private final AddressResolver addressResolver;
    private final MetricsCollector metricsCollector;

    public RecoveryAwareAMQConnectionFactory(ConnectionParams params, FrameHandlerFactory factory, List<Address> addrs) {
        this(params, factory, new ListAddressResolver(addrs), new NoOpMetricsCollector());
    }

    public RecoveryAwareAMQConnectionFactory(ConnectionParams params, FrameHandlerFactory factory, AddressResolver addressResolver) {
        this(params, factory, addressResolver, new NoOpMetricsCollector());
    }

    public RecoveryAwareAMQConnectionFactory(ConnectionParams params, FrameHandlerFactory factory, AddressResolver addressResolver, MetricsCollector metricsCollector) {
        this.params = params;
        this.factory = factory;
        this.addressResolver = addressResolver;
        this.metricsCollector = metricsCollector;
    }

    public RecoveryAwareAMQConnection newConnection() throws IOException, TimeoutException {
        Exception lastException = null;
        List<Address> shuffled = RecoveryAwareAMQConnectionFactory.shuffle(this.addressResolver.getAddresses());
        for (Address addr : shuffled) {
            try {
                FrameHandler frameHandler = this.factory.create(addr);
                RecoveryAwareAMQConnection conn = this.createConnection(this.params, frameHandler, this.metricsCollector);
                conn.start();
                this.metricsCollector.newConnection(conn);
                return conn;
            }
            catch (IOException e) {
                lastException = e;
            }
            catch (TimeoutException te) {
                lastException = te;
            }
        }
        if (lastException != null) {
            if (lastException instanceof IOException) {
                throw (IOException)lastException;
            }
            if (lastException instanceof TimeoutException) {
                throw (TimeoutException)lastException;
            }
        }
        throw new IOException("failed to connect");
    }

    private static List<Address> shuffle(List<Address> addrs) {
        ArrayList<Address> list = new ArrayList<Address>(addrs);
        Collections.shuffle(list);
        return list;
    }

    protected RecoveryAwareAMQConnection createConnection(ConnectionParams params, FrameHandler handler, MetricsCollector metricsCollector) {
        return new RecoveryAwareAMQConnection(params, handler, metricsCollector);
    }
}

