/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.consumer.subscribe;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.rabbitmq.amqp.AMQP;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.DefaultConsumer;
import com.kingdee.bos.rabbitmq.amqp.Envelope;
import com.kingdee.bos.rabbitmq.connection.ChannelFactory;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.consumer.ack.RabbitAcker;
import com.kingdee.bos.rabbitmq.consumer.subscribe.MessageConsumer;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.support.MessageSerde;
import com.kingdee.bos.rabbitmq.util.CollectionUtils;
import com.kingdee.bos.rabbitmq.util.LogUtils;
import com.kingdee.bos.rabbitmq.util.MQThreadLocalUtil;
import com.kingdee.bos.rabbitmq.util.RabbitMQCacheUtils;
import com.kingdee.bos.rabbitmq.util.RabbitMQReflectInvokeUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RabbitConsumer
extends DefaultConsumer {
    private static Logger logger = Logger.getLogger((String)RabbitConsumer.class.getName());
    private static final String SYSTEM_TYPE = "mq.server.type";
    private String queue;
    private boolean autoAck;
    private MessageConsumer mc;
    private String region;
    private RabbitAcker acker;
    private boolean needCallBack;
    private String productorName;
    private ProductorEntity autoCallBackProductor;
    private ConnectionEntity connectionInfo;

    public RabbitConsumer(String region, String queue, boolean autoAck, ConnectionEntity connectionInfo, MessageConsumer mc, boolean needCallBack, String productorName) {
        super(ChannelFactory.getChannel(region, connectionInfo));
        this.region = region;
        this.queue = queue;
        this.autoAck = autoAck;
        this.mc = mc;
        this.needCallBack = needCallBack;
        this.productorName = productorName;
    }

    public RabbitConsumer(String region, String queue, boolean autoAck, ConnectionEntity connectionInfo, MessageConsumer mc, boolean needCallBack, ProductorEntity autoCallBackProductor) {
        super(ChannelFactory.getChannel(region, connectionInfo));
        this.region = region;
        this.queue = queue;
        this.autoAck = autoAck;
        this.mc = mc;
        this.needCallBack = needCallBack;
        this.autoCallBackProductor = autoCallBackProductor;
        this.connectionInfo = connectionInfo;
    }

    public void start() {
        Channel channel = this.getChannel();
        this.acker = new RabbitAcker(channel, this.autoAck, this.needCallBack, this.queue, this.region, this.productorName);
        QueueManager.declareIfNeed(this.getChannel(), this.region, this.queue);
        try {
            channel.basicQos(1);
            channel.basicConsume(this.queue, this.autoAck, this);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't init consumer for queue " + this.queue, e);
        }
    }

    public void ierpStart() {
        Channel channel = this.getChannel();
        this.acker = new RabbitAcker(channel, this.autoAck, this.needCallBack, this.queue, this.region, this.autoCallBackProductor, this.connectionInfo);
        QueueManager.declareIfNeed(channel, this.region, this.queue);
        try {
            channel.basicQos(1);
            channel.basicConsume(this.queue, this.autoAck, this);
            if (null != this.connectionInfo && !StringUtils.isEmpty(this.connectionInfo.getVhost())) {
                RabbitMQCacheUtils.putChannel(this.connectionInfo.getVhost() + "_" + this.queue, channel);
            } else {
                RabbitMQCacheUtils.putChannel(this.queue, channel);
            }
        }
        catch (IOException e) {
            logger.error((Object)LogUtils.convertValidLog("start channel failed,Can't init consumer for queue " + this.queue), (Throwable)e);
            throw new RuntimeException("start channel failed,Can't init consumer for queue " + this.queue, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        MQThreadLocalUtil.clear();
        JSONObject havaContextJson = null;
        try {
            String message;
            String messageId;
            block15: {
                if (this.isIerpSystem()) {
                    this.ierpDisableQueue();
                }
                messageId = String.valueOf(envelope.getDeliveryTag());
                havaContextJson = this.toMessage(body);
                message = this.toMessage(havaContextJson);
                try {
                    JSONObject extendObj = JSONObject.parseObject((String)havaContextJson.getString("extend"));
                    this.mc.initContext(extendObj, havaContextJson.getString("data"), messageId, envelope.isRedeliver(), this.acker);
                }
                catch (Exception e) {
                    logger.error((Object)("kd.isc.rabbit.consumer initContext failed.exception info:" + e));
                    if (this.acker.isFinsh()) break block15;
                    this.acker.ack(messageId, ThrowableHelper.toString((Exception)e));
                }
            }
            if (this.isIerpSystem()) {
                RabbitMQReflectInvokeUtils.consumerMsgHandcapacity(body);
            }
            try {
                if (!this.acker.isFinsh()) {
                    this.mc.onMessage(message, messageId, envelope.isRedeliver(), this.acker);
                }
            }
            catch (Exception e) {
                logger.error((Object)"kd.isc.rabbit.consumer handleDelivery message failed.exception info:", (Throwable)e);
                if (!this.acker.isFinsh()) {
                    this.acker.ack(messageId, ThrowableHelper.toString((Exception)e));
                }
            }
            finally {
                if (!this.acker.isFinsh()) {
                    this.acker.ack(messageId, null);
                }
                this.acker.setFinsh(false);
            }
        }
        catch (Throwable e) {
            if (havaContextJson == null) {
                logger.error((Object)"kd.isc.rabbit.consumer.deliveryMessageError,format input data error.", e);
            }
            logger.error((Object)("kd.isc.rabbit.consumer.deliveryMessageError.data:" + havaContextJson.toJSONString()), e);
        }
    }

    private JSONObject toMessage(byte[] body) {
        return MessageSerde.get().decode(body);
    }

    private String toMessage(JSONObject mqData) {
        String data = null;
        if (!StringUtils.isNullObj(mqData) && mqData.containsKey((Object)"data")) {
            data = mqData.getString("data");
        }
        return data;
    }

    private void ierpDisableQueue() {
        if (RabbitMQCacheUtils.containKey(this.queue) && !CollectionUtils.isEmpty(RabbitMQCacheUtils.takeChanel(this.queue))) {
            for (Channel ch : RabbitMQCacheUtils.takeChanel(this.queue)) {
                try {
                    ch.close();
                }
                catch (Exception e) {
                    logger.error((Object)("the channel close failed.exception info :" + e));
                }
            }
            RabbitMQCacheUtils.removeChannel(this.queue);
        }
    }

    private boolean isIerpSystem() {
        String sysType = System.getProperty(SYSTEM_TYPE);
        return !StringUtils.isEmpty(sysType) && sysType.equalsIgnoreCase("ierp");
    }
}

