/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.hessian;

import com.kingdee.bos.rabbitmq.hessian.CallerSensitive;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class Reflection {
    private static volatile Map<Class<?>, String[]> fieldFilterMap;
    private static volatile Map<Class<?>, String[]> methodFilterMap;

    @CallerSensitive
    public static native Class<?> getCallerClass();

    @Deprecated
    public static native Class<?> getCallerClass(int var0);

    public static native int getClassAccessFlags(Class<?> var0);

    public static boolean quickCheckMemberAccess(Class<?> clazz, int n) {
        return Modifier.isPublic(Reflection.getClassAccessFlags(clazz) & n);
    }

    public static void ensureMemberAccess(Class<?> clazz, Class<?> clazz2, Object o, int n) throws IllegalAccessException {
        if (clazz == null || clazz2 == null) {
            throw new InternalError();
        }
        if (!Reflection.verifyMemberAccess(clazz, clazz2, o, n)) {
            throw new IllegalAccessException("Class " + clazz.getName() + " can not access a member of class " + clazz2.getName() + " with modifiers \"" + Modifier.toString(n) + "\"");
        }
    }

    public static boolean verifyMemberAccess(Class<?> clazz, Class<?> clazz2, Object o, int n) {
        boolean n2 = false;
        boolean b = false;
        if (clazz == clazz2) {
            return true;
        }
        if (!Modifier.isPublic(Reflection.getClassAccessFlags(clazz2))) {
            b = Reflection.isSameClassPackage(clazz, clazz2);
            n2 = true;
            if (!b) {
                return false;
            }
        }
        if (Modifier.isPublic(n)) {
            return true;
        }
        boolean n3 = false;
        if (Modifier.isProtected(n) && Reflection.isSubclassOf(clazz, clazz2)) {
            n3 = true;
        }
        if (!n3 && !Modifier.isPrivate(n)) {
            if (!n2) {
                b = Reflection.isSameClassPackage(clazz, clazz2);
                n2 = true;
            }
            if (b) {
                n3 = true;
            }
        }
        if (!n3) {
            return false;
        }
        if (Modifier.isProtected(n)) {
            Class<?> clazz3;
            Class<?> clazz4 = clazz3 = o == null ? clazz2 : o.getClass();
            if (clazz3 != clazz) {
                if (!n2) {
                    b = Reflection.isSameClassPackage(clazz, clazz2);
                }
                if (!b && !Reflection.isSubclassOf(clazz3, clazz)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isSameClassPackage(Class<?> clazz, Class<?> clazz2) {
        return Reflection.isSameClassPackage(clazz.getClassLoader(), clazz.getName(), clazz2.getClassLoader(), clazz2.getName());
    }

    private static boolean isSameClassPackage(ClassLoader classLoader, String s, ClassLoader classLoader2, String s2) {
        int n3;
        if (classLoader != classLoader2) {
            return false;
        }
        int lastIndex = s.lastIndexOf(46);
        int lastIndex2 = s2.lastIndexOf(46);
        if (lastIndex == -1 || lastIndex2 == -1) {
            return lastIndex == lastIndex2;
        }
        int n = 0;
        int n2 = 0;
        if (s.charAt(n) == '[') {
            while (s.charAt(++n) == '[') {
            }
            if (s.charAt(n) != 'L') {
                throw new InternalError("Illegal class name " + s);
            }
        }
        if (s2.charAt(n2) == '[') {
            while (s2.charAt(++n2) == '[') {
            }
            if (s2.charAt(n2) != 'L') {
                throw new InternalError("Illegal class name " + s2);
            }
        }
        return (n3 = lastIndex - n) == lastIndex2 - n2 && s.regionMatches(false, n, s2, n2, n3);
    }

    static boolean isSubclassOf(Class<?> superclass, Class<?> clazz) {
        while (superclass != null) {
            if (superclass == clazz) {
                return true;
            }
            superclass = superclass.getSuperclass();
        }
        return false;
    }

    public static synchronized void registerFieldsToFilter(Class<?> clazz, String ... array) {
        fieldFilterMap = Reflection.registerFilter(fieldFilterMap, clazz, array);
    }

    public static synchronized void registerMethodsToFilter(Class<?> clazz, String ... array) {
        methodFilterMap = Reflection.registerFilter(methodFilterMap, clazz, array);
    }

    private static Map<Class<?>, String[]> registerFilter(Map<Class<?>, String[]> map, Class<?> clazz, String ... array) {
        if (map.get(clazz) != null) {
            throw new IllegalArgumentException("Filter already registered: " + clazz);
        }
        HashMap hashMap = new HashMap(map);
        hashMap.put(clazz, array);
        return hashMap;
    }

    public static Field[] filterFields(Class<?> clazz, Field[] array) {
        if (fieldFilterMap == null) {
            return array;
        }
        return (Field[])Reflection.filter(array, fieldFilterMap.get(clazz));
    }

    public static Method[] filterMethods(Class<?> clazz, Method[] array) {
        if (methodFilterMap == null) {
            return array;
        }
        return (Method[])Reflection.filter(array, methodFilterMap.get(clazz));
    }

    private static Member[] filter(Member[] array, String[] array2) {
        if (array2 == null || array.length == 0) {
            return array;
        }
        int n = 0;
        for (Member member : array) {
            boolean b = false;
            int length2 = array2.length;
            for (int j = 0; j < length2; ++j) {
                if (member.getName() != array2[j]) continue;
                b = true;
                break;
            }
            if (b) continue;
            ++n;
        }
        Member[] array3 = (Member[])Array.newInstance(array[0].getClass(), n);
        int n2 = 0;
        for (Member member2 : array) {
            boolean b2 = false;
            int length4 = array2.length;
            for (int l = 0; l < length4; ++l) {
                if (member2.getName() != array2[l]) continue;
                b2 = true;
                break;
            }
            if (b2) continue;
            array3[n2++] = member2;
        }
        return array3;
    }

    public static boolean isCallerSensitive(Method paramMethod) {
        ClassLoader localClassLoader = paramMethod.getDeclaringClass().getClassLoader();
        if (localClassLoader == null || Reflection.isExtClassLoader(localClassLoader)) {
            return paramMethod.isAnnotationPresent(CallerSensitive.class);
        }
        return false;
    }

    private static boolean isExtClassLoader(ClassLoader paramClassLoader) {
        for (ClassLoader localClassLoader = ClassLoader.getSystemClassLoader(); localClassLoader != null; localClassLoader = localClassLoader.getParent()) {
            if (localClassLoader.getParent() != null || localClassLoader != paramClassLoader) continue;
            return true;
        }
        return false;
    }

    static {
        HashMap localHashMap = new HashMap();
        localHashMap.put(Reflection.class, new String[]{"fieldFilterMap", "methodFilterMap"});
        localHashMap.put(System.class, new String[]{"security"});
        fieldFilterMap = localHashMap;
    }
}

