/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.productor.mqfactory;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.connection.ChannelFactory;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ExtendEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerQueue;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.entity.PublisherEntity;
import com.kingdee.bos.rabbitmq.entity.QueueDef;
import com.kingdee.bos.rabbitmq.entity.RegionDef;
import com.kingdee.bos.rabbitmq.initialize.InitQueue;
import com.kingdee.bos.rabbitmq.productor.mqfactory.MQFactory;
import com.kingdee.bos.rabbitmq.productor.publish.MessagePublisher;
import com.kingdee.bos.rabbitmq.productor.publish.RabbitMQPublisher;
import com.kingdee.bos.rabbitmq.util.RabbitMQCacheUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class RabbitMQFactory
extends MQFactory {
    private static Logger logger = Logger.getLogger((String)RabbitMQFactory.class.getName());
    private static Map<String, Boolean> delcareQueueMap = new ConcurrentHashMap<String, Boolean>();
    private boolean needCallBack = false;
    private String region;
    private String queueName;
    private String callbackClass;
    private String tag;

    @Override
    public List<MessagePublisher> createSimplePublisher() {
        PublisherEntity publisher = this.getPublisherEntity();
        if (null == publisher) {
            logger.error((Object)"read xml config file,the publisher node info is null.");
            return null;
        }
        ArrayList<MessagePublisher> publishList = new ArrayList<MessagePublisher>();
        MessagePublisher msgPublisher = null;
        String region = null;
        for (RegionDef r : publisher.getRegionDefs()) {
            region = r.getName();
            for (QueueDef q : r.getQueues()) {
                msgPublisher = this.createSimplePublisher(region, q.getName(), q.getAutoSubscribeClass());
                publishList.add(msgPublisher);
            }
        }
        return publishList;
    }

    @Override
    public MessagePublisher createSimplePublisher(String region, String queueName, String callbackClass) {
        this.callbackClass = callbackClass;
        this.region = region;
        this.queueName = queueName;
        this.needCallBack = StringUtils.isNotEmpty(callbackClass);
        ConnectionEntity conn = this.getConnection();
        if (null == conn) {
            logger.error((Object)"the productor connection information is null.");
            throw new RuntimeException("the productor connection information is null.");
        }
        String realQueueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), region, queueName, false, null);
        Channel channel = ChannelFactory.getChannel(region, conn);
        String key = QueueManager.makeKey(conn.getUserName(), region, realQueueName);
        try {
            if (!delcareQueueMap.containsKey(key)) {
                channel.queueDeclare(realQueueName, true, false, false, null);
                delcareQueueMap.put(key, Boolean.TRUE);
            }
        }
        catch (IOException e) {
            logger.error((Object)"other system create productor publisher failed.");
            throw new RuntimeException("other system create productor publisher failed.", e);
        }
        if (this.needCallBack) {
            this.createSimpleConsumer(conn, false);
        }
        ProductorEntity productor = this.getProductor();
        JSONObject extendsData = null;
        if (!StringUtils.isNullObj(productor)) {
            ExtendEntity extendEntity = productor.getExtend();
            extendsData = extendEntity.getExtendData();
        }
        return new RabbitMQPublisher(realQueueName, channel, extendsData);
    }

    @Override
    protected MessagePublisher createSimplePublisher(String region, String queueName, String consumerClass, ConnectionEntity mqConn, JSONObject productorExt) {
        this.callbackClass = consumerClass;
        this.region = region;
        this.queueName = queueName;
        this.needCallBack = StringUtils.isNotEmpty(consumerClass);
        if (null == mqConn) {
            logger.error((Object)"IERP sytem the productor connection information is null.");
            throw new RuntimeException("IERP sytem the productor connection information is null.");
        }
        String realQueueName = QueueManager.getRealQueueName(mqConn.getUserName(), mqConn.getPassword(), region, queueName, false, null);
        Channel channel = ChannelFactory.getChannel(region, mqConn);
        String key = QueueManager.makeKey(mqConn.getUserName(), region, realQueueName);
        try {
            if (!delcareQueueMap.containsKey(key)) {
                channel.queueDeclare(realQueueName, true, false, false, null);
                delcareQueueMap.put(key, Boolean.TRUE);
            }
        }
        catch (IOException e) {
            logger.error((Object)"IERP system create productor publisher failed.");
            throw new RuntimeException("IERP system create productor publisher failed.", e);
        }
        if (this.needCallBack) {
            this.createSimpleConsumer(mqConn, true);
        }
        return new RabbitMQPublisher(realQueueName, channel, productorExt);
    }

    private void createSimpleConsumer(ConnectionEntity conn, boolean isIerp) {
        if (StringUtils.isNullObj(conn)) {
            logger.error((Object)"productor auto subscribe message,MQ connection is not exist.");
            return;
        }
        String realQueueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), this.region, this.queueName, true, this.tag);
        String tempKey = "";
        if (!StringUtils.isEmpty(conn.getVhost())) {
            tempKey = conn.getVhost() + "_";
        }
        if (!RabbitMQCacheUtils.containKey(tempKey = tempKey + realQueueName)) {
            try {
                if (!isIerp) {
                    InitQueue.initConsumer(this.region, realQueueName, this.callbackClass, false, conn, false, null);
                } else {
                    IERPConsumerQueue consumerQueue = new IERPConsumerQueue();
                    consumerQueue.setConsumerClass(this.callbackClass);
                    consumerQueue.setRegion(this.region);
                    consumerQueue.setAutoCallBack(false);
                    InitQueue.initIerpConsumer(consumerQueue, realQueueName, conn, null);
                }
                RabbitMQCacheUtils.put(tempKey, true);
            }
            catch (Exception e) {
                logger.error((Object)("create auto subscribe consumer failed.exception info:" + e.getMessage()));
            }
        }
    }

    public void startPublishQueues(String region, String queueName, ConnectionEntity mqConn, String tag) {
        this.region = region;
        this.queueName = queueName;
        if (null == mqConn) {
            logger.error((Object)"the EAS system the productor connection information is null.");
            throw new RuntimeException("the EAS system the productor connection information is null.");
        }
        String realQueueName = QueueManager.getRealQueueName(mqConn.getUserName(), mqConn.getPassword(), region, queueName, false, tag);
        Channel channel = ChannelFactory.getChannel(region, mqConn);
        try {
            QueueManager.declareIfNeed(channel, region, realQueueName);
            if (StringUtils.isNotEmpty(mqConn.getVhost())) {
                realQueueName = mqConn.getVhost() + "_" + realQueueName;
            }
            RabbitMQCacheUtils.putChannel(realQueueName, channel);
        }
        catch (Exception e) {
            logger.error((Object)"the EAS system create productor publisher failed.", (Throwable)e);
            throw new RuntimeException("the EAS system create productor declare queue failed.", e);
        }
    }

    @Override
    protected MessagePublisher createSimplePublisher(String region, String queueName, String consumerClass, String tag, ConnectionEntity mqConn, JSONObject productor) {
        this.callbackClass = consumerClass;
        this.region = region;
        this.queueName = queueName;
        this.needCallBack = StringUtils.isNotEmpty(consumerClass);
        this.tag = tag;
        if (null == mqConn) {
            logger.error((Object)"the EAS system the productor connection information is null.");
            throw new RuntimeException("the EAS system the productor connection information is null.");
        }
        String realQueueName = QueueManager.getRealQueueName(mqConn.getUserName(), mqConn.getPassword(), region, queueName, false, tag);
        Channel channel = ChannelFactory.getChannel(region, mqConn);
        String key = QueueManager.makeKey(mqConn.getUserName(), region, realQueueName);
        try {
            if (!delcareQueueMap.containsKey(key)) {
                channel.queueDeclare(realQueueName, true, false, false, null);
                delcareQueueMap.put(key, Boolean.TRUE);
            }
        }
        catch (IOException e) {
            logger.error((Object)"the EAS system create productor publisher failed.");
            throw new RuntimeException("the EAS system create productor publisher failed.", e);
        }
        return new RabbitMQPublisher(realQueueName, channel, productor);
    }
}

