/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rabbitmq.rabbit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerQueue;
import com.kingdee.bos.rabbitmq.entity.RabbitAPIInvokeEntity;
import com.kingdee.bos.rabbitmq.model.APIResultModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.eipserviceplugin.EipServicePluginAdaptorFactory;
import com.kingdee.eas.csinterface.openapi.FeedBackServiceFactory;
import com.kingdee.eas.csinterface.util.ComponentHelper;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.rabbitmq.rabbit.IRunScriptFacade;
import com.kingdee.eas.rabbitmq.rabbit.RabbitCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitFacadeFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitTreeFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitTreeInfo;
import com.kingdee.eas.rabbitmq.rabbit.RunScriptFacadeFactory;
import com.kingdee.eas.rabbitmq.rabbit.client.AbstractRabbitEditUI;
import com.kingdee.eas.rabbitmq.rabbit.common.QueueDetailInfo;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class RabbitEditUI
extends AbstractRabbitEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RabbitEditUI.class);
    private static final String THREAD_COUNT_REG = "^([1-9]\\d?|100)$";
    private String actionName;
    private static IRow selectTableRow = null;
    private int currenteSelectedRow = -1;
    private ConnectionEntity mqConnection;

    public void onShow() throws Exception {
        super.onShow();
        this.kdtSelectListener(this.kdtPublish);
        this.kdtSelectListener(this.kdtConsumer);
    }

    private void kdtSelectListener(KDTable kdt) {
        KDTable kdtMergeEntryTable = kdt;
        kdtMergeEntryTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent selectEvent) {
                KDTSelectBlock preBolck = selectEvent.getPrevSelectBlock();
                if (preBolck == null) {
                    RabbitEditUI.this.currenteSelectedRow = 0;
                } else {
                    RabbitEditUI.this.currenteSelectedRow = selectEvent.getSelectBlock().getBeginRow();
                }
            }
        });
        if (kdtMergeEntryTable.getRowCount() > 0) {
            KDTableUtil.setSelectedRow((KDTable)kdtMergeEntryTable, (int)0);
            this.currenteSelectedRow = 0;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ComponentHelper.setVisible((JComponent[])new JComponent[]{this.btnFirst, this.btnPre, this.btnNext, this.btnLast, this.btnCancelCancel, this.btnCancel, this.btnSave}, (boolean)false);
        this.btnPubAddTab.setEnabled(true);
        this.btnPubDelTab.setEnabled(true);
        this.btnConAddTab.setEnabled(true);
        this.btnConDelTab.setEnabled(true);
        String longNumber = ((RabbitTreeInfo)this.tree.getData()).getLongNumber();
        if (!StringUtils.isEmpty((String)longNumber) && longNumber.indexOf("!") > 0) {
            String lNumber = longNumber.split("!")[0];
            RabbitTreeInfo treeInfo = RabbitTreeFactory.getRemoteInstance().getRabbitTreeInfo("where longnumber='" + lNumber + "'");
            this.tree.setValue((Object)treeInfo);
        }
    }

    public void setSelectRow(int index, KDTable tab) {
        selectTableRow = tab.getRow(index);
    }

    @Override
    public void addTab_actionPerformed(ActionEvent e) throws Exception {
        this.actionName = ((KDWorkButton)e.getSource()).getName();
        if ("btnPubAddTab".equals(this.actionName)) {
            IRow editRow = this.kdtPublish.addRow();
            editRow.getCell("isautoscribe").setValue((Object)false);
            editRow.getCell("ispreset").setValue((Object)false);
            KDTableUtil.setSelectedRow((KDTable)this.kdtPublish, (int)editRow.getRowIndex());
            this.setSelectRow(editRow.getRowIndex(), this.kdtPublish);
        } else if ("btnConAddTab".equals(this.actionName)) {
            IRow editRow = this.kdtConsumer.addRow();
            editRow.getCell("iscallback").setValue((Object)false);
            editRow.getCell("ispreset").setValue((Object)false);
            KDTableUtil.setSelectedRow((KDTable)this.kdtConsumer, (int)editRow.getRowIndex());
            this.setSelectRow(editRow.getRowIndex(), this.kdtConsumer);
        }
    }

    @Override
    public void delTab_actionPerformed(ActionEvent e) throws Exception {
        this.actionName = ((KDWorkButton)e.getSource()).getName();
        if ("btnPubDelTab".equals(this.actionName)) {
            this.validateDelPresetPulishQueue();
            this.kdtPublish.removeRow(this.currenteSelectedRow);
            KDTableUtil.setSelectedRow((KDTable)this.kdtPublish, (int)this.currenteSelectedRow);
            this.setSelectRow(this.currenteSelectedRow, this.kdtPublish);
        } else if ("btnConDelTab".equals(this.actionName)) {
            this.validateDelConsumerQueue();
            this.kdtConsumer.removeRow(this.currenteSelectedRow);
            KDTableUtil.setSelectedRow((KDTable)this.kdtConsumer, (int)this.currenteSelectedRow);
            this.setSelectRow(this.currenteSelectedRow, this.kdtConsumer);
        }
    }

    private void validateDelPresetPulishQueue() throws BOSException, EASBizException {
        RabbitPublishInfo pubInfo;
        IRow row = this.kdtPublish.getRow(this.currenteSelectedRow);
        if (null != row.getCell("id") && null != row.getCell("id").getValue() && null != (pubInfo = RabbitPublishFactory.getRemoteInstance().getRabbitPublishInfo("where id='" + row.getCell("id").getValue().toString() + "'"))) {
            if (pubInfo.isIspreset()) {
                MsgBox.showInfo((String)("\u5f53\u524d\u751f\u4ea7\u8005\u961f\u5217\uff1a" + pubInfo.getQueue() + ",\u4e3a\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01"));
                SysUtil.abort();
            } else {
                boolean feedInfoIsExist;
                boolean adpatorInfoIsExist = EipServicePluginAdaptorFactory.getRemoteInstance().exists("where queue='" + pubInfo.getId().toString() + "'");
                if (adpatorInfoIsExist) {
                    MsgBox.showInfo((String)("\u62e6\u622a\u670d\u52a1\u5f15\u7528\u4e86\u5f53\u524d\u751f\u4ea7\u8005\u961f\u5217\uff1a" + pubInfo.getQueue() + " \u4e0d\u80fd\u5220\u9664\uff01"));
                    SysUtil.abort();
                }
                if (feedInfoIsExist = FeedBackServiceFactory.getRemoteInstance().exists("where queue='" + pubInfo.getId().toString() + "'")) {
                    MsgBox.showInfo((String)("\u6570\u636e\u53cd\u5199\u670d\u52a1\u5f15\u7528\u4e86\u5f53\u524d\u751f\u4ea7\u8005\u961f\u5217\uff1a" + pubInfo.getQueue() + " \u4e0d\u80fd\u5220\u9664\uff01"));
                    SysUtil.abort();
                }
            }
        }
    }

    private void validateDelConsumerQueue() throws EASBizException, BOSException {
        RabbitConsumerInfo conInfo;
        IRow row = this.kdtConsumer.getRow(this.currenteSelectedRow);
        if (null != row.getCell("id") && null != row.getCell("id").getValue() && null != (conInfo = RabbitConsumerFactory.getRemoteInstance().getRabbitConsumerInfo("where id='" + row.getCell("id").getValue().toString() + "'")) && conInfo.isIspreset()) {
            MsgBox.showInfo((String)("\u5f53\u524d\u6d88\u8d39\u8005\u961f\u5217\uff1a" + conInfo.getQueue() + ",\u4e3a\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01"));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkSaveMQData()) {
            return;
        }
        this.validateTag();
        super.actionSubmit_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    private boolean checkSaveMQData() throws Exception {
        this.editData.setNumber(this.number.getText());
        this.editData.setName(this.name.getName());
        String vhost = this.vhost.getText();
        if (StringUtils.isEmpty((String)vhost)) {
            vhost = "%2F";
        }
        String userName = this.userNamer.getText();
        String pwd = this.userPwd.getText();
        RabbitTreeInfo server = (RabbitTreeInfo)this.tree.getValue();
        WSServiceInfo remoteServer = (WSServiceInfo)this.remoteServer.getValue();
        RabbitFactory.getRemoteInstance().checkNumberBlank(this.editData);
        RabbitFactory.getRemoteInstance().checkNameBlank(this.editData);
        RabbitFactory.getRemoteInstance().checkNumberDup(this.editData);
        RabbitFactory.getRemoteInstance().checkNameDup(this.editData);
        if (StringUtils.isEmpty((String)userName)) {
            MsgBox.showInfo((String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)pwd)) {
            MsgBox.showInfo((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SysUtil.abort();
        }
        if (null == remoteServer) {
            MsgBox.showInfo((String)"\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SysUtil.abort();
        }
        String ip = server.getIp();
        String apiPort = server.getApiport();
        String protocol = server.getProtocol().getName();
        APIResultModel result = RabbitFacadeFactory.getRemoteInstance().validateCurrUserVhost(new RabbitAPIInvokeEntity(ip, apiPort, userName, pwd, protocol, vhost));
        if (null != result && !result.isSuccess()) {
            MsgBox.showInfo((String)result.getErrMsg());
            SysUtil.abort();
        }
        return this.checkQueues(ip, apiPort);
    }

    private boolean checkQueues(String ip, String apiPort) {
        ArrayList<IERPConsumerQueue> queues = new ArrayList<IERPConsumerQueue>();
        ArrayList<String> ids = new ArrayList<String>();
        String tag = this.tag.getText();
        int rowCount = this.kdtPublish.getRowCount();
        IRow row = null;
        Object region = null;
        Object queue = null;
        boolean isAutoSubscribe = false;
        Object dealClass = null;
        try {
            for (int i = 0; i < rowCount; ++i) {
                String validateMsg;
                row = this.kdtPublish.getRow(i);
                region = row.getCell("region").getValue();
                queue = row.getCell("queue").getValue();
                if (null != row.getCell("isautoscribe").getValue()) {
                    isAutoSubscribe = Boolean.valueOf(row.getCell("isautoscribe").getValue().toString());
                }
                dealClass = row.getCell("autosubscribeclass").getValue();
                if (null == region || null == queue || isAutoSubscribe && null == dealClass) {
                    MsgBox.showInfo((String)("\u751f\u4ea7\u8005\u961f\u5217\uff1a\u7b2c\u3010" + (i + 1) + "\u3011\u884c\uff0c\u5206\u7c7b\u3001\u751f\u4ea7\u8005\u961f\u5217\u540d\u6216\u81ea\u52a8\u8ba2\u9605\u5904\u7406\u7c7b\u4e3a\u7a7a\uff01"));
                    SysUtil.abort();
                }
                if (isAutoSubscribe && !StringUtils.isEmpty((String)(validateMsg = this.validateClassLegal(dealClass.toString())))) {
                    String errMsg = "\u751f\u4ea7\u8005\u961f\u5217\uff1a\u7b2c\u3010" + (i + 1) + "\u3011\u884c\uff0c" + validateMsg;
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)("\u751f\u4ea7\u8005\u961f\u5217\uff1a\u7b2c\u3010" + (i + 1) + "\u3011\u884c,\u81ea\u52a8\u8ba2\u9605\u5904\u7406\u7c7b\u6709\u8bef\uff01"), (String)errMsg, (int)1);
                    SysUtil.abort();
                }
                IERPConsumerQueue q = new IERPConsumerQueue();
                q.setQueueName(queue.toString());
                q.setRegion(region.toString());
                q.setTag(tag);
                if (null != row.getCell("id") && null != row.getCell("id").getValue()) {
                    ids.add(row.getCell("id").getValue().toString());
                }
                queues.add(q);
            }
            Object threadCount = null;
            rowCount = this.kdtConsumer.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String validateMsg;
                row = this.kdtConsumer.getRow(i);
                region = row.getCell("region").getValue();
                queue = row.getCell("queue").getValue();
                dealClass = row.getCell("consumerclass").getValue();
                threadCount = row.getCell("threadcount").getValue();
                if (null == region || null == queue || null == dealClass || null == threadCount) {
                    MsgBox.showInfo((String)("\u6d88\u8d39\u8005\u961f\u5217\u961f\u5217\uff1a\u7b2c\u3010" + (i + 1) + "\u3011\u884c\uff0c\u5206\u7c7b\u3001\u6d88\u8d39\u8005\u961f\u5217\u540d\u3001\u5e76\u53d1\u6570\u6216\u6d88\u8d39\u8005\u5904\u7406\u7c7b\u4e3a\u7a7a\uff01"));
                    SysUtil.abort();
                }
                if (!threadCount.toString().matches(THREAD_COUNT_REG)) {
                    MsgBox.showInfo((String)("\u6d88\u8d39\u8005\u961f\u5217\uff1a\u7b2c\u3010" + (i + 1) + "\u3011\u884c\uff0c\u5e76\u53d1\u6570\u4e3a1-100\u4e4b\u95f4\u7684\u6570\u5b57\uff01"));
                    SysUtil.abort();
                }
                if (!StringUtils.isEmpty((String)(validateMsg = this.validateClassLegal(dealClass.toString())))) {
                    String errMsg = "\u6d88\u8d39\u8005\u961f\u5217\uff1a\u7b2c\u3010" + (i + 1) + "\u3011\u884c\uff0c" + validateMsg;
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)("\u8ba2\u9605\u961f\u5217\uff1a\u7b2c\u3010" + (i + 1) + "\u3011\u884c,\u6d88\u8d39\u8005\u5904\u7406\u7c7b\u6709\u8bef\uff01"), (String)errMsg, (int)1);
                    SysUtil.abort();
                }
                IERPConsumerQueue q = new IERPConsumerQueue();
                q.setQueueName(queue.toString());
                q.setRegion(region.toString());
                q.setTag(tag);
                if (null != row.getCell("id") && null != row.getCell("id").getValue()) {
                    ids.add(row.getCell("id").getValue().toString());
                }
                queues.add(q);
            }
        }
        catch (BOSException e) {
            MsgBox.showError((String)"\u6821\u9a8c\u961f\u5217\u4fe1\u606f\u5f02\u5e38\uff01", (String)e.getMessage());
            SysUtil.abort();
        }
        return this.checkQueueRepeat(queues, ids);
    }

    private boolean checkQueueRepeat(List<IERPConsumerQueue> queues, List<String> ids) {
        String real1 = null;
        String real2 = null;
        String userName = this.userNamer.getText();
        String pwd = this.userPwd.getText();
        StringBuilder err = new StringBuilder();
        for (int i = 0; i < queues.size(); ++i) {
            IERPConsumerQueue q1 = queues.get(i);
            real1 = QueueManager.getRealQueueName(userName, pwd, q1.getRegion(), q1.getQueueName(), false, q1.getTag());
            for (int j = i + 1; j < queues.size(); ++j) {
                IERPConsumerQueue q2 = queues.get(j);
                real2 = QueueManager.getRealQueueName(userName, pwd, q2.getRegion(), q2.getQueueName(), false, q2.getTag());
                if (!real1.equals(real2)) continue;
                err.append("\u961f\u5217\u5206\u7c7b\uff1a\u3010" + q1.getRegion() + "\u3011\uff0c\u961f\u5217\u540d\u79f0\uff1a\u3010" + q1.getQueueName() + "\u3011").append("\r\n");
            }
        }
        if (err.length() != 0 && 1 == MsgBox.showConfirm2New((Component)((Object)this), (String)("\u751f\u4ea7\u8005\u3001\u6d88\u8d39\u8005\u961f\u5217\u91cd\u590d\uff01" + err.toString() + "\uff0c\u662f\u5426\u9700\u8981\u7ee7\u7eed\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c?"))) {
            return false;
        }
        return this.checkDbQueuesRepeat(queues, ids);
    }

    private ConnectionEntity generateConnetion() {
        RabbitTreeInfo server = (RabbitTreeInfo)this.tree.getValue();
        this.mqConnection = new ConnectionEntity();
        this.mqConnection.setHost(server.getIp());
        this.mqConnection.setPort(server.getPort());
        this.mqConnection.setUserName(this.userNamer.getText());
        this.mqConnection.setPassword(this.userPwd.getText());
        this.mqConnection.setVhost(this.vhost.getText());
        return this.mqConnection;
    }

    private String validateClassLegal(String clazz) throws BOSException {
        if (!StringUtils.isEmpty((String)clazz)) {
            clazz = clazz.trim();
            String tempClazz = clazz.replaceAll("\\.", "/") + ".class";
            String script = "com.kingdee.bos.dao.xml.impl.MDLoader.getInstance().cl.getResource(\"" + tempClazz + "\")";
            Object rst = null;
            try {
                IRunScriptFacade facade = RunScriptFacadeFactory.getRemoteInstance();
                rst = facade.runScript(script);
                if (null == rst) {
                    return "\u5904\u7406\u7c7b\uff1a\u3010" + clazz + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u670d\u52a1\u5668\u4e2d\u90e8\u7f72\u5bf9\u5e94\u7684\u5305\u3002";
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u67e5\u8be2\u7528\u6237\u586b\u5199\u5904\u7406\u65f6\u5f02\u5e38\uff01", (Throwable)e);
                throw new BOSException("\u6821\u9a8c\u6570\u636e\u5904\u7406\u7c7b\u662f\u5426\u5b58\u5728\u65f6\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
            try {
                RabbitFacadeFactory.getRemoteInstance().validateClassLegal(clazz);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    public boolean checkDbQueuesRepeat(List<IERPConsumerQueue> queues, List<String> ids) {
        ArrayList<String> tempQueues = new ArrayList<String>();
        try {
            String tag = this.tag.getText();
            String uVhost = this.vhost.getText();
            if (StringUtils.isEmpty((String)uVhost)) {
                uVhost = "%2F";
            }
            if (this.mqConnection == null) {
                this.mqConnection = this.generateConnetion();
            }
            RabbitCollection rabbit = RabbitFactory.getRemoteInstance().getRabbitCollection();
            Iterator it = rabbit.iterator();
            String realQueue = null;
            String tempQueue = null;
            while (it.hasNext()) {
                RabbitInfo rInfo = (RabbitInfo)it.next();
                String userName = rInfo.getUserName();
                String pwd = rInfo.getPassword();
                String vhost = rInfo.getVhost();
                if (StringUtils.isEmpty((String)vhost)) {
                    vhost = "%2F";
                }
                RabbitConsumerCollection conCol = rInfo.getConsumers();
                RabbitPublishCollection pubCol = rInfo.getPublishers();
                Iterator cIt = conCol.iterator();
                while (cIt.hasNext()) {
                    RabbitConsumerInfo tempCons = (RabbitConsumerInfo)cIt.next();
                    tempQueue = vhost + "_" + QueueManager.getRealQueueName(userName, pwd, tempCons.getRegion(), tempCons.getQueue(), false, rInfo.getTag());
                    if (ids.contains(tempCons.getId().toString())) continue;
                    tempQueues.add(tempQueue);
                }
                Iterator pIt = pubCol.iterator();
                while (pIt.hasNext()) {
                    RabbitPublishInfo tempPubs = (RabbitPublishInfo)pIt.next();
                    tempQueue = vhost + "_" + QueueManager.getRealQueueName(userName, pwd, tempPubs.getRegion(), tempPubs.getQueue(), false, rInfo.getTag());
                    if (ids.contains(tempPubs.getId().toString())) continue;
                    tempQueues.add(tempQueue);
                }
            }
            for (IERPConsumerQueue q : queues) {
                realQueue = uVhost + "_" + QueueManager.getRealQueueName(this.mqConnection.getUserName(), this.mqConnection.getPassword(), q.getRegion(), q.getQueueName(), false, tag);
                if (!tempQueues.contains(realQueue) || 1 != MsgBox.showConfirm2New((Component)((Object)this), (String)("\u5f53\u524d\u961f\u5217\u5206\u7c7b\uff1a\u3010" + q.getRegion() + "\u3011\uff0c\u961f\u5217\u540d\u79f0\uff1a\u3010" + q.getQueueName() + "\u3011\u4e0e\u6570\u636e\u5e93\u4e2d\u961f\u5217\u91cd\u590d\uff0c\u662f\u5426\u9700\u8981\u7ee7\u7eed\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c?"))) continue;
                return false;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u6240\u4fdd\u5b58\u7684\u961f\u5217\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            MsgBox.showError((String)"\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u6240\u4fdd\u5b58\u7684\u961f\u5217\u4fe1\u606f\u5f02\u5e38\uff01", (String)ThrowableHelper.toString((Exception)((Object)e)));
            SysUtil.abort();
        }
        return true;
    }

    public void handUIException(Throwable ex) {
        if (!(ex instanceof AbortException)) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)ex.getMessage(), (String)ThrowableHelper.toString((Throwable)ex), (int)0);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionCopy_actionPerformed(e);
        this.preset.setSelected(false);
        int j = this.kdtPublish.getRowCount();
        for (i = 0; i < j; ++i) {
            this.kdtPublish.getRow(i).getCell("ispreset").setValue((Object)false);
        }
        j = this.kdtConsumer.getRowCount();
        for (i = 0; i < j; ++i) {
            this.kdtConsumer.getRow(i).getCell("ispreset").setValue((Object)false);
        }
    }

    public void validateTag() throws EASBizException, BOSException {
        if (this.editData.getId() != null) {
            String tag = this.tag.getText();
            RabbitInfo info = RabbitFactory.getRemoteInstance().getRabbitInfo("where id='" + this.editData.getId().toString() + "'");
            String tempTag = info.getTag();
            if (!StringUtils.isEmpty((String)tag) && !tag.equals(tempTag) || !StringUtils.isEmpty((String)tempTag) && !tempTag.equals(tag)) {
                List list = RabbitFacadeFactory.getRemoteInstance().getDetailByRabbit(this.editData.getId().toString());
                for (QueueDetailInfo detail : list) {
                    if (null == detail.getReadySize() || 0 == detail.getReadySize()) continue;
                    MsgBox.showInfo((String)("\u5f53\u524d\u961f\u5217\r\n[" + detail.getQueue() + "]\r\n\u8fd8\u5b58\u5728\u672a\u88ab\u6d88\u8d39\u7684\u6570\u636e\uff0c\u961f\u5217Tag\u4e0d\u5141\u8bb8\u88ab\u4fee\u6539\uff01"));
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RabbitFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        RabbitInfo objectValue = new RabbitInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }
}

