/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rabbitmq.rabbit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.util.RabbitMQCacheUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.rabbitmq.rabbit.RabbitFacadeFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitTreeFactory;
import com.kingdee.eas.rabbitmq.rabbit.client.AbstractRabbitListUI;
import com.kingdee.eas.rabbitmq.rabbit.client.RabbitFirstTreeEditUI;
import com.kingdee.eas.rabbitmq.rabbit.client.RabbitMidTreeEditUI;
import com.kingdee.eas.rabbitmq.rabbit.common.QueueBasicInfo;
import com.kingdee.eas.rabbitmq.rabbit.common.QueueDetailInfo;
import com.kingdee.eas.rabbitmq.rabbit.common.QueueTypeEnum;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class RabbitListUI
extends AbstractRabbitListUI {
    private static final Logger logger = CoreUIObject.getLogger(RabbitListUI.class);
    private String actionName = null;
    private int currenteSelectedRow;
    private static Map<String, String> queueVhost = new HashMap<String, String>();

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!StringUtils.isEmpty(RabbitFacadeFactory.getRemoteInstance().getRabbitSystemTag())) {
            System.setProperty("mq.debug.queue.tag", RabbitFacadeFactory.getRemoteInstance().getRabbitSystemTag());
        }
        final KDTable kdtMergeEntryTable = this.tblMain;
        kdtMergeEntryTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent selectEvent) {
                KDTSelectBlock preBolck = selectEvent.getPrevSelectBlock();
                if (preBolck == null) {
                    RabbitListUI.this.currenteSelectedRow = 0;
                    RabbitListUI.this.kdtConsumer.removeRows();
                    RabbitListUI.this.kdtPublish.removeRows();
                } else {
                    RabbitListUI.this.currenteSelectedRow = selectEvent.getSelectBlock().getBeginRow();
                }
                IRow row = RabbitListUI.this.currentTabSelectRow(kdtMergeEntryTable);
                final String id = row.getCell("id").getValue().toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RabbitListUI.this.kdtConsumer.removeRows();
                            Map queueMap = RabbitFacadeFactory.getRemoteInstance().getAllQueues(id);
                            List queueList = (List)queueMap.get(QueueTypeEnum.Consumer);
                            Iterator conIte = queueList.iterator();
                            QueueBasicInfo consumer = null;
                            while (conIte.hasNext()) {
                                consumer = (QueueBasicInfo)conIte.next();
                                IRow consumerRow = RabbitListUI.this.kdtConsumer.addRow();
                                consumerRow.getCell("queue").setValue((Object)consumer.getQueue());
                                consumerRow.getCell("iscallback").setValue((Object)consumer.isCallBack());
                                consumerRow.getCell("threadcount").setValue((Object)consumer.getThreadCount());
                                consumerRow.getCell("ispreset").setValue((Object)consumer.isPreset());
                            }
                            RabbitListUI.this.kdtPublish.removeRows();
                            List publishList = (List)queueMap.get(QueueTypeEnum.Publish);
                            Iterator puIte = publishList.iterator();
                            QueueBasicInfo publish = null;
                            while (puIte.hasNext()) {
                                publish = (QueueBasicInfo)puIte.next();
                                IRow publishRow = RabbitListUI.this.kdtPublish.addRow();
                                publishRow.getCell("queue").setValue((Object)publish.getQueue());
                                publishRow.getCell("isautoscribe").setValue((Object)publish.isCallBack());
                                publishRow.getCell("ispreset").setValue((Object)publish.isPreset());
                            }
                        }
                        catch (BOSException e) {
                            MsgBox.showError((String)"\u67e5\u8be2\u5bf9\u5e94\u8ba2\u9605\u5217\u8868\u5f02\u5e38", (String)ThrowableHelper.toString((Exception)((Object)e)));
                            SysUtil.abort();
                        }
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RabbitListUI.this.kdtMonitor.removeRows();
                            List detailList = RabbitFacadeFactory.getRemoteInstance().getDetailByRabbit(id);
                            String[] consumerIPs = null;
                            List<String[]> list = null;
                            for (QueueDetailInfo detail : detailList) {
                                list = detail.getConsumerIPList();
                                for (int i = 0; i < list.size(); ++i) {
                                    consumerIPs = list.get(i);
                                    IRow monitorRow = RabbitListUI.this.kdtMonitor.addRow();
                                    monitorRow.getCell("qualifiedqueue").setValue((Object)detail.getQueue());
                                    monitorRow.getCell("consumercount").setValue((Object)detail.getConsumerCount());
                                    monitorRow.getCell("totalmsg").setValue((Object)detail.getTotalSize());
                                    monitorRow.getCell("msgbodybytes").setValue((Object)detail.getTotalBytes());
                                    monitorRow.getCell("readymsg").setValue((Object)detail.getReadySize());
                                    monitorRow.getCell("unacked").setValue((Object)detail.getUnackedSize());
                                    monitorRow.getCell("qualifiedqueue").setValue((Object)detail.getQueue());
                                    monitorRow.getCell("queuefeatures").setValue((Object)detail.getParameters());
                                    monitorRow.getCell("consumerdetail").setValue((Object)consumerIPs[0]);
                                    monitorRow.getCell("consumerport").setValue((Object)consumerIPs[1]);
                                    monitorRow.getCell("ipcount").setValue((Object)consumerIPs[2]);
                                }
                                if (list.size() != 0) continue;
                                IRow monitorRow = RabbitListUI.this.kdtMonitor.addRow();
                                monitorRow.getCell("qualifiedqueue").setValue((Object)detail.getQueue());
                                monitorRow.getCell("consumercount").setValue((Object)detail.getConsumerCount());
                                monitorRow.getCell("totalmsg").setValue((Object)detail.getTotalSize());
                                monitorRow.getCell("msgbodybytes").setValue((Object)detail.getTotalBytes());
                                monitorRow.getCell("readymsg").setValue((Object)detail.getReadySize());
                                monitorRow.getCell("unacked").setValue((Object)detail.getUnackedSize());
                                monitorRow.getCell("qualifiedqueue").setValue((Object)detail.getQueue());
                                monitorRow.getCell("queuefeatures").setValue((Object)detail.getParameters());
                            }
                            RabbitListUI.this.kdtRePaint();
                        }
                        catch (BOSException e) {
                            MsgBox.showError((String)"\u67e5\u8be2\u5bf9\u5e94\u8ba2\u9605\u5217\u8868\u5f02\u5e38", (String)ThrowableHelper.toString((Exception)((Object)e)));
                            SysUtil.abort();
                        }
                    }
                });
            }
        });
        if (kdtMergeEntryTable.getRowCount() > 0) {
            KDTableUtil.setSelectedRow((KDTable)kdtMergeEntryTable, (int)0);
            this.currenteSelectedRow = 0;
        }
    }

    private void kdtRePaint() {
        this.kdtMonitor.setRefresh(true);
        this.kdtMonitor.enableRepaint(true);
        this.kdtMonitor.reLayoutAndPaint();
    }

    private IRow currentTabSelectRow(KDTable kdtMergeEntryTable) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)kdtMergeEntryTable);
        int selectIndex = -1;
        if (selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        IRow row = kdtMergeEntryTable.getRow(selectIndex);
        return row;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.delCloseChannels(this.kdtConsumer);
        this.delCloseChannels(this.kdtPublish);
        super.actionRemove_actionPerformed(e);
        this.kdtPublish.removeRows();
        this.kdtConsumer.removeRows();
        this.kdtMonitor.removeRows();
    }

    private void delCloseChannels(KDTable kdt) {
        int rowCount = kdt.getRowCount();
        Object queue = null;
        String realQueue = null;
        List<Channel> channels = null;
        String vhost = null;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = kdt.getRow(i);
            queue = row.getCell("queue").getValue();
            if (null == queue) continue;
            realQueue = queue.toString();
            if (queueVhost.containsKey(realQueue)) {
                vhost = queueVhost.get(realQueue);
                realQueue = vhost + "_" + realQueue;
            }
            if (null == (channels = RabbitMQCacheUtils.takeChanel(realQueue)) || channels.isEmpty()) continue;
            try {
                for (Channel c : channels) {
                    c.close();
                }
            }
            catch (Throwable t) {
                MsgBox.showError((String)("\u6267\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u961f\u5217\u3010" + realQueue + "\u3011\u5f02\u5e38"), (String)ThrowableHelper.toString((Throwable)t));
                SysUtil.abort();
            }
            RabbitMQCacheUtils.removeChannel(realQueue);
            if (!queueVhost.containsKey(realQueue)) continue;
            queueVhost.remove(realQueue);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        if (super.getSelectedTreeNode() == null) {
            return;
        }
        if (super.getSelectedTreeNode().getParent() == null) {
            this.btnGroupRemove.setEnabled(false);
            this.btnGroupMoveTree.setEnabled(false);
            this.btnAddNew.setEnabled(false);
        } else {
            this.btnAddNew.setEnabled(true);
            this.btnGroupAddNew.setEnabled(true);
            this.btnGroupRemove.setEnabled(true);
            this.btnGroupView.setEnabled(true);
            this.btnGroupAddNew.setEnabled(true);
        }
        int tblMainCount = this.tblMain.getRowCount();
        if (tblMainCount == 0) {
            this.kdtConsumer.removeRows();
            this.kdtPublish.removeRows();
            this.kdtMonitor.removeRows();
        }
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (e.getSource() instanceof JMenuItem) {
            this.actionName = ((JMenuItem)e.getSource()).getName();
        } else if (e.getSource() instanceof KDWorkButton) {
            this.actionName = ((KDWorkButton)e.getSource()).getName();
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        this.actionName = ((KDWorkButton)e.getSource()).getName();
        super.actionGroupView_actionPerformed(e);
    }

    public void handUIException(Throwable ex) {
        if (!(ex instanceof AbortException)) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)ex.getMessage(), (String)ThrowableHelper.toString((Throwable)ex), (int)0);
        }
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        this.actionName = ((KDWorkButton)e.getSource()).getName();
        super.actionGroupEdit_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.actionName = ((KDWorkButton)e.getSource()).getName();
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        this.actionName = ((KDWorkButton)e.getSource()).getName();
        super.actionGroupMoveTree_actionPerformed(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        this.actionName = ((KDWorkButton)e.getSource()).getName();
        super.actionMoveTree_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RabbitFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return RabbitTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        KDTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode.isRoot()) {
            return RabbitFirstTreeEditUI.class.getName();
        }
        if (selectedNode.getLevel() == 1) {
            if ("btnGroupView".equals(this.actionName) || "btnGroupEdit".equals(this.actionName)) {
                return RabbitFirstTreeEditUI.class.getName();
            }
            return RabbitMidTreeEditUI.class.getName();
        }
        return RabbitMidTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return "\u6d88\u606f\u4e2d\u95f4\u4ef6";
    }

    @Override
    protected IObjectValue createNewData() {
        RabbitInfo objectValue = new RabbitInfo();
        return objectValue;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }
}

