/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.AllUsersAttachmentViewFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.client.AbstractAllUsersAttachmentViewUI;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.UserEditUI;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AllUsersAttachmentViewUI
extends AbstractAllUsersAttachmentViewUI {
    private static final Logger logger = CoreUIObject.getLogger(AllUsersAttachmentViewUI.class);

    public void onLoad() throws Exception {
        this.initButton();
        super.onLoad();
        this.initCtrl();
    }

    private void initCtrl() {
        String dateFormat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(dateFormat);
        this.tblMain.getColumn("invalidationDate").getStyleAttributes().setNumberFormat(dateFormat);
        this.tblMain.getColumn("PWEffectiveDate").getStyleAttributes().setNumberFormat(dateFormat);
    }

    private void initButton() {
        this.btnAddNew.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnView.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnDelUser.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select fuseridid from T_BAS_AllUsersAttachmentView");
        filter.getFilterItems().add(new FilterItemInfo("User.id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionAddNewUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewUser_actionPerformed(e);
        KDCommonPromptDialog dlg = this.getUserDialog();
        dlg.show();
        if (!dlg.isCanceled()) {
            Object data = dlg.getData();
            Object[] userInfos = (Object[])data;
            UserCollection userCollection = new UserCollection();
            for (int i = 0; i < userInfos.length; ++i) {
                userCollection.add((UserInfo)userInfos[i]);
            }
            String logDetail = "\u8bbe\u7f6e\u7528\u6237\uff1a" + this.getLogInfo(userCollection) + " \u53ef\u4ee5\u67e5\u770b\u6240\u6709\u4eba\u9644\u4ef6";
            IObjectPK logPK = LogUtil.beginLog(null, (String)"actionAddNewUser", (BOSObjectType)new AttachmentInfo().getBOSType(), null, (String)logDetail, (String)"manual_default_logitem");
            AllUsersAttachmentViewFactory.getRemoteInstance().saveAllUsersAttachView(userCollection);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            this.refresh(e);
        }
    }

    private String getLogInfo(UserCollection userCollection) {
        String logName = "";
        for (int i = 0; i < userCollection.size(); ++i) {
            UserInfo userInfo = userCollection.get(i);
            logName = i == userCollection.size() - 1 ? logName + userInfo.getNumber() + "--" + userInfo.getName() : logName + userInfo.getNumber() + "--" + userInfo.getName() + "\uff0c";
        }
        return logName;
    }

    private KDCommonPromptDialog getUserDialog() {
        UserPromptBox dlg = new UserPromptBox();
        IUIWindow win = this.getUIWindow();
        if (win instanceof Frame) {
            dlg = new UserPromptBox((Frame)this.getUIWindow());
        } else if (win instanceof Dialog) {
            dlg = new UserPromptBox((Dialog)this.getUIWindow());
        }
        dlg.setEnabledMultiSelection(true);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.UserListQuery");
        dlg.setQueryInfo(queryPK);
        dlg.getUIConetxt().put("mergeUserRangeFilter", false);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select fuseridid from T_BAS_AllUsersAttachmentView");
        filterInfo.getFilterItems().add(new FilterItemInfo("User.id", (Object)sql.toString(), CompareType.NOTINNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        dlg.setEntityViewInfo(entityViewInfo);
        dlg.setHasCUDefaultFilter(false);
        return dlg;
    }

    @Override
    public void actionDelUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelUser_actionPerformed(e);
        this.checkSelected();
        this.processDelUserFromAllUsersView();
        this.refresh(e);
    }

    private void processDelUserFromAllUsersView() throws EASBizException, BOSException {
        ArrayList<String> delUserList = new ArrayList<String>();
        String userNames = "";
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object userIdObj = this.tblMain.getRow(j).getCell("id").getValue();
                Object numberObj = this.tblMain.getRow(j).getCell("number").getValue();
                delUserList.add(userIdObj.toString());
                Object userNameObj = this.tblMain.getRow(j).getCell(3).getValue();
                if (userNameObj == null) continue;
                userNames = userNames + numberObj + "--" + userNameObj.toString() + ",";
            }
        }
        String logDetail = "\u5220\u9664\u7528\u6237\uff1a" + userNames + " \u67e5\u770b\u6240\u6709\u4eba\u9644\u4ef6\u7684\u6743\u9650";
        IObjectPK logPK = LogUtil.beginLog(null, (String)"actionAddNewUser", (BOSObjectType)new AttachmentInfo().getBOSType(), null, (String)logDetail, (String)"manual_default_logitem");
        String idList = StringUtils.arrayToString((Object[])delUserList.toArray(), (String)",");
        AllUsersAttachmentViewFactory.getRemoteInstance().deleteAllUsersAttachView(idList);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    protected String getEditUIName() {
        return UserEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }
}

