/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.TextLengthVerifier;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.client.AbstractAttachmentAddUI;
import com.kingdee.eas.base.attachment.client.FileInfo;
import com.kingdee.eas.base.attachment.client.NewF7Box;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class AttachmentAddUI
extends AbstractAttachmentAddUI {
    Logger logger = Logger.getLogger("com.kingdee.eas.base.attachment.client.AttachmentAddUI");
    private KDBizPromptBox f7;
    private NewF7Box nf7;
    private String boID;

    public AttachmentAddUI() throws Exception {
        this.initCtrls();
    }

    private void initCtrls() {
        this.setUITitle(Resrcs.getString("AddUITitle"));
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.f7 = new KDBizPromptBox();
        this.f7.setQueryInfo("com.kingdee.eas.base.attachment.app.F7AttachmentQuery");
        this.f7.setSelectorCollection(AttachmentHelper.getSelectorItemCollection());
        this.f7.setDisplayFormat("$name$");
        this.f7.setEditable(false);
        this.f7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object o = eventObj.getNewValue();
                if (o == null) {
                    return;
                }
                AttachmentInfo ai = (AttachmentInfo)o;
                if (StringUtils.isEmpty((String)ai.getName())) {
                    return;
                }
                AttachmentAddUI.this.setDataObject((IObjectValue)ai);
                AttachmentAddUI.this.loadFields2();
            }
        });
        this.nf7 = new NewF7Box((Component)((Object)this));
        this.nf7.setDisplayFormat("$name$");
        this.nf7.setEditable(true);
        this.nf7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object o = eventObj.getNewValue();
                if (o == null) {
                    return;
                }
                FileInfo fi = (FileInfo)o;
                String name = fi.getName().trim();
                if (StringUtils.isEmpty((String)name)) {
                    return;
                }
                AttachmentAddUI.this.txtType.setText(StringUtil4File.getFileTypeDescription(fi.getType()));
                AttachmentAddUI.this.txtSize.setText(StringUtil4File.getFileSizeRepresentation(fi.getFile().length()));
            }
        });
        JTextField nf7tf = (JTextField)this.nf7.getEditor();
        TextLengthVerifier tlv = new TextLengthVerifier();
        tlv.setMaxLength(100);
        nf7tf.setInputVerifier((InputVerifier)tlv);
        this.lcNF7.setBoundEditor((JComponent)((Object)this.nf7));
        this.lcF7.setBoundEditor((JComponent)this.f7);
        String newAttachment = Resrcs.getString("NewAttachment");
        String existedAttachment = Resrcs.getString("ExistedAttachment");
        this.cmbAssoType.addItem((Object)newAttachment);
        this.cmbAssoType.addItem((Object)existedAttachment);
        this.cmbAssoType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    int idx = ((KDComboBox)ie.getSource()).getSelectedIndex();
                    if (idx == 0) {
                        AttachmentAddUI.this.lcNF7.setVisible(true);
                        AttachmentAddUI.this.lcF7.setVisible(false);
                        AttachmentAddUI.this.kDCheckBox1.setEnabled(true);
                        AttachmentAddUI.this.taDescription.setEditable(true);
                    } else {
                        AttachmentAddUI.this.lcNF7.setVisible(false);
                        AttachmentAddUI.this.lcF7.setVisible(true);
                        AttachmentAddUI.this.kDCheckBox1.setEnabled(false);
                        AttachmentAddUI.this.taDescription.setEditable(false);
                    }
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this.logger.info("UIContext id is:" + this.getUIContext().get("ID") + " initData is:" + this.getUIContext().get("InitDataObject"));
        super.onLoad();
        String theBoID = this.getBoID();
        String boType = "";
        boType = theBoID != null && !theBoID.trim().equals("") ? theBoID.substring(theBoID.length() - 8) : "*";
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("isShared", (Object)1, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("name", null, CompareType.NOTEQUALS));
        evi.setFilter(fi);
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("boAttchAsso.boID", (Object)("%" + boType), CompareType.LIKE));
        if (!this.getExtraCode().equals("")) {
            fic.add(new FilterItemInfo("number", (Object)this.getExtraCode(), CompareType.EQUALS));
        }
        this.f7.setEntityViewInfo(evi);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.cmbAssoType.setSelectedIndex(0);
        this.lcNF7.setVisible(true);
        this.lcF7.setVisible(false);
        this.nf7.setData(new FileInfo());
        this.f7.setData((Object)new AttachmentInfo());
        this.txtCreator.setText(SysContext.getSysContext().getCurrentUserInfo().getName());
        this.txtUpdator.setText(this.txtCreator.getText());
    }

    private void loadFields2() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        String theName = "";
        theName = this.cmbAssoType.getSelectedIndex() == 0 ? ((FileInfo)this.nf7.getData()).getName() : ((AttachmentInfo)this.f7.getData()).getName();
        if (StringUtils.isEmpty((String)theName)) {
            return;
        }
        try {
            if (this.cmbAssoType.getSelectedIndex() == 0) {
                FileInfo fi = (FileInfo)this.nf7.getData();
                this.editData.setFile(FileGetter.getBytesFromFile(fi.getFile()));
                this.editData.setName(this.nf7.getText().trim());
                this.editData.setSimpleName(fi.getType());
                this.editData.setSizeInByte(new Long(fi.getFile().length()).intValue());
                this.editData.setNumber(this.getExtraCode());
                if (this.kDCheckBox1.isSelected()) {
                    this.editData.setSharedDesc(EASResource.getString((String)"yes"));
                } else {
                    this.editData.setSharedDesc(EASResource.getString((String)"no"));
                }
            }
            if (this.editData.getId() == null || !this.getIBAA().isAssociationExisted(this.getBoID(), this.editData.getId().toString())) {
                BoAttchAssoInfo baai = new BoAttchAssoInfo();
                baai.setBoID(this.getBoID());
                baai.setAssoType((String)this.cmbAssoType.getSelectedItem());
                this.editData.getBoAttchAsso().add(baai);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected IObjectValue createNewData() {
        AttachmentInfo ai = new AttachmentInfo();
        ai.setName("");
        ai.setSimpleName("");
        return ai;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AttachmentFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String theName = "";
        if (this.cmbAssoType.getSelectedIndex() == 0) {
            FileInfo fi = (FileInfo)this.nf7.getData();
            theName = fi.getName();
        } else {
            AttachmentInfo ai = (AttachmentInfo)this.f7.getData();
            theName = ai.getName();
        }
        if (theName == null || theName.equals("")) {
            MsgBox.showInfo((String)Resrcs.getString("FileNotSet"));
            return;
        }
        if (this.cmbAssoType.getSelectedIndex() == 0) {
            theName = this.nf7.getText().trim();
            try {
                StringUtil4File.checkInvalidCharsInFileName(theName);
            }
            catch (AttachmentException ae) {
                ExceptionHandler.handle((Throwable)((Object)ae));
                return;
            }
        }
        if (this.cmbAssoType.getSelectedIndex() == 0) {
            if (((IAttachment)this.getBizInterface()).isFileNameExisted(this.getBoID(), theName)) {
                if (MsgBox.showConfirm2((String)MessageFormat.format(Resrcs.getString("FileNameExisted"), theName)) == 2) {
                    return;
                }
                String attchID = ((IAttachment)this.getBizInterface()).getAttchIDByFileName(this.getBoID(), theName);
                AttachmentInfo ai = (AttachmentInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(attchID), AttachmentHelper.getSelectorItemCollection());
                this.setDataObject((IObjectValue)ai);
                this.loadFields2();
            }
        } else if (this.getIBAA().isAssociationExisted(this.getBoID(), this.editData.getId().toString())) {
            MsgBox.showInfo((String)Resrcs.getString("AssociationExisted"));
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }

    private IBoAttchAsso getIBAA() throws Exception {
        return BoAttchAssoFactory.getRemoteInstance();
    }

    private String getBoID() {
        if (this.boID == null) {
            this.boID = (String)this.getUIContext().get("boID");
            if (this.boID != null) {
                this.boID = this.boID.trim();
            }
        }
        return this.boID;
    }

    private String getExtraCode() {
        Object o = this.getUIContext().get("code");
        if (o == null) {
            return "";
        }
        String code = (String)o;
        return code;
    }
}

