/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentPermissionCollection;
import com.kingdee.eas.base.attachment.AttachmentPermissionFactory;
import com.kingdee.eas.base.attachment.AttachmentPermissionInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentPermission;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.client.AbstractAttachmentEditUI;
import com.kingdee.eas.base.attachment.util.AttachmentSelectUtils;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.Sout;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AttachmentEditUI
extends AbstractAttachmentEditUI {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.client.AttachmentEditUI");
    private String boID;
    private String boNumber = "";
    private String boAndNum;

    public AttachmentEditUI() throws Exception {
        this.initCtrls();
    }

    private void initCtrls() {
        this.cbType.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.kDDatePicker1.setEnabled(false);
        this.kDDatePicker2.setEnabled(false);
    }

    @Override
    public void loadFields() {
        String boAttachid = (String)this.getUIContext().get("boattachAssoId");
        String attachId = (String)this.getUIContext().get("attachId");
        if (this.editData.getName().equals("")) {
            return;
        }
        super.loadFields();
        try {
            AttachmentInfo ai;
            this.editData = ai = AttachmentFactory.getRemoteInstance().getAttachmentInfo("select * where id = '" + this.editData.getId().toString() + "'");
            this.setDataObject((IObjectValue)this.editData);
            IAttachmentPermission iap = AttachmentPermissionFactory.getRemoteInstance();
            this.cbType.removeAllItems();
            if (ai != null && this.getOprtState().equals(OprtState.VIEW)) {
                if (StringUtils.isEmpty((String)ai.getPermission())) {
                    this.cbType.addItem((Object)"");
                } else {
                    AttachmentPermissionInfo info = iap.getAttachmentPermissionInfo("select * where id = '" + ai.getPermission() + "'");
                    this.cbType.addItem((Object)info);
                }
            } else if (ai != null && this.getOprtState().equals(OprtState.EDIT)) {
                this.cbType.addItem((Object)"");
                AttachmentPermissionCollection col = AttachmentSelectUtils.init().getItem(ai, boAttachid);
                if (col != null && col.size() > 0) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int i = 0; i < col.size(); ++i) {
                        AttachmentPermissionInfo attachmentInfo = col.get(i);
                        this.cbType.addItem((Object)attachmentInfo);
                        map.put(attachmentInfo.getId().toString(), String.valueOf(i + 1));
                    }
                    if (StringUtils.isEmpty((String)ai.getPermission())) {
                        this.cbType.setSelectedItem((Object)"");
                    } else if (!StringUtils.isEmpty((String)ai.getPermission()) && map != null) {
                        AttachmentPermissionInfo info = iap.getAttachmentPermissionInfo("select * where id = '" + ai.getPermission() + "'");
                        Object ob = map.get(info.getId().toString());
                        if (ob != null) {
                            String attachmentInfoNum = ob.toString();
                            if (!StringUtils.isEmpty((String)attachmentInfoNum)) {
                                this.cbType.setSelectedIndex(Integer.parseInt(attachmentInfoNum));
                            }
                        } else {
                            this.cbType.setSelectedItem((Object)"");
                        }
                    } else {
                        this.cbType.setSelectedItem((Object)"");
                    }
                } else {
                    this.cbType.setSelectedItem((Object)"");
                }
            }
            Map boAndNumMap = BoAttchAssoFactory.getRemoteInstance().getBoIDBosTypeByAttchID(attachId);
            for (String boName : boAndNumMap.keySet()) {
                List boNumList = (List)boAndNumMap.get(boName);
                for (int i = 0; i < boNumList.size(); ++i) {
                    this.boNumber = this.boNumber + (String)boNumList.get(i) + " , ";
                }
                this.boNumber = this.boNumber.replaceAll(" , $", "");
                this.boAndNum = this.boAndNum == null ? boName + " : " + this.boNumber : boName + " : " + this.boNumber + "\n" + this.boAndNum;
                this.boNumber = "";
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        AttachmentInfo ai = new AttachmentInfo();
        ai.setName("");
        return ai;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AttachmentFactory.getRemoteInstance();
    }

    private String getBoID() {
        if (this.boID == null) {
            this.boID = ((String)this.getUIContext().get("boID")).trim();
        }
        return this.boID;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.cbType.setEnabled(false);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.kDDatePicker1.setValue((Object)this.editData.getCreateTime());
            this.kDDatePicker1.setEnabled(false);
            this.kDDatePicker2.setValue((Object)this.editData.getLastUpdateTime());
            this.kDDatePicker2.setEnabled(false);
            this.setUITitle(Resrcs.getString("View"));
            this.btnSubmit.setVisible(false);
            this.btnPre.setVisible(true);
            this.btnNext.setVisible(true);
            this.btnFirst.setVisible(true);
            this.btnLast.setVisible(true);
            this.menuItemAddNew.setVisible(false);
            this.menuItemSave.setVisible(false);
            this.menuItemSubmit.setVisible(false);
            this.globalShare.setEnabled(false);
            this.sameBillShareChk.setEnabled(false);
        } else {
            this.setUITitle(Resrcs.getString("Edit"));
            this.kDDatePicker1.setValue((Object)this.editData.getCreateTime());
            this.kDDatePicker1.setEnabled(false);
            this.kDDatePicker2.setValue((Object)this.editData.getLastUpdateTime());
            this.kDDatePicker2.setEnabled(false);
            this.txtName.setEnabled(true);
            this.taDescription.setEnabled(true);
            this.globalShare.setEnabled(true);
            this.menuItemAddNew.setVisible(false);
            this.menuItemSave.setVisible(false);
            this.menuItemSubmit.setVisible(true);
            if ((this.editData.isIsShared() || this.editData.isIsOnlySameBillShare()) && this.checkIsReference(this.getBoID(), this.editData.getId().toString())) {
                this.globalShare.setEnabled(false);
                this.sameBillShareChk.setEnabled(false);
            }
            this.cbType.setEnabled(true);
        }
        this.boNumberByAttach.setStringValue(this.boAndNum);
        this.boNumberByAttach.setEditable(false);
        this.globalShare.setSelected(this.editData.isIsShared());
        this.sameBillShareChk.setSelected(this.editData.isIsOnlySameBillShare());
        if (this.editData.getCreator() != null && !this.editData.getCreator().getId().equals((Object)SysContext.getSysContext().getCurrentUserInfo().getId())) {
            this.txtName.setEnabled(false);
            this.cbType.setEnabled(false);
            this.btnSubmit.setVisible(false);
            this.globalShare.setEnabled(false);
            this.sameBillShareChk.setEnabled(false);
            this.taDescription.setEnabled(false);
        }
        this.globalShare.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    AttachmentEditUI.this.kDCheckBox1_mouseClicked(e);
                }
                catch (Exception exc) {
                    AttachmentEditUI.this.handUIException(exc);
                }
            }
        });
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String theName = this.txtName.getText().trim();
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showInfo((String)Resrcs.getString("FileNameNotSet"));
            return;
        }
        try {
            StringUtil4File.checkInvalidCharsInFileName(theName);
        }
        catch (AttachmentException ae) {
            ExceptionHandler.handle((Throwable)((Object)ae));
            return;
        }
        if (!theName.equals(this.editData.getName()) && ((IAttachment)this.getBizInterface()).isFileNameExisted(this.getBoID(), theName)) {
            Sout.show(this.editData.getName());
            MsgBox.showInfo((String)MessageFormat.format(Resrcs.getString("FileNameExisted2"), theName));
            this.txtName.requestFocusInWindow();
            this.txtName.selectAll();
            return;
        }
        if (this.cbType.getSelectedItem() == null || StringUtils.isEmpty((String)this.cbType.getSelectedItem().toString())) {
            this.editData.setPermission("");
            this.txtPermissionID.setText("");
        } else if (this.cbType.getSelectedItem() != null) {
            this.editData.setPermission(((AttachmentPermissionInfo)this.cbType.getSelectedItem()).getId().toString());
            this.txtPermissionID.setText(((AttachmentPermissionInfo)this.cbType.getSelectedItem()).getId().toString());
        }
        String str = "";
        str = this.globalShare.isSelected() ? "\u662f" : "\u5426";
        this.editData.setSharedDesc(str, LocaleUtils.getLocale((String)"L2"));
        this.editData.setSharedDesc(str, LocaleUtils.getLocale((String)"L3"));
        this.editData.setIsOnlySameBillShare(this.sameBillShareChk.isSelected());
        BoAttchAssoInfo boInfo = BoAttchAssoFactory.getRemoteInstance().getBoAttchAssoInfo("select * where boID = '" + this.getBoID() + "' and attachment = '" + this.editData.getId().toString() + "'");
        String logName = this.getLogInfo(boInfo.getBoID()) + " " + theName;
        IObjectPK logPk = LogUtil.beginLog(null, (String)"update", (BOSObjectType)new AttachmentInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), (String)logName, (String)"bs_attachment_attachment_update");
        LogUtil.afterLog(null, (IObjectPK)logPk);
        super.actionSubmit_actionPerformed(e);
    }

    public IObjectPK runSubmit() throws Exception {
        Object pk;
        if (this.getBizInterface() == null) {
            throw new Exception("don't implement getBizInterface()  !");
        }
        if (UtilRequest.isPrepare((String)"ActionSubmit", (CoreUIObject)this) && (pk = ActionCache.get((Object)"Fw_ObjectPK")) != null) {
            return (IObjectPK)pk;
        }
        this.getBizInterface().update((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBaseInfo)this.editData);
        return new ObjectUuidPK(this.editData.getId());
    }

    public boolean isModify() {
        String theName = this.txtName.getText().trim();
        try {
            if (((IAttachment)this.getBizInterface()).isFileNameExisted(this.getBoID(), theName)) {
                return false;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return super.isModify();
    }

    @Override
    protected void globalShare_mouseClicked(MouseEvent e) throws Exception {
        KDCheckBox chkBox = (KDCheckBox)e.getSource();
        if (this.globalShare.isSelected() && this.sameBillShareChk.isSelected() && chkBox.getName().equals("globalShare")) {
            this.sameBillShareChk.setSelected(false);
        } else if (this.globalShare.isSelected() && this.sameBillShareChk.isSelected() && chkBox.getName().equals("sameBillShareChk")) {
            this.globalShare.setSelected(false);
            this.cbType.setEnabled(true);
        }
    }

    @Override
    protected void kDCheckBox1_mouseClicked(MouseEvent e) throws Exception {
        this.globalShare_mouseClicked(e);
    }

    private boolean checkIsReference(String boId, String attachmentId) throws BOSException, EASBizException {
        if (boId == null || attachmentId == null || boId.trim().length() == 0 || attachmentId.trim().length() == 0) {
            this.logger.info((Object)"........... boId or attachmentId is null, true will be return !");
            return true;
        }
        IBoAttchAsso iBoattchAsso = BoAttchAssoFactory.getRemoteInstance();
        return iBoattchAsso.isReference(boId, attachmentId);
    }

    protected void initScrollButtons() {
        super.initScrollButtons();
        Integer temp = (Integer)this.getUIContext().get("DistinctCount");
        if (temp != null) {
            int distinctCount = temp;
            if (this.idList.getCurrentIndex() == distinctCount - 1) {
                this.actionNext.setEnabled(false);
                this.actionLast.setEnabled(false);
            }
        }
    }

    private String getLogInfo(String boId) {
        String logName = "";
        BOSUuid uuid = BOSUuid.read((String)boId);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(uuid.getType());
        IObjectValue data = null;
        try {
            DataBaseInfo info;
            if (ConfigMDUtil.isClient()) {
                data = DynamicObjectFactory.getRemoteInstance().getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            } else {
                Context ctx = ConfigMDUtil.getContext();
                data = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            }
            if (data instanceof DataBaseInfo) {
                info = (DataBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else if (data instanceof CoreBillBaseInfo) {
                info = (CoreBillBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else {
                logName = entity.getAlias() + " " + boId;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return logName;
    }
}

