/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.IAttachmentSize;
import com.kingdee.eas.base.attachment.client.AbstractAttachmentSizeEditUI;
import com.kingdee.eas.base.attachment.security.AttachmentSecurityHelper;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AttachmentSizeEditUI
extends AbstractAttachmentSizeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AttachmentSizeEditUI.class);
    String attType = null;

    public void onLoad() throws Exception {
        super.onLoad();
        IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
        double attSize = attachmentFactory.getFileSize();
        this.txtAttachmentSize.setText(String.valueOf(attSize));
        this.attType = attachmentFactory.getFileType();
        this.forbiddenFileTypeValue.setText(this.attType);
        boolean isEnableWriteEnable = attachmentFactory.IsEnableWhiteList();
        if (isEnableWriteEnable) {
            this.changeWhiteListState();
            this.radWhiteList.setSelected(true);
        } else {
            this.changeBlackListState();
            this.rdoBlackList.setSelected(true);
        }
        boolean isEncrypt = attachmentFactory.isAttachmentEncrypt();
        this.isAttachmentEncrypt.setSelected(isEncrypt);
        this.radWhiteList.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDRadioButton _radWhiteList = (KDRadioButton)e.getSource();
                try {
                    if (_radWhiteList.isSelected()) {
                        AttachmentSizeEditUI.this.changeWhiteListState();
                    }
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                }
            }
        });
        this.rdoBlackList.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDRadioButton _rdoBlackList = (KDRadioButton)e.getSource();
                try {
                    if (_rdoBlackList.isSelected()) {
                        AttachmentSizeEditUI.this.changeBlackListState();
                    }
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                }
            }
        });
        if (!Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK((BOSUuid)SysContext.getSysContext().getCurrentUserInfo().get("id")))) {
            this.txtAttachmentSize.setEnabled(false);
            this.txtBlackList.setEditable(false);
            this.txtWhiteList.setEditable(false);
            this.rdoBlackList.setEnabled(false);
            this.radWhiteList.setEnabled(false);
        }
    }

    private void changeBlackListState() throws BOSException {
        IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
        this.txtWhiteList.setVisible(false);
        this.txtBlackList.setVisible(true);
        this.txtBlackList.setText(attachmentFactory.getBlackList());
    }

    private void changeWhiteListState() throws BOSException {
        IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
        this.txtWhiteList.setVisible(true);
        this.txtBlackList.setVisible(false);
        this.txtWhiteList.setText(attachmentFactory.getWhiteList());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (!Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK((BOSUuid)SysContext.getSysContext().getCurrentUserInfo().get("id")))) {
            super.destroyWindow();
            return;
        }
        super.actionOK_actionPerformed(e);
        String fileSizeText = this.txtAttachmentSize.getText();
        String fileTypeText = this.forbiddenFileTypeValue.getText().replaceAll(" ", "");
        double fileMaxSize = 0.0;
        IAttachmentSize attachmentFactory = AttachmentSizeFactory.getRemoteInstance();
        boolean saveFlag = false;
        try {
            this.checkListISValid(attachmentFactory);
            attachmentFactory.updateFileType(fileTypeText);
            if (fileSizeText != null && !fileSizeText.equals("")) {
                if (fileSizeText.contains(",")) {
                    fileSizeText = fileSizeText.replaceAll(",", "");
                }
                if ((fileMaxSize = Double.parseDouble(fileSizeText)) <= 0.0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"zeroValue"));
                } else if (fileMaxSize > 500.0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"maxValue"));
                } else {
                    attachmentFactory.updateFileSize(fileMaxSize);
                    saveFlag = true;
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"attachmentNotNull"));
                saveFlag = false;
            }
            if (saveFlag) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"savesuccess"));
                super.destroyWindow();
            }
        }
        catch (Exception ex) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u6570\u636e\u8f93\u5165\u4e0d\u5408\u6cd5", (String)ex.getMessage(), (int)1);
        }
    }

    private void checkListISValid(IAttachmentSize attachmentFactory) throws BOSException {
        String whiteListText = this.txtWhiteList.getText();
        String blackListText = this.txtBlackList.getText();
        boolean isEnableWhiteList = this.radWhiteList.isSelected();
        if (isEnableWhiteList) {
            this.checkListIsCorrect(whiteListText);
            attachmentFactory.updateWhiteList(whiteListText, isEnableWhiteList);
        } else {
            this.checkListIsCorrect(blackListText);
            attachmentFactory.updateBlackList(blackListText, isEnableWhiteList);
        }
        if (this.isAttachmentEncrypt.getSelected() == 32) {
            attachmentFactory.updateIsAttachEncrypt(true);
        } else {
            attachmentFactory.updateIsAttachEncrypt(false);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        super.destroyWindow();
    }

    private void checkListIsCorrect(String pattern) throws BOSException {
        if (!StringUtils.isEmpty((String)pattern)) {
            String[][] result = AttachmentSecurityHelper.getPatternString(pattern);
            String[] errorList = result[1];
            boolean hasErrorItem = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < errorList.length; ++i) {
                if (errorList[i] == null) continue;
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(errorList[i]);
                hasErrorItem = true;
            }
            if (hasErrorItem) {
                throw new BOSException("\u683c\u5f0f\uff1a" + sb.toString() + "\u76ee\u524d\u4e0d\u652f\u6301\u9644\u4ef6\u5185\u5bb9\u6821\u9a8c\uff01");
            }
        }
    }
}

