/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.attachment.AttchMoveFacadeFactory;
import com.kingdee.eas.base.attachment.SimpleAttchMoveInfo;
import com.kingdee.eas.base.attachment.client.AbstractAttchMovingUI;
import com.kingdee.eas.base.attachment.client.AttchMoveOverUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class AttchMovingUI
extends AbstractAttchMovingUI {
    private static final Logger logger = CoreUIObject.getLogger(AttchMovingUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.attachment.AttachmentResources";
    private IUIWindow attchMovingUI;
    private long sucessCount;
    private SimpleAttchMoveInfo attchMoveInfo;
    private Timer timer;
    boolean isSucess = true;

    public AttchMovingUI() throws Exception {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public AttchMovingUI(Integer type, SimpleAttchMoveInfo attchMoveInfo) throws Exception {
        this.getUIContext().put("AttchMoveType", type);
        this.getUIContext().put("attchMoveInfo", attchMoveInfo);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.labMsg.setHorizontalAlignment(0);
        new Thread(new AttchMove()).start();
        this.btnComplete.setEnabled(false);
        this.kdlSucess.setForeground(Color.RED);
        this.kdlSucess.setText("0.0%");
        this.attchMoveInfo = (SimpleAttchMoveInfo)this.getUIContext().get("attchMoveInfo");
        this.timer = new Timer();
        Progress progress = new Progress();
        this.timer.schedule((TimerTask)progress, 1000L, 2000L);
    }

    public void show() {
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.attchMovingUI = uiFactory.create(AttchMovingUI.class.getName(), this.getUIContext());
            this.attchMovingUI.show();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void attchMoving() throws EASBizException, BOSException {
        Integer i = (Integer)this.getUIContext().get("AttchMoveType");
        AttchMoveFacadeFactory.getRemoteInstance().updateMoving(true);
        this.isSucess = AttchMoveFacadeFactory.getRemoteInstance().attchMove(i);
        this.complete();
    }

    private void complete() {
        if (this.isSucess) {
            this.kdlMessage.setText(EASResource.getString((String)RESOURCE, (String)"AttchMoveSucess"));
        } else {
            this.kdlMessage.setText(EASResource.getString((String)RESOURCE, (String)"AttchMoveFail"));
        }
        this.timer.cancel();
        this.refreshSucessCount();
        this.btnComplete.setEnabled(true);
        this.btnCancel.setEnabled(false);
        this.pageContentPanel.repaint();
    }

    private void refreshSucessCount() {
        try {
            this.sucessCount = AttchMoveFacadeFactory.getRemoteInstance().getSucessCount();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.sucessCount = 0L;
        }
        if (this.attchMoveInfo != null) {
            NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
            df.setMaximumFractionDigits(1);
            double process = (double)this.sucessCount * 100.0 / (double)this.attchMoveInfo.getAttchCount();
            this.kdlSucess.setText(df.format(process) + "%");
            this.kdlSucess.repaint();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancel();
    }

    private void cancel() throws EASBizException, BOSException {
        this.kdlMessage.setText(EASResource.getString((String)RESOURCE, (String)"CancelAttchMove"));
        this.btnCancel.setEnabled(false);
        AttchMoveFacadeFactory.getRemoteInstance().updateMoving(false);
    }

    @Override
    protected void btnComplete_actionPerformed(ActionEvent e) throws Exception {
        this.closeWindow();
        AttchMoveOverUI attchMoveOverUI = new AttchMoveOverUI((SimpleAttchMoveInfo)this.getUIContext().get("attchMoveInfo"));
        attchMoveOverUI.show();
    }

    public boolean destroyWindow() {
        try {
            this.cancel();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return true;
    }

    public boolean closeWindow() {
        this.timer.cancel();
        return super.destroyWindow();
    }

    class Progress
    extends TimerTask {
        Progress() {
        }

        @Override
        public void run() {
            if (AttchMovingUI.this.isSucess) {
                AttchMovingUI.this.refreshSucessCount();
            } else {
                AttchMovingUI.this.complete();
            }
        }
    }

    class AttchMove
    implements Runnable {
        AttchMove() {
        }

        @Override
        public void run() {
            try {
                AttchMovingUI.this.attchMoving();
            }
            catch (Exception e) {
                logger.error((Object)e);
                AttchMovingUI.this.isSucess = false;
            }
        }
    }
}

